/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.tsfile.subscription;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.session.subscription.consumer.tree.SubscriptionTreePullConsumer;
import org.apache.iotdb.session.subscription.model.Topic;
import org.apache.iotdb.session.subscription.payload.SubscriptionMessage;
import org.apache.iotdb.session.subscription.payload.SubscriptionTsFileHandler;
import org.apache.iotdb.tool.tsfile.subscription.AbstractSubscriptionTsFile;
import org.apache.iotdb.tool.tsfile.subscription.CommonParam;

public class SubscriptionTreeTsFile
extends AbstractSubscriptionTsFile {
    @Override
    public void createTopics(String topicName) throws IoTDBConnectionException, StatementExecutionException {
        Properties properties = new Properties();
        properties.put("mode", "snapshot");
        properties.put("format", "TsFileHandler");
        properties.put("strict", (Object)false);
        properties.put("loose-range", "");
        if (StringUtils.isNotBlank((CharSequence)commonParam.getStartTime())) {
            properties.put("start-time", commonParam.getStartTime());
        }
        if (StringUtils.isNotBlank((CharSequence)commonParam.getEndTime())) {
            properties.put("end-time", commonParam.getEndTime());
        }
        properties.put("path", StringUtils.isNotBlank((CharSequence)commonParam.getPath()) ? commonParam.getPath() : commonParam.getPathFull());
        commonParam.getTreeSubs().createTopic(topicName, properties);
    }

    @Override
    public void doClean() throws Exception {
        List<SubscriptionTreePullConsumer> pullTreeConsumers = commonParam.getPullTreeConsumers();
        for (int i = commonParam.getStartIndex(); i < pullTreeConsumers.size(); ++i) {
            SubscriptionTreePullConsumer consumer = pullTreeConsumers.get(i);
            String path = commonParam.getTargetDir() + File.separator + consumer.getConsumerGroupId() + File.separator + consumer.getConsumerId();
            File file = new File(path);
            if (!file.exists()) continue;
            FileUtils.deleteFileOrDirectory((File)file);
        }
        for (Topic topic : commonParam.getTreeSubs().getTopics()) {
            try {
                commonParam.getTreeSubs().dropTopicIfExists(topic.getTopicName());
            }
            catch (Exception exception) {}
        }
        commonParam.getTreeSubs().close();
    }

    @Override
    public void createConsumers(String groupId) {
        CommonParam.setPullTreeConsumers(new ArrayList<SubscriptionTreePullConsumer>(commonParam.getConsumerCount()));
        for (int i = commonParam.getStartIndex(); i < commonParam.getConsumerCount(); ++i) {
            commonParam.getPullTreeConsumers().add(new SubscriptionTreePullConsumer.Builder().host(commonParam.getSrcHost()).port(Integer.valueOf(commonParam.getSrcPort())).consumerId("consumer_" + i).consumerGroupId(groupId).autoCommit(false).autoCommitIntervalMs(5000L).fileSaveDir(commonParam.getTargetDir()).buildPullConsumer());
        }
        commonParam.getPullTreeConsumers().removeIf(consumer -> {
            try {
                consumer.open();
                return false;
            }
            catch (SubscriptionException e) {
                return true;
            }
        });
        CommonParam.setConsumerCount(commonParam.getPullTreeConsumers().size());
    }

    @Override
    public void subscribe(String topicName) throws IoTDBConnectionException, StatementExecutionException {
        List<SubscriptionTreePullConsumer> pullTreeConsumers = commonParam.getPullTreeConsumers();
        for (int i = 0; i < pullTreeConsumers.size(); ++i) {
            try {
                pullTreeConsumers.get(i).subscribe(topicName);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    @Override
    public void consumerPoll(ExecutorService executor, final String topicName) {
        List<SubscriptionTreePullConsumer> pullTreeConsumers = commonParam.getPullTreeConsumers();
        for (int i = commonParam.getStartIndex(); i < pullTreeConsumers.size(); ++i) {
            final SubscriptionTreePullConsumer consumer = commonParam.getPullTreeConsumers().get(i);
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    int retryCount = 0;
                    block4: while (true) {
                        try {
                            block5: while (true) {
                                List messages = consumer.poll(Duration.ofMillis(10000L));
                                consumer.commitSync((Iterable)messages);
                                if (messages.isEmpty() && ++retryCount >= 2) break block4;
                                Iterator iterator = messages.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) continue block5;
                                    SubscriptionMessage message = (SubscriptionMessage)iterator.next();
                                    SubscriptionTsFileHandler fp = message.getTsFileHandler();
                                    AbstractSubscriptionTsFile.ioTPrinter.println(fp.getFile().getName());
                                    try {
                                        fp.moveFile(Paths.get(AbstractSubscriptionTsFile.commonParam.getTargetDir() + File.separator + consumer.getConsumerGroupId(), fp.getPath().getFileName().toString()));
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                    AbstractSubscriptionTsFile.commonParam.getCountFile().incrementAndGet();
                                }
                                break;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.out);
                            continue;
                        }
                        break;
                    }
                    consumer.unsubscribe(topicName);
                }
            });
        }
    }
}

