/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.db.utils.datastructure.MultiTVListIterator;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.Pair;

public class MergeSortMultiTVListIterator
extends MultiTVListIterator {
    private final List<Integer> probeIterators;
    private final PriorityQueue<Pair<Long, Integer>> minHeap = new PriorityQueue((a, b) -> ((Long)a.left).equals(b.left) ? ((Integer)b.right).compareTo((Integer)a.right) : ((Long)a.left).compareTo((Long)b.left));

    public MergeSortMultiTVListIterator(TSDataType tsDataType, List<TVList> tvLists, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding) {
        super(tsDataType, tvLists, deletionList, floatPrecision, encoding);
        this.probeIterators = IntStream.range(0, this.tvListIterators.size()).boxed().collect(Collectors.toList());
    }

    @Override
    protected void prepareNext() {
        this.hasNext = false;
        for (int i : this.probeIterators) {
            TVList.TVListIterator iterator = (TVList.TVListIterator)this.tvListIterators.get(i);
            if (!iterator.hasNextTimeValuePair()) continue;
            this.minHeap.add((Pair<Long, Integer>)new Pair((Object)iterator.currentTime(), (Object)i));
        }
        this.probeIterators.clear();
        if (!this.minHeap.isEmpty()) {
            Pair<Long, Integer> top = this.minHeap.poll();
            this.iteratorIndex = (Integer)top.right;
            this.probeIterators.add(this.iteratorIndex);
            this.rowIndex = ((TVList.TVListIterator)this.tvListIterators.get(this.iteratorIndex)).getIndex();
            this.hasNext = true;
            while (!this.minHeap.isEmpty() && ((Long)this.minHeap.peek().left).longValue() == ((Long)top.left).longValue()) {
                Pair<Long, Integer> element = this.minHeap.poll();
                this.probeIterators.add((Integer)element.right);
            }
        }
        this.probeNext = true;
    }

    @Override
    protected void next() {
        for (int index : this.probeIterators) {
            ((TVList.TVListIterator)this.tvListIterators.get(index)).next();
        }
        this.probeNext = false;
    }
}

