/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.modification;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.v1.Deletion;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeDeletionEntry
extends ModEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeDeletionEntry.class);
    private MeasurementPath pathPattern;

    public TreeDeletionEntry() {
        super(ModEntry.ModType.TREE_DELETION);
    }

    public TreeDeletionEntry(MeasurementPath path, long start, long end) {
        this(path, new TimeRange(start, end));
    }

    public TreeDeletionEntry(MeasurementPath path, TimeRange timeRange) {
        this();
        this.pathPattern = path;
        this.timeRange = timeRange;
    }

    @TestOnly
    public TreeDeletionEntry(MeasurementPath path, long endTime) {
        this();
        this.pathPattern = path;
        this.timeRange = new TimeRange(Long.MIN_VALUE, endTime);
    }

    public TreeDeletionEntry(TreeDeletionEntry another) {
        this(another.pathPattern, new TimeRange(another.timeRange.getMin(), another.timeRange.getMax()));
    }

    public TreeDeletionEntry(Deletion deletion) {
        this(deletion.getPath(), deletion.getTimeRange());
    }

    @Override
    public int serializedSize() {
        String patternFullPath = this.pathPattern.getFullPath();
        int length = patternFullPath.length();
        return super.serializedSize() + ReadWriteForEncodingUtils.varIntSize((int)length) + length * 2;
    }

    @Override
    public long serialize(OutputStream stream) throws IOException {
        long size = super.serialize(stream);
        return size += (long)ReadWriteIOUtils.writeVar((String)this.pathPattern.getFullPath(), (OutputStream)stream);
    }

    @Override
    public long serialize(ByteBuffer buffer) {
        long size = super.serialize(buffer);
        return size += (long)ReadWriteIOUtils.writeVar((String)this.pathPattern.getFullPath(), (ByteBuffer)buffer);
    }

    @Override
    public void deserialize(InputStream stream) throws IOException {
        super.deserialize(stream);
        try {
            this.pathPattern = new MeasurementPath(ReadWriteIOUtils.readVarIntString((InputStream)stream));
        }
        catch (IllegalPathException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        super.deserialize(buffer);
        try {
            this.pathPattern = new MeasurementPath(ReadWriteIOUtils.readVarIntString((ByteBuffer)buffer));
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean matches(PartialPath path) {
        return this.pathPattern.matchFullPath(path);
    }

    @Override
    public boolean affects(IDeviceID deviceID, long startTime, long endTime) {
        return this.affects(deviceID) && ModificationUtils.overlap(this.getStartTime(), this.getEndTime(), startTime, endTime);
    }

    @Override
    public boolean affects(IDeviceID deviceID) {
        try {
            if (this.pathPattern.endWithMultiLevelWildcard()) {
                PartialPath deviceIdPath = new PartialPath(deviceID);
                return this.pathPattern.getDevicePath().matchFullPath(deviceIdPath) || this.pathPattern.matchFullPath(deviceIdPath);
            }
            return this.pathPattern.getDevicePath().matchFullPath(new PartialPath(deviceID));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean affects(String measurementID) {
        return PathPatternUtil.isNodeMatch((String)this.pathPattern.getMeasurement(), (String)measurementID);
    }

    @Override
    public boolean affectsAll(IDeviceID deviceID) {
        return this.pathPattern.matchFullPath(deviceID, "");
    }

    @Override
    public PartialPath keyOfPatternTree() {
        return this.pathPattern;
    }

    @Override
    public ModEntry clone() {
        return new TreeDeletionEntry(this);
    }

    public String toString() {
        return "TreeDeletionEntry{pathPattern=" + this.pathPattern + ", timeRange=" + this.timeRange + '}';
    }

    public PartialPath getPathPattern() {
        return this.pathPattern;
    }

    @Override
    public int compareTo(ModEntry o) {
        if (this.getType() != o.getType()) {
            return Byte.compare(this.getType().getTypeNum(), o.getType().getTypeNum());
        }
        TreeDeletionEntry o1 = (TreeDeletionEntry)o;
        return Comparator.comparing(TreeDeletionEntry::getPathPattern).thenComparing(ModEntry::getTimeRange).compare(this, o1);
    }

    public boolean intersects(TreeDeletionEntry deletion) {
        if (super.equals(deletion)) {
            return this.timeRange.intersects(deletion.getTimeRange());
        }
        return false;
    }

    public void merge(TreeDeletionEntry deletion) {
        this.timeRange.merge(deletion.getTimeRange());
    }

    public long getSerializedSize() {
        return this.modType.getSerializedSize() + 4L + (long)this.pathPattern.getFullPath().length() * 2L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeDeletionEntry that = (TreeDeletionEntry)o;
        return Objects.equals(this.pathPattern, that.pathPattern) && Objects.equals(this.timeRange, that.timeRange);
    }

    public int hashCode() {
        return Objects.hash(this.pathPattern, this.timeRange);
    }
}

