/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.parser;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.Pair;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DataType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.AstBuilder;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.CaseInsensitiveStream;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.ErrorHandler;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.ParsingException;
import org.apache.iotdb.db.relational.grammar.sql.RelationalSqlBaseListener;
import org.apache.iotdb.db.relational.grammar.sql.RelationalSqlLexer;
import org.apache.iotdb.db.relational.grammar.sql.RelationalSqlParser;

public class SqlParser {
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();
    private static final ANTLRErrorListener LEXER_ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, e, line, charPositionInLine + 1);
        }
    };
    private static final BiConsumer<RelationalSqlLexer, RelationalSqlParser> DEFAULT_PARSER_INITIALIZER = (lexer, parser) -> {};
    private static final ErrorHandler PARSER_ERROR_HANDLER = ErrorHandler.builder().specialRule(160, "<expression>").specialRule(161, "<expression>").specialRule(163, "<expression>").specialRule(164, "<expression>").specialRule(162, "<predicate>").specialRule(190, "<identifier>").specialRule(167, "<string>").specialRule(119, "<query>").specialRule(175, "<type>").specialToken(404, "<integer>").build();
    private final BiConsumer<RelationalSqlLexer, RelationalSqlParser> initializer;

    public SqlParser() {
        this(DEFAULT_PARSER_INITIALIZER);
    }

    public SqlParser(BiConsumer<RelationalSqlLexer, RelationalSqlParser> initializer) {
        this.initializer = Objects.requireNonNull(initializer, "initializer is null");
    }

    public Statement createStatement(String sql, ZoneId zoneId, IClientSession clientSession) {
        return (Statement)this.invokeParser("statement", sql, RelationalSqlParser::singleStatement, zoneId, clientSession);
    }

    public Statement createStatement(String sql, NodeLocation location, ZoneId zoneId, IClientSession clientSession) {
        return (Statement)this.invokeParser("statement", sql, Optional.ofNullable(location), RelationalSqlParser::singleStatement, zoneId, clientSession);
    }

    public Expression createExpression(String expression, ZoneId zoneId) {
        return (Expression)this.invokeParser("expression", expression, RelationalSqlParser::standaloneExpression, zoneId, null);
    }

    public DataType createType(String expression, ZoneId zoneId) {
        return (DataType)this.invokeParser("type", expression, RelationalSqlParser::standaloneType, zoneId, null);
    }

    private Node invokeParser(String name, String sql, Function<RelationalSqlParser, ParserRuleContext> parseFunction, ZoneId zoneId, IClientSession clientSession) {
        return this.invokeParser(name, sql, Optional.empty(), parseFunction, zoneId, clientSession);
    }

    private Node invokeParser(String name, String sql, Optional<NodeLocation> location, Function<RelationalSqlParser, ParserRuleContext> parseFunction, ZoneId zoneId, IClientSession clientSession) {
        long startTime = System.nanoTime();
        try {
            ParserRuleContext tree;
            RelationalSqlLexer lexer = new RelationalSqlLexer((CharStream)new CaseInsensitiveStream((CharStream)CharStreams.fromString((String)sql)));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            RelationalSqlParser parser = new RelationalSqlParser((TokenStream)tokenStream);
            this.initializer.accept(lexer, parser);
            parser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy(){

                public Token recoverInline(Parser recognizer) throws RecognitionException {
                    if (this.nextTokensContext == null) {
                        throw new InputMismatchException(recognizer);
                    }
                    throw new InputMismatchException(recognizer, this.nextTokensState, this.nextTokensContext);
                }
            });
            parser.addParseListener((ParseTreeListener)new PostProcessor(Arrays.asList(parser.getRuleNames()), parser));
            lexer.removeErrorListeners();
            lexer.addErrorListener(LEXER_ERROR_LISTENER);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)PARSER_ERROR_HANDLER);
            try {
                try {
                    ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
                    tree = parseFunction.apply(parser);
                }
                catch (ParsingException ex) {
                    tokenStream.seek(0);
                    parser.reset();
                    ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                    tree = parseFunction.apply(parser);
                }
            }
            catch (ParsingException e) {
                location.ifPresent(statementLocation -> {
                    int line = statementLocation.getLineNumber();
                    int column = statementLocation.getColumnNumber();
                    throw new ParsingException(e.getErrorMessage(), (RecognitionException)e.getCause(), e.getLineNumber() + line - 1, e.getColumnNumber() + (line == 1 ? column : 0));
                });
                throw e;
            }
            Node node = (Node)new AstBuilder(location.orElse(null), zoneId, clientSession).visit((ParseTree)tree);
            return node;
        }
        catch (StackOverflowError e) {
            throw new ParsingException(name + " is too large (stack overflow while parsing)");
        }
        finally {
            PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        }
    }

    private static class PostProcessor
    extends RelationalSqlBaseListener {
        private final List<String> ruleNames;
        private final RelationalSqlParser parser;

        public PostProcessor(List<String> ruleNames, RelationalSqlParser parser) {
            this.ruleNames = ruleNames;
            this.parser = parser;
        }

        public void exitQuotedIdentifier(RelationalSqlParser.QuotedIdentifierContext context) {
            Token token = context.QUOTED_IDENTIFIER().getSymbol();
            if (token.getText().length() == 2) {
                throw new ParsingException("Zero-length delimited identifier not allowed", null, token.getLine(), token.getCharPositionInLine() + 1);
            }
        }

        public void exitBackQuotedIdentifier(RelationalSqlParser.BackQuotedIdentifierContext context) {
            Token token = context.BACKQUOTED_IDENTIFIER().getSymbol();
            throw new ParsingException("backquoted identifiers are not supported; use double quotes to quote identifiers", null, token.getLine(), token.getCharPositionInLine() + 1);
        }

        public void exitNonReserved(RelationalSqlParser.NonReservedContext context) {
            if (!(context.getChild(0) instanceof TerminalNode)) {
                int rule = ((ParserRuleContext)context.getChild(0)).getRuleIndex();
                throw new AssertionError((Object)("nonReserved can only contain tokens. Found nested rule: " + this.ruleNames.get(rule)));
            }
            context.getParent().removeLastChild();
            Token token = (Token)context.getChild(0).getPayload();
            CommonToken newToken = new CommonToken(new Pair((Object)token.getTokenSource(), (Object)token.getInputStream()), 407, token.getChannel(), token.getStartIndex(), token.getStopIndex());
            context.getParent().addChild(this.parser.createTerminalNode(context.getParent(), (Token)newToken));
        }
    }
}

