/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;

public class SortNode
extends SingleChildProcessNode {
    protected final OrderingScheme orderingScheme;
    protected final boolean partial;
    protected boolean orderByAllIdsAndTime;

    public SortNode(PlanNodeId id, PlanNode child, OrderingScheme scheme, boolean partial, boolean orderByAllIdsAndTime) {
        super(id, child);
        this.orderingScheme = scheme;
        this.partial = partial;
        this.orderByAllIdsAndTime = orderByAllIdsAndTime;
    }

    @Override
    public PlanNode clone() {
        return new SortNode(this.id, null, this.orderingScheme, this.partial, this.orderByAllIdsAndTime);
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSort(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_SORT_NODE.serialize(byteBuffer);
        this.orderingScheme.serialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_SORT_NODE.serialize(stream);
        this.orderingScheme.serialize(stream);
    }

    public static SortNode deserialize(ByteBuffer byteBuffer) {
        OrderingScheme orderingScheme = OrderingScheme.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new SortNode(planNodeId, null, orderingScheme, false, false);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.child.getOutputSymbols();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new SortNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.orderingScheme, this.partial, this.orderByAllIdsAndTime);
    }

    public OrderingScheme getOrderingScheme() {
        return this.orderingScheme;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public boolean isOrderByAllIdsAndTime() {
        return this.orderByAllIdsAndTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SortNode sortNode = (SortNode)o;
        return Objects.equal((Object)this.orderingScheme, (Object)sortNode.orderingScheme) && this.partial == sortNode.partial;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.orderingScheme, this.partial});
    }

    public String toString() {
        return "SortNode-" + this.getPlanNodeId();
    }
}

