/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.RuleStats;

public class RuleStatsRecorder {
    private final Map<Class<?>, RuleStats> stats = new HashMap();

    public void registerAll(Collection<Rule<?>> rules) {
        for (Rule<?> rule : rules) {
            Preconditions.checkArgument((!rule.getClass().isAnonymousClass() ? 1 : 0) != 0);
            this.stats.put(rule.getClass(), new RuleStats());
        }
    }

    public void record(Rule<?> rule, long nanos, boolean match) {
        this.stats.get(rule.getClass()).record(nanos, match);
    }

    public void recordFailure(Rule<?> rule) {
        this.stats.get(rule.getClass()).recordFailure();
    }

    public Map<Class<?>, RuleStats> getStats() {
        return ImmutableMap.copyOf(this.stats);
    }
}

