/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import java.util.Objects;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.queryengine.execution.driver.DataDriver;
import org.apache.iotdb.db.queryengine.execution.driver.DataDriverContext;
import org.apache.iotdb.db.queryengine.execution.driver.Driver;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.driver.SchemaDriver;
import org.apache.iotdb.db.queryengine.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.source.ExchangeOperator;

public class PipelineDriverFactory {
    private final DriverContext driverContext;
    private final Operator operation;
    private final long estimatedMemorySize;

    public PipelineDriverFactory(Operator operation, DriverContext driverContext, long estimatedMemorySize) {
        this.operation = Objects.requireNonNull(operation, "rootOperator is null");
        this.driverContext = driverContext;
        this.estimatedMemorySize = estimatedMemorySize;
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public Driver createDriver() {
        Objects.requireNonNull(this.driverContext, "driverContext is null");
        try {
            Driver driver = null;
            driver = this.driverContext instanceof DataDriverContext ? new DataDriver(this.operation, this.driverContext, this.estimatedMemorySize) : new SchemaDriver(this.operation, (SchemaDriverContext)this.driverContext);
            return driver;
        }
        catch (Throwable failure) {
            block4: {
                try {
                    this.operation.close();
                }
                catch (Throwable closeFailure) {
                    if (failure == closeFailure) break block4;
                    failure.addSuppressed(closeFailure);
                }
            }
            throw failure;
        }
    }

    public void setDependencyPipeline(int dependencyDriverIndex) {
        this.driverContext.setDependencyDriverIndex(dependencyDriverIndex);
    }

    public int getDependencyPipelineIndex() {
        return this.driverContext.getDependencyDriverIndex();
    }

    public void setDownstreamOperator(ExchangeOperator exchangeOperator) {
        this.driverContext.setDownstreamOperator(exchangeOperator);
    }

    @TestOnly
    public Operator getOperation() {
        return this.operation;
    }
}

