/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.model.ModelInformation;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.SchemaNodeManagementPartition;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.ainode.GetModelInfoException;
import org.apache.iotdb.db.exception.metadata.template.TemplateIncompatibleException;
import org.apache.iotdb.db.exception.metadata.view.UnsupportedViewException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.queryengine.common.DeviceContext;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.TimeseriesContext;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.IMeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.execution.operator.window.WindowType;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.BottomInferenceWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.CountInferenceWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.CountInferenceWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.HeadInferenceWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.InferenceWindow;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.InferenceWindowType;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.TailInferenceWindow;
import org.apache.iotdb.db.queryengine.metric.QueryPlanCostMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.AnalyzeUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.ColumnPaginationController;
import org.apache.iotdb.db.queryengine.plan.analyze.ConcatPathRewriter;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionTypeAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.GroupByLevelHelper;
import org.apache.iotdb.db.queryengine.plan.analyze.IModelFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.ModelFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.PredicateUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.analyze.SelectIntoUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.TemplatedAnalyze;
import org.apache.iotdb.db.queryengine.plan.analyze.load.LoadTsFileAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.DataNodeSchemaLockManager;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.SchemaLockType;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.SchemaValidator;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionFactory;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.other.GroupByTimeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExistUnknownTypeInExpression;
import org.apache.iotdb.db.queryengine.plan.optimization.LimitOffsetPushDown;
import org.apache.iotdb.db.queryengine.plan.parser.ASTVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.MeasurementGroup;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.DeviceViewIntoPathDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.FillDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByConditionParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByCountParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupBySessionParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByVariationParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.IntoPathDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.DataNodeLocationSupplierFactory;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.component.FillComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByConditionComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByCountComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupBySessionComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByVariationComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.IntoComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.apache.iotdb.db.queryengine.plan.statement.component.WhereCondition;
import org.apache.iotdb.db.queryengine.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.DeviceSchemaFetchStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalBatchActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.SeriesSchemaFetchStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountDevicesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountLevelTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountNodesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowChildNodesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowChildPathsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowCurrentTimestampStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowDevicesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.BatchActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowNodesInSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowPathSetTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowPathsUsingTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.CreateLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.ShowLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.pipe.PipeEnrichedStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ExplainAnalyzeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ExplainStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ShowQueriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ShowVersionStatement;
import org.apache.iotdb.db.schemaengine.schemaregion.view.visitor.GetSourcePathsVisitor;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeVisitor
extends StatementVisitor<Analysis, MPPQueryContext> {
    private static final Logger logger = LoggerFactory.getLogger(AnalyzeVisitor.class);
    static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    static final Expression DEVICE_EXPRESSION = TimeSeriesOperand.constructColumnHeaderExpression("Device", TSDataType.TEXT);
    public static final Expression END_TIME_EXPRESSION = TimeSeriesOperand.constructColumnHeaderExpression("__endTime", TSDataType.INT64);
    private static final String INFERENCE_COLUMN_NAME = "output";
    private final List<String> lastQueryColumnNames = new ArrayList<String>(Arrays.asList("TIME", "TIMESERIES", "VALUE", "DATATYPE"));
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;
    private final IModelFetcher modelFetcher;
    public static final String WHERE_WRONG_TYPE_ERROR_MSG = "The output type of the expression in WHERE clause should be BOOLEAN, actual data type: %s.";

    public AnalyzeVisitor(IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
        this.modelFetcher = ModelFetcher.getInstance();
    }

    @Override
    public Analysis visitNode(StatementNode node, MPPQueryContext context) {
        throw new UnsupportedOperationException("Unsupported statement type: " + node.getClass().getName());
    }

    @Override
    public Analysis visitExplain(ExplainStatement explainStatement, MPPQueryContext context) {
        Analysis analysis = this.visitQuery(explainStatement.getQueryStatement(), context);
        analysis.setRealStatement(explainStatement);
        analysis.setFinishQueryAfterAnalyze(true);
        analysis.setDatabaseName(context.getDatabaseName().orElse(null));
        return analysis;
    }

    @Override
    public Analysis visitExplainAnalyze(ExplainAnalyzeStatement explainAnalyzeStatement, MPPQueryContext context) {
        Analysis analysis = this.visitQuery(explainAnalyzeStatement.getQueryStatement(), context);
        context.setExplainAnalyze(true);
        analysis.setRealStatement(explainAnalyzeStatement);
        analysis.setRespDatasetHeader(new DatasetHeader(Collections.singletonList(new ColumnHeader("Explain Analyze", TSDataType.TEXT, null)), true));
        analysis.setDatabaseName(context.getDatabaseName().orElse(null));
        return analysis;
    }

    @Override
    public Analysis visitQuery(QueryStatement queryStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setLastLevelUseWildcard(queryStatement.isLastLevelUseWildcard());
        try {
            List<Pair<Expression, String>> outputExpressions;
            queryStatement.semanticCheck();
            this.analyzeModelInference(analysis, queryStatement);
            ISchemaTree schemaTree = this.analyzeSchema(queryStatement, analysis, context);
            if (schemaTree.isEmpty()) {
                return this.finishQuery(queryStatement, analysis);
            }
            this.analyzeGlobalTimeFilter(analysis, queryStatement);
            if (queryStatement.isLastQuery()) {
                return this.analyzeLastQuery(queryStatement, analysis, schemaTree, context);
            }
            if (queryStatement.isAlignByDevice()) {
                List<PartialPath> deviceList = this.analyzeFrom(queryStatement, schemaTree);
                if (deviceList.size() > 1 && TemplatedAnalyze.canBuildPlanUseTemplate(analysis, queryStatement, this.partitionFetcher, schemaTree, context, deviceList)) {
                    return analysis;
                }
                if (LimitOffsetPushDown.canPushDownLimitOffsetInGroupByTimeForDevice(queryStatement)) {
                    deviceList = LimitOffsetPushDown.pushDownLimitOffsetInGroupByTimeForDevice(deviceList, queryStatement, context.getZoneId());
                }
                if ((outputExpressions = this.analyzeSelect(analysis, queryStatement, schemaTree, deviceList, context)).isEmpty()) {
                    return this.finishQuery(queryStatement, analysis);
                }
                this.analyzeDeviceToWhere(analysis, queryStatement, schemaTree, deviceList, context);
                if (deviceList.isEmpty()) {
                    return this.finishQuery(queryStatement, analysis, outputExpressions);
                }
                analysis.setDeviceList(deviceList);
                this.analyzeDeviceToGroupBy(analysis, queryStatement, schemaTree, deviceList, context);
                this.analyzeDeviceToOrderBy(analysis, queryStatement, schemaTree, deviceList, context);
                this.analyzeHaving(analysis, queryStatement, schemaTree, deviceList, context);
                this.analyzeDeviceToAggregation(analysis, queryStatement);
                this.analyzeDeviceToSourceTransform(analysis, queryStatement);
                this.analyzeDeviceToSource(analysis, queryStatement);
                this.analyzeDeviceViewOutput(analysis, queryStatement);
                this.analyzeDeviceViewInput(analysis, queryStatement);
                this.analyzeInto(analysis, queryStatement, deviceList, outputExpressions, context);
            } else {
                if (queryStatement.isGroupByLevel()) {
                    GroupByLevelHelper groupByLevelHelper = new GroupByLevelHelper(queryStatement.getGroupByLevelComponent().getLevels());
                    outputExpressions = this.analyzeGroupByLevelSelect(analysis, queryStatement, schemaTree, groupByLevelHelper, context);
                    if (outputExpressions.isEmpty()) {
                        return this.finishQuery(queryStatement, analysis);
                    }
                    analysis.setOutputExpressions(outputExpressions);
                    this.setSelectExpressions(analysis, queryStatement, outputExpressions);
                    this.analyzeGroupByLevelHaving(analysis, queryStatement, schemaTree, groupByLevelHelper, context);
                    this.analyzeGroupByLevelOrderBy(analysis, queryStatement, schemaTree, groupByLevelHelper, context);
                    this.checkDataTypeConsistencyInGroupByLevel(analysis, groupByLevelHelper.getGroupByLevelExpressions());
                    analysis.setCrossGroupByExpressions(groupByLevelHelper.getGroupByLevelExpressions());
                } else {
                    outputExpressions = this.analyzeSelect(analysis, queryStatement, schemaTree, context);
                    this.analyzeGroupByTag(analysis, queryStatement, outputExpressions);
                    if (outputExpressions.isEmpty()) {
                        return this.finishQuery(queryStatement, analysis);
                    }
                    analysis.setOutputExpressions(outputExpressions);
                    this.setSelectExpressions(analysis, queryStatement, outputExpressions);
                    this.analyzeHaving(analysis, queryStatement, schemaTree, context);
                    this.analyzeOrderBy(analysis, queryStatement, schemaTree, context);
                }
                this.analyzeAggregation(analysis, queryStatement);
                this.analyzeGroupBy(analysis, queryStatement, schemaTree, context);
                this.analyzeWhere(analysis, queryStatement, schemaTree, context);
                if (analysis.getWhereExpression() != null && analysis.getWhereExpression().equals(ConstantOperand.FALSE)) {
                    return this.finishQuery(queryStatement, analysis, outputExpressions);
                }
                this.analyzeSourceTransform(analysis, outputExpressions, queryStatement);
                this.analyzeSource(analysis, queryStatement);
                this.analyzeInto(analysis, queryStatement, outputExpressions, context);
            }
            AnalyzeVisitor.analyzeGroupByTime(analysis, queryStatement);
            context.generateGlobalTimeFilter(analysis);
            AnalyzeVisitor.analyzeFill(analysis, queryStatement);
            AnalyzeVisitor.analyzeOutput(analysis, queryStatement, outputExpressions);
            this.analyzeDataPartition(analysis, queryStatement, schemaTree, context);
        }
        catch (StatementAnalyzeException e) {
            throw new StatementAnalyzeException("Meet error when analyzing the query statement: " + e.getMessage());
        }
        return analysis;
    }

    private void analyzeModelInference(Analysis analysis, QueryStatement queryStatement) {
        if (!queryStatement.hasModelInference()) {
            return;
        }
        String modelId = queryStatement.getModelName();
        TSStatus status = this.modelFetcher.fetchModel(modelId, analysis);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new GetModelInfoException(status.getMessage());
        }
        ModelInformation modelInformation = analysis.getModelInformation();
        if (modelInformation == null || !modelInformation.available()) {
            throw new SemanticException("Model " + modelId + " is not active");
        }
        if (queryStatement.isSetInferenceWindow()) {
            InferenceWindow window = queryStatement.getInferenceWindow();
            if (InferenceWindowType.HEAD == window.getType()) {
                long windowSize = ((HeadInferenceWindow)window).getWindowSize();
                this.checkWindowSize(windowSize, modelInformation);
                if (queryStatement.hasLimit() && queryStatement.getRowLimit() < windowSize) {
                    throw new SemanticException("Limit in Sql should be larger than window size in inference");
                }
                queryStatement.setRowLimit(windowSize);
            } else if (InferenceWindowType.TAIL == window.getType()) {
                long windowSize = ((TailInferenceWindow)window).getWindowSize();
                this.checkWindowSize(windowSize, modelInformation);
                BottomInferenceWindowParameter inferenceWindowParameter = new BottomInferenceWindowParameter(windowSize);
                analysis.getModelInferenceDescriptor().setInferenceWindowParameter(inferenceWindowParameter);
            } else if (InferenceWindowType.COUNT == window.getType()) {
                CountInferenceWindow countInferenceWindow = (CountInferenceWindow)window;
                this.checkWindowSize(countInferenceWindow.getInterval(), modelInformation);
                CountInferenceWindowParameter inferenceWindowParameter = new CountInferenceWindowParameter(countInferenceWindow.getInterval(), countInferenceWindow.getStep());
                analysis.getModelInferenceDescriptor().setInferenceWindowParameter(inferenceWindowParameter);
            }
        }
        if (queryStatement.hasInferenceAttributes()) {
            analysis.getModelInferenceDescriptor().setInferenceAttributes(queryStatement.getInferenceAttributes());
        }
    }

    private void checkWindowSize(long windowSize, ModelInformation modelInformation) {
        if (modelInformation.isBuiltIn()) {
            return;
        }
        if ((long)modelInformation.getInputShape()[0] != windowSize) {
            throw new SemanticException(String.format("Window output %d is not equal to input size of model %d", windowSize, modelInformation.getInputShape()[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISchemaTree analyzeSchema(QueryStatement queryStatement, Analysis analysis, MPPQueryContext context) {
        ISchemaTree schemaTree;
        ConcatPathRewriter concatPathRewriter = new ConcatPathRewriter();
        queryStatement = (QueryStatement)concatPathRewriter.rewrite(queryStatement, new PathPatternTree(queryStatement.useWildcard()), context);
        analysis.setRealStatement(queryStatement);
        long startTime = System.nanoTime();
        try {
            logger.debug("[StartFetchSchema]");
            PathPatternTree authorizedPatternTree = queryStatement.getAuthorityScope();
            boolean allWildcardLeaf = !authorizedPatternTree.isContainFullPath() && authorizedPatternTree.isContainWildcard();
            schemaTree = queryStatement.isGroupByTag() ? this.schemaFetcher.fetchSchemaWithTags(concatPathRewriter.getPatternTree(), allWildcardLeaf, context) : this.schemaFetcher.fetchSchema(concatPathRewriter.getPatternTree(), allWildcardLeaf, context);
            this.updateSchemaTreeByViews(analysis, schemaTree, context);
        }
        finally {
            logger.debug("[EndFetchSchema]");
            long schemaFetchCost = System.nanoTime() - startTime;
            context.setFetchSchemaCost(schemaFetchCost);
            QueryPlanCostMetricSet.getInstance().recordTreePlanCost("schema_fetcher", schemaFetchCost);
        }
        analysis.setSchemaTree(schemaTree);
        return schemaTree;
    }

    private Analysis finishQuery(QueryStatement queryStatement, Analysis analysis) {
        if (queryStatement.isSelectInto()) {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getSelectIntoHeader(queryStatement.isAlignByDevice()));
        }
        if (queryStatement.isLastQuery()) {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getLastQueryHeader());
        }
        analysis.setFinishQueryAfterAnalyze(true);
        return analysis;
    }

    private Analysis finishQuery(QueryStatement queryStatement, Analysis analysis, List<Pair<Expression, String>> outputExpressions) {
        AnalyzeVisitor.analyzeOutput(analysis, queryStatement, outputExpressions);
        analysis.setFinishQueryAfterAnalyze(true);
        return analysis;
    }

    private void analyzeGlobalTimeFilter(Analysis analysis, QueryStatement queryStatement) {
        Expression globalTimePredicate = null;
        boolean hasValueFilter = false;
        if (queryStatement.getWhereCondition() != null) {
            WhereCondition whereCondition = queryStatement.getWhereCondition();
            Expression predicate = whereCondition.getPredicate();
            Pair<Expression, Boolean> resultPair = PredicateUtils.extractGlobalTimePredicate(predicate, true, true);
            globalTimePredicate = (Expression)resultPair.left;
            if (globalTimePredicate != null) {
                globalTimePredicate = PredicateUtils.predicateRemoveNot(globalTimePredicate);
            }
            hasValueFilter = (Boolean)resultPair.right;
            predicate = PredicateUtils.simplifyPredicate(predicate);
            if (!hasValueFilter || predicate.equals(ConstantOperand.TRUE)) {
                queryStatement.setWhereCondition(null);
            } else {
                whereCondition.setPredicate(predicate);
            }
        }
        analysis.setGlobalTimePredicate(globalTimePredicate);
        analysis.setHasValueFilter(hasValueFilter);
    }

    private Analysis analyzeLastQuery(QueryStatement queryStatement, Analysis analysis, ISchemaTree schemaTree, MPPQueryContext context) {
        if (analysis.hasValueFilter()) {
            throw new SemanticException("Only time filters are supported in LAST query");
        }
        this.analyzeLastOrderBy(analysis, queryStatement);
        ArrayList<Expression> selectExpressions = new ArrayList<Expression>();
        for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
            selectExpressions.add(resultColumn.getExpression());
        }
        this.analyzeLastSource(analysis, selectExpressions, schemaTree, context);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getLastQueryHeader());
        this.analyzeDataPartition(analysis, queryStatement, schemaTree, context);
        return analysis;
    }

    private void analyzeLastSource(Analysis analysis, List<Expression> selectExpressions, ISchemaTree schemaTree, MPPQueryContext context) {
        LinkedHashSet<Expression> sourceExpressions = new LinkedHashSet<Expression>();
        LinkedHashSet<Expression> lastQueryBaseExpressions = new LinkedHashSet<Expression>();
        HashMap<Expression, List<Expression>> lastQueryNonWritableViewSourceExpressionMap = null;
        for (Expression selectExpression : selectExpressions) {
            for (Expression lastQuerySourceExpression : ExpressionAnalyzer.bindSchemaForExpression(selectExpression, schemaTree, context)) {
                if (lastQuerySourceExpression instanceof TimeSeriesOperand) {
                    lastQueryBaseExpressions.add(lastQuerySourceExpression);
                    sourceExpressions.add(lastQuerySourceExpression);
                    continue;
                }
                if (lastQueryNonWritableViewSourceExpressionMap == null) {
                    lastQueryNonWritableViewSourceExpressionMap = new HashMap<Expression, List<Expression>>();
                }
                List<Expression> sourceExpressionsOfNonWritableView = ExpressionAnalyzer.searchSourceExpressions(lastQuerySourceExpression);
                lastQueryNonWritableViewSourceExpressionMap.putIfAbsent(lastQuerySourceExpression, sourceExpressionsOfNonWritableView);
                sourceExpressions.addAll(sourceExpressionsOfNonWritableView);
            }
        }
        analysis.setSourceExpressions(sourceExpressions);
        analysis.setLastQueryBaseExpressions(lastQueryBaseExpressions);
        analysis.setLastQueryNonWritableViewSourceExpressionMap(lastQueryNonWritableViewSourceExpressionMap);
    }

    private void updateSchemaTreeByViews(Analysis analysis, ISchemaTree originSchemaTree, MPPQueryContext context) {
        if (!originSchemaTree.hasLogicalViewMeasurement()) {
            return;
        }
        PathPatternTree patternTree = new PathPatternTree();
        boolean needToReFetch = false;
        boolean useLogicalView = false;
        try {
            for (MeasurementPath measurementPath : (List)originSchemaTree.searchMeasurementPaths((PartialPath)SchemaConstant.ALL_MATCH_PATTERN).left) {
                if (!measurementPath.getMeasurementSchema().isLogicalView()) continue;
                useLogicalView = true;
                LogicalViewSchema logicalViewSchema = (LogicalViewSchema)measurementPath.getMeasurementSchema();
                ViewExpression viewExpression = logicalViewSchema.getExpression();
                List<PartialPath> pathsNeedToReFetch = GetSourcePathsVisitor.getSourcePaths(viewExpression);
                for (PartialPath path : pathsNeedToReFetch) {
                    patternTree.appendFullPath(path);
                    needToReFetch = true;
                }
            }
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
        analysis.setUseLogicalView(useLogicalView);
        if (useLogicalView && analysis.getTreeStatement() instanceof QueryStatement && ((QueryStatement)analysis.getTreeStatement()).isGroupByTag()) {
            throw new SemanticException("Views cannot be used in GROUP BY TAGS query yet.");
        }
        if (needToReFetch) {
            ISchemaTree viewSchemaTree = this.schemaFetcher.fetchSchema(patternTree, true, context);
            originSchemaTree.mergeSchemaTree(viewSchemaTree);
            Set<String> allDatabases = viewSchemaTree.getDatabases();
            allDatabases.addAll(originSchemaTree.getDatabases());
            originSchemaTree.setDatabases(allDatabases);
        }
    }

    private List<Pair<Expression, String>> analyzeGroupByLevelSelect(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, GroupByLevelHelper groupByLevelHelper, MPPQueryContext queryContext) {
        HashMap outputExpressionMap = new HashMap();
        int columnIndex = 0;
        for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
            LinkedHashSet<Pair> outputExpressionSet = new LinkedHashSet<Pair>();
            List<Expression> resultExpressions = ExpressionAnalyzer.bindSchemaForExpression(resultColumn.getExpression(), schemaTree, queryContext);
            boolean isCountStar = resultColumn.getExpression().getExpressionType().equals((Object)ExpressionType.FUNCTION) && ((FunctionExpression)resultColumn.getExpression()).isCountStar();
            for (Expression resultExpression : resultExpressions) {
                Expression outputExpression = groupByLevelHelper.applyLevels(isCountStar, resultExpression, resultColumn.getAlias(), analysis);
                Expression normalizedOutputExpression = ExpressionAnalyzer.normalizeExpression(outputExpression);
                AnalyzeVisitor.analyzeExpressionType(analysis, normalizedOutputExpression);
                outputExpressionSet.add(new Pair((Object)normalizedOutputExpression, (Object)this.analyzeAlias(groupByLevelHelper.getAlias(outputExpression.getExpressionString()), outputExpression, normalizedOutputExpression, queryStatement)));
            }
            outputExpressionMap.put(columnIndex++, outputExpressionSet);
        }
        ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset());
        ArrayList<Pair> outputExpressions = new ArrayList<Pair>();
        block2: for (Set outputExpressionSet : outputExpressionMap.values()) {
            for (Pair outputExpression : outputExpressionSet) {
                if (paginationController.hasCurOffset()) {
                    paginationController.consumeOffset();
                    continue;
                }
                if (!paginationController.hasCurLimit()) continue block2;
                outputExpressions.add(outputExpression);
                groupByLevelHelper.updateGroupByLevelExpressions((Expression)outputExpression.left);
                paginationController.consumeLimit();
            }
        }
        return new ArrayList<Pair<Expression, String>>(outputExpressions);
    }

    private List<Pair<Expression, String>> analyzeSelect(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, MPPQueryContext queryContext) {
        HashMap outputExpressionMap = new HashMap();
        ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset());
        HashSet<String> aliasSet = new HashSet<String>();
        int columnIndex = 0;
        for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
            ArrayList<Pair> outputExpressions = new ArrayList<Pair>();
            List<Expression> resultExpressions = ExpressionAnalyzer.bindSchemaForExpression(resultColumn.getExpression(), schemaTree, queryContext);
            for (Expression resultExpression : resultExpressions) {
                if (paginationController.hasCurOffset()) {
                    paginationController.consumeOffset();
                    continue;
                }
                if (!paginationController.hasCurLimit()) break;
                this.checkAliasUniqueness(resultColumn.getAlias(), aliasSet);
                Expression normalizedExpression = ExpressionAnalyzer.normalizeExpression(resultExpression);
                AnalyzeVisitor.analyzeExpressionType(analysis, normalizedExpression);
                outputExpressions.add(new Pair((Object)normalizedExpression, (Object)this.analyzeAlias(resultColumn.getAlias(), resultExpression, normalizedExpression, queryStatement)));
                paginationController.consumeLimit();
            }
            outputExpressionMap.put(columnIndex++, outputExpressions);
        }
        ArrayList<Pair<Expression, String>> outputExpressions = new ArrayList<Pair<Expression, String>>();
        outputExpressionMap.values().forEach(outputExpressions::addAll);
        return outputExpressions;
    }

    private List<PartialPath> analyzeFrom(QueryStatement queryStatement, ISchemaTree schemaTree) {
        List<PartialPath> devicePatternList = queryStatement.getFromComponent().getPrefixPaths();
        HashSet deviceSet = new HashSet();
        for (PartialPath devicePattern : devicePatternList) {
            deviceSet.addAll(schemaTree.getMatchedDevices(devicePattern).stream().map(DeviceSchemaInfo::getDevicePath).collect(Collectors.toList()));
        }
        return queryStatement.getResultDeviceOrder() == Ordering.ASC ? deviceSet.stream().sorted().collect(Collectors.toList()) : deviceSet.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }

    private List<Pair<Expression, String>> analyzeSelect(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, List<PartialPath> deviceList, MPPQueryContext queryContext) {
        ArrayList<Pair<Expression, String>> outputExpressions = new ArrayList<Pair<Expression, String>>();
        HashMap<IDeviceID, Set<Expression>> deviceToSelectExpressions = new HashMap<IDeviceID, Set<Expression>>();
        ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset());
        block0: for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
            Expression selectExpression = resultColumn.getExpression();
            LinkedHashMap<Expression, Map<IDeviceID, Expression>> measurementToDeviceSelectExpressions = new LinkedHashMap<Expression, Map<IDeviceID, Expression>>();
            for (PartialPath partialPath : deviceList) {
                List<Expression> selectExpressionsOfOneDevice = ExpressionAnalyzer.concatDeviceAndBindSchemaForExpression(selectExpression, partialPath, schemaTree, queryContext);
                if (selectExpressionsOfOneDevice.isEmpty()) continue;
                this.updateMeasurementToDeviceSelectExpressions(analysis, measurementToDeviceSelectExpressions, partialPath.getIDeviceIDAsFullDevice(), selectExpressionsOfOneDevice);
            }
            this.checkAliasUniqueness(resultColumn.getAlias(), measurementToDeviceSelectExpressions);
            for (Map.Entry entry : measurementToDeviceSelectExpressions.entrySet()) {
                Expression measurementExpression = (Expression)entry.getKey();
                Map deviceToSelectExpressionsOfOneMeasurement = (Map)entry.getValue();
                if (paginationController.hasCurOffset()) {
                    paginationController.consumeOffset();
                    continue;
                }
                if (!paginationController.hasCurLimit()) continue block0;
                deviceToSelectExpressionsOfOneMeasurement.values().forEach(expression -> AnalyzeVisitor.analyzeExpressionType(analysis, expression));
                this.checkDataTypeConsistencyInAlignByDevice(analysis, new ArrayList<Expression>(deviceToSelectExpressionsOfOneMeasurement.values()));
                Expression lowerCaseMeasurementExpression = ExpressionAnalyzer.toLowerCaseExpression(measurementExpression);
                AnalyzeVisitor.analyzeExpressionType(analysis, lowerCaseMeasurementExpression);
                outputExpressions.add((Pair<Expression, String>)new Pair((Object)lowerCaseMeasurementExpression, (Object)this.analyzeAlias(resultColumn.getAlias(), measurementExpression, lowerCaseMeasurementExpression, queryStatement)));
                this.updateDeviceToSelectExpressions(analysis, deviceToSelectExpressions, deviceToSelectExpressionsOfOneMeasurement);
                paginationController.consumeLimit();
            }
        }
        HashSet<PartialPath> noMeasurementDevices = new HashSet<PartialPath>();
        for (PartialPath device : deviceList) {
            if (deviceToSelectExpressions.containsKey(device.getIDeviceIDAsFullDevice())) continue;
            noMeasurementDevices.add(device);
        }
        deviceList.removeAll(noMeasurementDevices);
        if (analysis.getDeviceToWhereExpression() != null) {
            noMeasurementDevices.forEach(devicePath -> analysis.getDeviceToWhereExpression().remove(devicePath.getIDeviceIDAsFullDevice()));
        }
        LinkedHashSet<Expression> linkedHashSet = new LinkedHashSet<Expression>();
        linkedHashSet.add(DEVICE_EXPRESSION);
        if (queryStatement.isOutputEndTime()) {
            linkedHashSet.add(END_TIME_EXPRESSION);
        }
        outputExpressions.forEach(pair -> selectExpressions.add((Expression)pair.getLeft()));
        analysis.setSelectExpressions(linkedHashSet);
        analysis.setDeviceToSelectExpressions(deviceToSelectExpressions);
        return outputExpressions;
    }

    private void updateMeasurementToDeviceSelectExpressions(Analysis analysis, Map<Expression, Map<IDeviceID, Expression>> measurementToDeviceSelectExpressions, IDeviceID device, List<Expression> selectExpressionsOfOneDevice) {
        for (Expression expression : selectExpressionsOfOneDevice) {
            Expression measurementExpression = ExpressionAnalyzer.getMeasurementExpression(expression, analysis);
            measurementToDeviceSelectExpressions.computeIfAbsent(measurementExpression, key -> new LinkedHashMap()).put(device, ExpressionAnalyzer.toLowerCaseExpression(expression));
        }
    }

    private void updateDeviceToSelectExpressions(Analysis analysis, Map<IDeviceID, Set<Expression>> deviceToSelectExpressions, Map<IDeviceID, Expression> deviceToSelectExpressionsOfOneMeasurement) {
        for (Map.Entry<IDeviceID, Expression> entry : deviceToSelectExpressionsOfOneMeasurement.entrySet()) {
            IDeviceID deviceID = entry.getKey();
            Expression expression = entry.getValue();
            Expression lowerCaseExpression = ExpressionAnalyzer.toLowerCaseExpression(expression);
            AnalyzeVisitor.analyzeExpressionType(analysis, lowerCaseExpression);
            deviceToSelectExpressions.computeIfAbsent(deviceID, key -> new LinkedHashSet()).add(lowerCaseExpression);
        }
    }

    private String analyzeAlias(String resultColumnAlias, Expression rawExpression, Expression normalizedExpression, QueryStatement queryStatement) {
        if (resultColumnAlias != null) {
            return resultColumnAlias;
        }
        if (queryStatement.isCountTimeAggregation()) {
            return "count_time(*)";
        }
        if (!Objects.equals(normalizedExpression, rawExpression)) {
            return rawExpression.getOutputSymbol();
        }
        return null;
    }

    private void analyzeHavingBase(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, UnaryOperator<Expression> havingExpressionAnalyzer, MPPQueryContext queryContext) {
        List<Expression> conJunctions = ExpressionAnalyzer.bindSchemaForPredicate(queryStatement.getHavingCondition().getPredicate(), queryStatement.getFromComponent().getPrefixPaths(), schemaTree, true, queryContext);
        Expression havingExpression = PredicateUtils.combineConjuncts(conJunctions.stream().distinct().collect(Collectors.toList()));
        TSDataType outputType = AnalyzeVisitor.analyzeExpressionType(analysis, havingExpression = (Expression)havingExpressionAnalyzer.apply(havingExpression));
        if (outputType != TSDataType.BOOLEAN) {
            throw new SemanticException(String.format("The output type of the expression in HAVING clause should be BOOLEAN, actual data type: %s.", outputType));
        }
        analysis.setHavingExpression(havingExpression);
    }

    private void analyzeHaving(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, MPPQueryContext queryContext) {
        if (!queryStatement.hasHaving()) {
            return;
        }
        this.analyzeHavingBase(analysis, queryStatement, schemaTree, ExpressionAnalyzer::normalizeExpression, queryContext);
    }

    private void analyzeGroupByLevelHaving(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, GroupByLevelHelper groupByLevelHelper, MPPQueryContext queryContext) {
        if (!queryStatement.hasHaving()) {
            return;
        }
        this.analyzeHavingBase(analysis, queryStatement, schemaTree, havingExpression -> PredicateUtils.removeDuplicateConjunct(groupByLevelHelper.applyLevels((Expression)havingExpression, analysis)), queryContext);
        groupByLevelHelper.updateGroupByLevelExpressions(analysis.getHavingExpression());
    }

    private void analyzeHaving(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, List<PartialPath> deviceSet, MPPQueryContext queryContext) {
        if (!queryStatement.hasHaving()) {
            return;
        }
        Map<IDeviceID, Set<Expression>> deviceToAggregationExpressions = analysis.getDeviceToAggregationExpressions();
        Map<IDeviceID, Set<Expression>> deviceToOutputExpressions = analysis.getDeviceToOutputExpressions();
        Expression havingExpression = queryStatement.getHavingCondition().getPredicate();
        HashSet conJunctions = new HashSet();
        for (PartialPath device : deviceSet) {
            List<Expression> expressionsInHaving = ExpressionAnalyzer.concatDeviceAndBindSchemaForHaving(havingExpression, device, schemaTree, queryContext);
            conJunctions.addAll(expressionsInHaving.stream().map(expression -> ExpressionAnalyzer.getMeasurementExpression(expression, analysis)).collect(Collectors.toList()));
            for (Expression expression2 : expressionsInHaving) {
                LinkedHashSet<Expression> aggregationExpressions = new LinkedHashSet<Expression>();
                LinkedHashSet<Expression> normalizedAggregationExpressions = new LinkedHashSet<Expression>();
                for (Expression aggregationExpression : ExpressionAnalyzer.searchAggregationExpressions(expression2)) {
                    Expression normalizedAggregationExpression = ExpressionAnalyzer.normalizeExpression(aggregationExpression);
                    if (!((List)new ExistUnknownTypeInExpression().process(aggregationExpression, null)).isEmpty()) continue;
                    AnalyzeVisitor.analyzeExpressionType(analysis, aggregationExpression);
                    AnalyzeVisitor.analyzeExpressionType(analysis, normalizedAggregationExpression);
                    aggregationExpressions.add(aggregationExpression);
                    normalizedAggregationExpressions.add(normalizedAggregationExpression);
                }
                deviceToOutputExpressions.computeIfAbsent(device.getIDeviceIDAsFullDevice(), key -> new LinkedHashSet()).addAll(aggregationExpressions);
                deviceToAggregationExpressions.computeIfAbsent(device.getIDeviceID(), key -> new LinkedHashSet()).addAll(normalizedAggregationExpressions);
            }
        }
        havingExpression = PredicateUtils.combineConjuncts(new ArrayList<Expression>(conJunctions));
        TSDataType outputType = AnalyzeVisitor.analyzeExpressionType(analysis, havingExpression);
        if (outputType != TSDataType.BOOLEAN) {
            throw new SemanticException(String.format("The output type of the expression in HAVING clause should be BOOLEAN, actual data type: %s.", outputType));
        }
        analysis.setDeviceToAggregationExpressions(deviceToAggregationExpressions);
        analysis.setHavingExpression(havingExpression);
    }

    private void checkDataTypeConsistencyInGroupByLevel(Analysis analysis, Map<Expression, Set<Expression>> groupByLevelExpressions) {
        for (Map.Entry<Expression, Set<Expression>> groupedExpressionRawExpressionsEntry : groupByLevelExpressions.entrySet()) {
            Expression groupedAggregationExpression = groupedExpressionRawExpressionsEntry.getKey();
            Set<Expression> rawAggregationExpressions = groupedExpressionRawExpressionsEntry.getValue();
            TSDataType checkedDataType = analysis.getType(groupedAggregationExpression);
            for (Expression rawAggregationExpression : rawAggregationExpressions) {
                if (analysis.getType(rawAggregationExpression) == checkedDataType) continue;
                throw new SemanticException(String.format("GROUP BY LEVEL: the data types of the same output column[%s] should be the same.", groupedAggregationExpression));
            }
        }
    }

    private void setSelectExpressions(Analysis analysis, QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions) {
        LinkedHashSet<Expression> selectExpressions = new LinkedHashSet<Expression>();
        if (queryStatement.isOutputEndTime()) {
            selectExpressions.add(END_TIME_EXPRESSION);
        }
        for (Pair<Expression, String> outputExpressionAndAlias : outputExpressions) {
            Expression outputExpression = (Expression)outputExpressionAndAlias.left;
            selectExpressions.add(outputExpression);
        }
        analysis.setSelectExpressions(selectExpressions);
    }

    private void analyzeGroupByTag(Analysis analysis, QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions) {
        if (!queryStatement.isGroupByTag()) {
            return;
        }
        if (analysis.hasValueFilter()) {
            throw new SemanticException("Only time filters are supported in GROUP BY TAGS query");
        }
        List<String> tagKeys = queryStatement.getGroupByTagComponent().getTagKeys();
        HashMap<List<String>, LinkedHashMap<Expression, List<Expression>>> tagValuesToGroupedTimeseriesOperands = new HashMap<List<String>, LinkedHashMap<Expression, List<Expression>>>();
        LinkedHashMap<Expression, Set<Expression>> outputExpressionToRawExpressionsMap = new LinkedHashMap<Expression, Set<Expression>>();
        for (Pair<Expression, String> outputExpressionAndAlias : outputExpressions) {
            FunctionExpression rawExpression = (FunctionExpression)outputExpressionAndAlias.getLeft();
            FunctionExpression measurementExpression = (FunctionExpression)ExpressionAnalyzer.getMeasurementExpression(rawExpression, analysis);
            outputExpressionToRawExpressionsMap.computeIfAbsent(measurementExpression, v -> new HashSet()).add(rawExpression);
            Map tagMap = ((MeasurementPath)((TimeSeriesOperand)rawExpression.getExpressions().get(0)).getPath()).getTagMap();
            ArrayList<String> tagValues = new ArrayList<String>();
            for (String tagKey : tagKeys) {
                tagValues.add((String)tagMap.get(tagKey));
            }
            tagValuesToGroupedTimeseriesOperands.computeIfAbsent(tagValues, key -> new LinkedHashMap()).computeIfAbsent(measurementExpression, key -> new ArrayList()).add(rawExpression.getExpressions().get(0));
        }
        outputExpressions.clear();
        for (String tagKey : tagKeys) {
            TimeSeriesOperand tagKeyExpression = TimeSeriesOperand.constructColumnHeaderExpression(tagKey, TSDataType.TEXT);
            AnalyzeVisitor.analyzeExpressionType(analysis, tagKeyExpression);
            outputExpressions.add((Pair<Expression, String>)new Pair((Object)tagKeyExpression, null));
        }
        for (Expression outputExpression : outputExpressionToRawExpressionsMap.keySet()) {
            AnalyzeVisitor.analyzeExpressionType(analysis, outputExpression);
            outputExpressions.add((Pair<Expression, String>)new Pair((Object)outputExpression, null));
        }
        analysis.setTagKeys(queryStatement.getGroupByTagComponent().getTagKeys());
        analysis.setTagValuesToGroupedTimeseriesOperands(tagValuesToGroupedTimeseriesOperands);
        analysis.setCrossGroupByExpressions(outputExpressionToRawExpressionsMap);
    }

    private void analyzeDeviceToAggregation(Analysis analysis, QueryStatement queryStatement) {
        if (!queryStatement.isAggregationQuery()) {
            return;
        }
        this.updateDeviceToAggregationAndOutputExpressions(analysis, analysis.getDeviceToSelectExpressions());
        if (queryStatement.hasOrderByExpression()) {
            this.updateDeviceToAggregationAndOutputExpressions(analysis, analysis.getDeviceToOrderByExpressions());
        }
    }

    private void updateDeviceToAggregationAndOutputExpressions(Analysis analysis, Map<IDeviceID, Set<Expression>> deviceToExpressions) {
        Map<IDeviceID, Set<Expression>> deviceToAggregationExpressions = analysis.getDeviceToAggregationExpressions();
        Map<IDeviceID, Set<Expression>> deviceToOutputExpressions = analysis.getDeviceToOutputExpressions();
        for (Map.Entry<IDeviceID, Set<Expression>> deviceExpressionsEntry : deviceToExpressions.entrySet()) {
            IDeviceID deviceID = deviceExpressionsEntry.getKey();
            Set<Expression> expressionSet = deviceExpressionsEntry.getValue();
            for (Expression expression : expressionSet) {
                for (Expression aggregationExpression : ExpressionAnalyzer.searchAggregationExpressions(expression)) {
                    Expression normalizedAggregationExpression = ExpressionAnalyzer.normalizeExpression(aggregationExpression);
                    AnalyzeVisitor.analyzeExpressionType(analysis, normalizedAggregationExpression);
                    deviceToOutputExpressions.computeIfAbsent(deviceID, key -> new LinkedHashSet()).add(aggregationExpression);
                    deviceToAggregationExpressions.computeIfAbsent(deviceID, key -> new LinkedHashSet()).add(normalizedAggregationExpression);
                }
            }
        }
    }

    private void analyzeAggregation(Analysis analysis, QueryStatement queryStatement) {
        if (!queryStatement.isAggregationQuery()) {
            return;
        }
        if (queryStatement.isGroupByLevel() || queryStatement.isGroupByTag()) {
            Set<Expression> aggregationExpressions = analysis.getCrossGroupByExpressions().values().stream().flatMap(Collection::stream).map(expression -> {
                Expression normalizedExpression = ExpressionAnalyzer.normalizeExpression(expression);
                AnalyzeVisitor.analyzeExpressionType(analysis, normalizedExpression);
                return normalizedExpression;
            }).collect(Collectors.toSet());
            analysis.setAggregationExpressions(aggregationExpressions);
            return;
        }
        HashSet<Expression> aggregationExpressions = new HashSet<Expression>();
        for (Expression expression2 : analysis.getSelectExpressions()) {
            aggregationExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(expression2));
        }
        if (queryStatement.hasHaving()) {
            aggregationExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(analysis.getHavingExpression()));
        }
        if (queryStatement.hasOrderByExpression()) {
            for (Expression expression2 : analysis.getOrderByExpressions()) {
                aggregationExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(expression2));
            }
        }
        analysis.setAggregationExpressions(aggregationExpressions);
    }

    private void analyzeDeviceToSourceTransform(Analysis analysis, QueryStatement queryStatement) {
        if (queryStatement.isAggregationQuery()) {
            Map<IDeviceID, Set<Expression>> deviceToSourceTransformExpressions = analysis.getDeviceToSourceTransformExpressions();
            Map<IDeviceID, Set<Expression>> deviceToAggregationExpressions = analysis.getDeviceToAggregationExpressions();
            for (Map.Entry<IDeviceID, Set<Expression>> entry : deviceToAggregationExpressions.entrySet()) {
                IDeviceID deviceID = entry.getKey();
                Set<Expression> aggregationExpressions = entry.getValue();
                Set sourceTransformExpressions = deviceToSourceTransformExpressions.computeIfAbsent(deviceID, k -> new LinkedHashSet());
                for (Expression expression : aggregationExpressions) {
                    if (queryStatement.isCountTimeAggregation()) {
                        for (Expression countTimeSourceExpression : ((FunctionExpression)expression).getCountTimeExpressions()) {
                            AnalyzeVisitor.analyzeExpressionType(analysis, countTimeSourceExpression);
                            sourceTransformExpressions.add(countTimeSourceExpression);
                        }
                        continue;
                    }
                    if ("count_if".equalsIgnoreCase(((FunctionExpression)expression).getFunctionName())) {
                        sourceTransformExpressions.add(expression.getExpressions().get(0));
                        continue;
                    }
                    sourceTransformExpressions.addAll(expression.getExpressions());
                }
                if (!queryStatement.hasGroupByExpression()) continue;
                sourceTransformExpressions.add(analysis.getDeviceToGroupByExpression().get(deviceID));
            }
        } else {
            this.updateDeviceToSourceTransformAndOutputExpressions(analysis, analysis.getDeviceToSelectExpressions());
            if (queryStatement.hasOrderByExpression()) {
                this.updateDeviceToSourceTransformAndOutputExpressions(analysis, analysis.getDeviceToOrderByExpressions());
            }
        }
    }

    private void updateDeviceToSourceTransformAndOutputExpressions(Analysis analysis, Map<IDeviceID, Set<Expression>> deviceToExpressions) {
        Map<IDeviceID, Set<Expression>> deviceToSourceTransformExpressions = analysis.getDeviceToSourceTransformExpressions();
        Map<IDeviceID, Set<Expression>> deviceToOutputExpressions = analysis.getDeviceToOutputExpressions();
        for (Map.Entry<IDeviceID, Set<Expression>> deviceExpressionsEntry : deviceToExpressions.entrySet()) {
            IDeviceID deviceID = deviceExpressionsEntry.getKey();
            Set<Expression> expressions = deviceExpressionsEntry.getValue();
            LinkedHashSet<Expression> normalizedExpressions = new LinkedHashSet<Expression>();
            for (Expression expression : expressions) {
                Expression normalizedExpression = ExpressionAnalyzer.normalizeExpression(expression);
                AnalyzeVisitor.analyzeExpressionType(analysis, normalizedExpression);
                normalizedExpressions.add(normalizedExpression);
            }
            deviceToOutputExpressions.computeIfAbsent(deviceID, key -> new LinkedHashSet()).addAll(expressions);
            deviceToSourceTransformExpressions.computeIfAbsent(deviceID, key -> new LinkedHashSet()).addAll(normalizedExpressions);
        }
    }

    private void analyzeSourceTransform(Analysis analysis, List<Pair<Expression, String>> outputExpressions, QueryStatement queryStatement) {
        Set<Expression> sourceTransformExpressions = analysis.getSourceTransformExpressions();
        if (queryStatement.isAggregationQuery()) {
            if (queryStatement.isCountTimeAggregation()) {
                for (Pair<Expression, String> pair : outputExpressions) {
                    FunctionExpression countTimeExpression = (FunctionExpression)pair.left;
                    for (Expression countTimeSourceExpression : countTimeExpression.getCountTimeExpressions()) {
                        AnalyzeVisitor.analyzeExpressionType(analysis, countTimeSourceExpression);
                        sourceTransformExpressions.add(countTimeSourceExpression);
                    }
                }
                Pair<Expression, String> firstCountTimeExpression = outputExpressions.get(0);
                outputExpressions.clear();
                outputExpressions.add(firstCountTimeExpression);
            } else {
                for (Expression aggExpression : analysis.getAggregationExpressions()) {
                    if ("count_if".equalsIgnoreCase(((FunctionExpression)aggExpression).getFunctionName())) {
                        sourceTransformExpressions.add(aggExpression.getExpressions().get(0));
                        continue;
                    }
                    sourceTransformExpressions.addAll(aggExpression.getExpressions());
                }
            }
            if (queryStatement.hasGroupByExpression()) {
                sourceTransformExpressions.add(analysis.getGroupByExpression());
            }
        } else {
            sourceTransformExpressions.addAll(analysis.getSelectExpressions());
            if (queryStatement.hasOrderByExpression()) {
                sourceTransformExpressions.addAll(analysis.getOrderByExpressions());
            }
        }
    }

    private void analyzeDeviceToSource(Analysis analysis, QueryStatement queryStatement) {
        IDeviceID deviceName;
        HashMap<IDeviceID, Set<Expression>> deviceToSourceExpressions = new HashMap<IDeviceID, Set<Expression>>();
        Map<IDeviceID, Set<Expression>> deviceToSourceTransformExpressions = analysis.getDeviceToSourceTransformExpressions();
        for (Map.Entry<IDeviceID, Set<Expression>> entry : deviceToSourceTransformExpressions.entrySet()) {
            IDeviceID iDeviceID = entry.getKey();
            Set<Expression> sourceTransformExpressions = entry.getValue();
            LinkedHashSet sourceExpressions = new LinkedHashSet();
            sourceTransformExpressions.forEach(expression -> sourceExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(expression)));
            deviceToSourceExpressions.put(iDeviceID, sourceExpressions);
        }
        if (queryStatement.hasWhere()) {
            Map<IDeviceID, Expression> deviceToWhereExpression = analysis.getDeviceToWhereExpression();
            for (Map.Entry<Object, Expression> entry : deviceToWhereExpression.entrySet()) {
                deviceName = (IDeviceID)entry.getKey();
                Expression whereExpression = entry.getValue();
                deviceToSourceExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()).addAll(ExpressionAnalyzer.searchSourceExpressions(whereExpression));
            }
        }
        LinkedHashMap<IDeviceID, IDeviceID> outputDeviceToQueriedDevicesMap = new LinkedHashMap<IDeviceID, IDeviceID>();
        for (Map.Entry<Object, Expression> entry : deviceToSourceExpressions.entrySet()) {
            deviceName = (IDeviceID)entry.getKey();
            Set sourceExpressionsUnderDevice = (Set)((Object)entry.getValue());
            HashSet<IDeviceID> queriedDevices = new HashSet<IDeviceID>();
            for (Expression expression2 : sourceExpressionsUnderDevice) {
                queriedDevices.add(ExpressionAnalyzer.getDeviceNameInSourceExpression(expression2));
            }
            if (queriedDevices.size() > 1) {
                throw new SemanticException("Cross-device queries are not supported in ALIGN BY DEVICE queries.");
            }
            outputDeviceToQueriedDevicesMap.put(deviceName, (IDeviceID)queriedDevices.iterator().next());
        }
        analysis.setDeviceToSourceExpressions(deviceToSourceExpressions);
        analysis.setOutputDeviceToQueriedDevicesMap(outputDeviceToQueriedDevicesMap);
    }

    private void analyzeSource(Analysis analysis, QueryStatement queryStatement) {
        Set<Expression> sourceExpressions = analysis.getSourceExpressions();
        if (sourceExpressions == null) {
            sourceExpressions = new HashSet<Expression>();
            analysis.setSourceExpressions(sourceExpressions);
        }
        for (Expression expression : analysis.getSourceTransformExpressions()) {
            sourceExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(expression));
        }
        Expression whereExpression = analysis.getWhereExpression();
        if (whereExpression != null) {
            sourceExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(analysis.getWhereExpression()));
        }
    }

    private void analyzeDeviceToWhere(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, List<PartialPath> deviceSet, MPPQueryContext queryContext) {
        if (!queryStatement.hasWhere()) {
            return;
        }
        HashMap<IDeviceID, Expression> deviceToWhereExpression = new HashMap<IDeviceID, Expression>();
        Iterator<PartialPath> deviceIterator = deviceSet.iterator();
        boolean hasValueFilter = false;
        while (deviceIterator.hasNext()) {
            PartialPath devicePath = deviceIterator.next();
            Expression whereExpression = this.analyzeWhereSplitByDevice(queryStatement, devicePath, schemaTree, queryContext);
            if (whereExpression.equals(ConstantOperand.FALSE)) {
                deviceIterator.remove();
                continue;
            }
            if (whereExpression.equals(ConstantOperand.TRUE)) {
                deviceToWhereExpression.put(devicePath.getIDeviceIDAsFullDevice(), null);
                continue;
            }
            TSDataType outputType = AnalyzeVisitor.analyzeExpressionType(analysis, whereExpression);
            if (outputType != TSDataType.BOOLEAN) {
                throw new SemanticException(String.format(WHERE_WRONG_TYPE_ERROR_MSG, outputType));
            }
            deviceToWhereExpression.put(devicePath.getIDeviceIDAsFullDevice(), whereExpression);
            hasValueFilter = true;
        }
        analysis.setDeviceToWhereExpression(deviceToWhereExpression);
        analysis.setHasValueFilter(hasValueFilter);
    }

    private void analyzeWhere(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, MPPQueryContext queryContext) {
        if (!queryStatement.hasWhere()) {
            return;
        }
        List<Expression> conJunctions = ExpressionAnalyzer.bindSchemaForPredicate(queryStatement.getWhereCondition().getPredicate(), queryStatement.getFromComponent().getPrefixPaths(), schemaTree, true, queryContext);
        Expression whereExpression = this.convertConJunctionsToWhereExpression(conJunctions);
        if (whereExpression.equals(ConstantOperand.TRUE)) {
            analysis.setWhereExpression(null);
            analysis.setHasValueFilter(false);
            return;
        }
        TSDataType outputType = AnalyzeVisitor.analyzeExpressionType(analysis, whereExpression);
        if (outputType != TSDataType.BOOLEAN) {
            throw new SemanticException(String.format(WHERE_WRONG_TYPE_ERROR_MSG, outputType));
        }
        analysis.setWhereExpression(whereExpression);
    }

    private Expression analyzeWhereSplitByDevice(QueryStatement queryStatement, PartialPath devicePath, ISchemaTree schemaTree, MPPQueryContext queryContext) {
        List<Expression> conJunctions = ExpressionAnalyzer.concatDeviceAndBindSchemaForPredicate(queryStatement.getWhereCondition().getPredicate(), devicePath, schemaTree, true, queryContext);
        return this.convertConJunctionsToWhereExpression(conJunctions);
    }

    private Expression convertConJunctionsToWhereExpression(List<Expression> conJunctions) {
        Expression predicate = PredicateUtils.combineConjuncts(conJunctions.stream().distinct().collect(Collectors.toList()));
        predicate = PredicateUtils.simplifyPredicate(predicate);
        predicate = ExpressionAnalyzer.normalizeExpression(predicate);
        return predicate;
    }

    private void analyzeDeviceViewOutput(Analysis analysis, QueryStatement queryStatement) {
        Set<Expression> selectExpressions = analysis.getSelectExpressions();
        LinkedHashSet<Expression> deviceViewOutputExpressions = new LinkedHashSet<Expression>();
        if (queryStatement.isAggregationQuery()) {
            deviceViewOutputExpressions.add(DEVICE_EXPRESSION);
            if (queryStatement.isOutputEndTime()) {
                deviceViewOutputExpressions.add(END_TIME_EXPRESSION);
            }
            for (Expression selectExpression : selectExpressions) {
                deviceViewOutputExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(selectExpression));
            }
            if (queryStatement.hasHaving()) {
                deviceViewOutputExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(analysis.getHavingExpression()));
            }
            if (queryStatement.hasOrderByExpression()) {
                for (Expression orderByExpression : analysis.getOrderByExpressions()) {
                    deviceViewOutputExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(orderByExpression));
                }
            }
        } else {
            deviceViewOutputExpressions.addAll(selectExpressions);
            if (queryStatement.hasOrderByExpression()) {
                deviceViewOutputExpressions.addAll(analysis.getOrderByExpressions());
            }
        }
        analysis.setDeviceViewOutputExpressions(deviceViewOutputExpressions);
        analysis.setDeviceViewSpecialProcess(AnalyzeVisitor.analyzeDeviceViewSpecialProcess(deviceViewOutputExpressions, queryStatement, analysis));
    }

    static boolean analyzeDeviceViewSpecialProcess(Set<Expression> deviceViewOutputExpressions, QueryStatement queryStatement, Analysis analysis) {
        if (queryStatement.isAggregationQuery() || analysis.getWhereExpression() != null && ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(analysis.getWhereExpression(), analysis)) {
            return true;
        }
        for (Expression expression : deviceViewOutputExpressions) {
            if (!ExpressionAnalyzer.isDeviceViewNeedSpecialProcess(expression, analysis)) continue;
            return true;
        }
        return false;
    }

    private void analyzeDeviceViewInput(Analysis analysis, QueryStatement queryStatement) {
        List deviceViewOutputColumns = analysis.getDeviceViewOutputExpressions().stream().map(Expression::getOutputSymbol).collect(Collectors.toList());
        LinkedHashMap deviceToOutputColumnsMap = new LinkedHashMap();
        Map<IDeviceID, Set<Expression>> deviceToOutputExpressions = analysis.getDeviceToOutputExpressions();
        for (Map.Entry<IDeviceID, Set<Expression>> deviceOutputExpressionEntry : deviceToOutputExpressions.entrySet()) {
            Set<Expression> outputExpressionsUnderDevice = deviceOutputExpressionEntry.getValue();
            this.checkDeviceViewInputUniqueness(outputExpressionsUnderDevice);
            LinkedHashSet<String> outputColumns = new LinkedHashSet<String>();
            if (queryStatement.isOutputEndTime()) {
                outputColumns.add("__endTime");
            }
            for (Expression expression : outputExpressionsUnderDevice) {
                outputColumns.add(ExpressionAnalyzer.getMeasurementExpression(expression, analysis).getOutputSymbol());
            }
            deviceToOutputColumnsMap.put(deviceOutputExpressionEntry.getKey(), outputColumns);
        }
        HashMap<IDeviceID, List<Integer>> deviceViewInputIndexesMap = new HashMap<IDeviceID, List<Integer>>();
        for (Map.Entry deviceOutputColumnsEntry : deviceToOutputColumnsMap.entrySet()) {
            IDeviceID deviceID = (IDeviceID)deviceOutputColumnsEntry.getKey();
            ArrayList outputsUnderDevice = new ArrayList((Collection)deviceOutputColumnsEntry.getValue());
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (String output : outputsUnderDevice) {
                int index = deviceViewOutputColumns.indexOf(output);
                Preconditions.checkState((index >= 1 ? 1 : 0) != 0, (String)"output column '%s' is not stored in %s", (Object)output, deviceViewOutputColumns);
                indexes.add(index);
            }
            deviceViewInputIndexesMap.put(deviceID, indexes);
        }
        analysis.setDeviceViewInputIndexesMap(deviceViewInputIndexesMap);
    }

    private void checkDeviceViewInputUniqueness(Set<Expression> outputExpressionsUnderDevice) {
        Set normalizedOutputExpressionsUnderDevice = outputExpressionsUnderDevice.stream().map(ExpressionAnalyzer::normalizeExpression).collect(Collectors.toSet());
        if (normalizedOutputExpressionsUnderDevice.size() < outputExpressionsUnderDevice.size()) {
            throw new SemanticException("Views or measurement aliases representing the same data source cannot be queried concurrently in ALIGN BY DEVICE queries.");
        }
    }

    static void analyzeOutput(Analysis analysis, QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions) {
        if (queryStatement.isSelectInto()) {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getSelectIntoHeader(queryStatement.isAlignByDevice()));
            return;
        }
        if (queryStatement.hasModelInference()) {
            ModelInformation modelInformation = analysis.getModelInformation();
            AnalyzeVisitor.checkInputShape(modelInformation, outputExpressions);
            AnalyzeVisitor.checkInputType(analysis, modelInformation, outputExpressions);
            ArrayList<ColumnHeader> columnHeaders = new ArrayList<ColumnHeader>();
            int[] outputShape = modelInformation.getOutputShape();
            TSDataType[] outputDataType = modelInformation.getOutputDataType();
            for (int i = 0; i < outputShape[1]; ++i) {
                columnHeaders.add(new ColumnHeader(INFERENCE_COLUMN_NAME + i, outputDataType[i]));
            }
            analysis.getModelInferenceDescriptor().setOutputColumnNames(columnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList()));
            boolean isIgnoreTimestamp = !queryStatement.isGenerateTime();
            analysis.setRespDatasetHeader(new DatasetHeader(columnHeaders, isIgnoreTimestamp));
            return;
        }
        boolean isIgnoreTimestamp = queryStatement.isAggregationQuery() && !queryStatement.isGroupBy();
        ArrayList<ColumnHeader> columnHeaders = new ArrayList<ColumnHeader>();
        if (queryStatement.isAlignByDevice()) {
            columnHeaders.add(new ColumnHeader("Device", TSDataType.TEXT, null));
        }
        if (queryStatement.isOutputEndTime()) {
            columnHeaders.add(new ColumnHeader("__endTime", TSDataType.INT64, null));
        }
        for (Pair<Expression, String> expressionAliasPair : outputExpressions) {
            columnHeaders.add(new ColumnHeader(((Expression)expressionAliasPair.left).getExpressionString(), analysis.getType((Expression)expressionAliasPair.left), (String)expressionAliasPair.right));
        }
        analysis.setRespDatasetHeader(new DatasetHeader(columnHeaders, isIgnoreTimestamp));
    }

    private static void checkInputShape(ModelInformation modelInformation, List<Pair<Expression, String>> outputExpressions) {
        if (modelInformation.isBuiltIn()) {
            modelInformation.setInputColumnSize(outputExpressions.size());
            return;
        }
        int[] inputShape = modelInformation.getInputShape();
        if (inputShape.length != 2) {
            throw new SemanticException(String.format("The input shape of model is not correct, the dimension of input shape should be 2, actual dimension is %d", inputShape.length));
        }
        int columnNumber = inputShape[1];
        if (columnNumber != outputExpressions.size()) {
            throw new SemanticException(String.format("The column number of SQL result does not match the number of model input [%d] for inference", columnNumber));
        }
    }

    private static void checkInputType(Analysis analysis, ModelInformation modelInformation, List<Pair<Expression, String>> outputExpressions) {
        if (modelInformation.isBuiltIn()) {
            TSDataType[] inputType = new TSDataType[outputExpressions.size()];
            for (int i = 0; i < outputExpressions.size(); ++i) {
                Expression inputExpression = (Expression)outputExpressions.get((int)i).left;
                TSDataType inputDataType = analysis.getType(inputExpression);
                if (!inputDataType.isNumeric()) {
                    throw new SemanticException(String.format("The type of SQL result column [%s in %d] should be numeric when inference", inputDataType, i));
                }
                inputType[i] = inputDataType;
            }
            modelInformation.setInputDataType(inputType);
            return;
        }
        TSDataType[] inputType = modelInformation.getInputDataType();
        if (inputType.length != modelInformation.getInputShape()[1]) {
            throw new SemanticException(String.format("The inputType does not match the input shape [%d] for inference", modelInformation.getInputShape()[1]));
        }
        for (int i = 0; i < inputType.length; ++i) {
            Expression inputExpression = (Expression)outputExpressions.get((int)i).left;
            TSDataType inputDataType = analysis.getType(inputExpression);
            if (inputDataType == inputType[i]) continue;
            throw new SemanticException(String.format("The type of SQL result column [%s in %d] does not match the type of model input [%s] when inference", inputDataType, i, inputType[i]));
        }
    }

    private void analyzeLastOrderBy(Analysis analysis, QueryStatement queryStatement) {
        if (!queryStatement.hasOrderBy()) {
            return;
        }
        if (queryStatement.onlyOrderByTimeseries()) {
            analysis.setTimeseriesOrderingForLastQuery(queryStatement.getOrderByComponent().getTimeseriesOrder());
        }
        for (SortItem sortItem : queryStatement.getSortItemList()) {
            String sortKey = sortItem.getSortKey();
            if (this.lastQueryColumnNames.contains(sortKey.toUpperCase())) continue;
            throw new SemanticException(String.format("%s in order by clause doesn't exist in the result of last query.", sortKey));
        }
    }

    private void analyzeOrderByBase(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, UnaryOperator<List<Expression>> orderByExpressionAnalyzer, MPPQueryContext queryContext) {
        LinkedHashSet<Expression> orderByExpressions = new LinkedHashSet<Expression>();
        for (Expression expressionForItem : queryStatement.getExpressionSortItemList()) {
            List expressions = ExpressionAnalyzer.bindSchemaForExpression(expressionForItem, schemaTree, queryContext);
            if (expressions.isEmpty()) {
                throw new SemanticException(String.format("%s in order by clause doesn't exist.", expressionForItem.getExpressionString()));
            }
            if ((expressions = (List)orderByExpressionAnalyzer.apply(expressions)).size() > 1) {
                throw new SemanticException(String.format("%s in order by clause shouldn't refer to more than one timeseries.", expressionForItem.getExpressionString()));
            }
            Expression orderByExpression = ExpressionAnalyzer.normalizeExpression((Expression)expressions.get(0));
            TSDataType dataType = AnalyzeVisitor.analyzeExpressionType(analysis, orderByExpression);
            if (!dataType.isComparable()) {
                throw new SemanticException(String.format("The data type of %s is not comparable", dataType));
            }
            orderByExpressions.add(orderByExpression);
        }
        analysis.setOrderByExpressions(orderByExpressions);
        queryStatement.updateSortItems(orderByExpressions);
    }

    private void analyzeOrderBy(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, MPPQueryContext queryContext) {
        if (!queryStatement.hasOrderByExpression()) {
            return;
        }
        this.analyzeOrderByBase(analysis, queryStatement, schemaTree, expressions -> expressions, queryContext);
    }

    private void analyzeGroupByLevelOrderBy(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, GroupByLevelHelper groupByLevelHelper, MPPQueryContext queryContext) {
        if (!queryStatement.hasOrderByExpression()) {
            return;
        }
        this.analyzeOrderByBase(analysis, queryStatement, schemaTree, expressions -> {
            HashSet<Expression> groupedExpressions = new HashSet<Expression>();
            for (Expression expression : expressions) {
                groupedExpressions.add(groupByLevelHelper.applyLevels(expression, analysis));
            }
            return new ArrayList(groupedExpressions);
        }, queryContext);
        for (Expression orderByExpression : analysis.getOrderByExpressions()) {
            groupByLevelHelper.updateGroupByLevelExpressions(orderByExpression);
        }
    }

    static TSDataType analyzeExpressionType(Analysis analysis, Expression expression) {
        return ExpressionTypeAnalyzer.analyzeExpression(analysis, expression);
    }

    private void analyzeDeviceToGroupBy(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, List<PartialPath> deviceSet, MPPQueryContext queryContext) {
        GroupByParameter groupByParameter;
        if (queryStatement.getGroupByComponent() == null) {
            return;
        }
        GroupByComponent groupByComponent = queryStatement.getGroupByComponent();
        WindowType windowType = groupByComponent.getWindowType();
        LinkedHashMap<IDeviceID, Expression> deviceToGroupByExpression = new LinkedHashMap<IDeviceID, Expression>();
        if (queryStatement.hasGroupByExpression()) {
            Expression expression = groupByComponent.getControlColumnExpression();
            for (PartialPath device : deviceSet) {
                List<Expression> groupByExpressionsOfOneDevice = ExpressionAnalyzer.concatDeviceAndBindSchemaForExpression(expression, device, schemaTree, queryContext);
                if (groupByExpressionsOfOneDevice.isEmpty()) {
                    throw new SemanticException(String.format("%s in group by clause doesn't exist.", expression));
                }
                if (groupByExpressionsOfOneDevice.size() > 1) {
                    throw new SemanticException(String.format("%s in group by clause shouldn't refer to more than one timeseries.", expression));
                }
                deviceToGroupByExpression.put(device.getIDeviceIDAsFullDevice(), ExpressionAnalyzer.normalizeExpression((Expression)groupByExpressionsOfOneDevice.get(0)));
            }
        }
        switch (windowType) {
            case VARIATION_WINDOW: {
                double delta = ((GroupByVariationComponent)groupByComponent).getDelta();
                for (Expression expression : deviceToGroupByExpression.values()) {
                    this.checkGroupByVariationExpressionType(analysis, expression, delta);
                }
                groupByParameter = new GroupByVariationParameter(groupByComponent.isIgnoringNull(), delta);
                analysis.setDeviceToGroupByExpression(deviceToGroupByExpression);
                break;
            }
            case CONDITION_WINDOW: {
                Expression keepExpression = ((GroupByConditionComponent)groupByComponent).getKeepExpression();
                for (Expression expression : deviceToGroupByExpression.values()) {
                    this.checkGroupByConditionExpressionType(analysis, expression, keepExpression);
                }
                groupByParameter = new GroupByConditionParameter(groupByComponent.isIgnoringNull(), keepExpression);
                analysis.setDeviceToGroupByExpression(deviceToGroupByExpression);
                break;
            }
            case SESSION_WINDOW: {
                groupByParameter = new GroupBySessionParameter(((GroupBySessionComponent)groupByComponent).getTimeInterval());
                break;
            }
            case COUNT_WINDOW: {
                groupByParameter = new GroupByCountParameter(((GroupByCountComponent)groupByComponent).getCountNumber(), groupByComponent.isIgnoringNull());
                analysis.setDeviceToGroupByExpression(deviceToGroupByExpression);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported window type");
            }
        }
        analysis.setGroupByParameter(groupByParameter);
    }

    private void analyzeDeviceToOrderBy(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, List<PartialPath> deviceSet, MPPQueryContext queryContext) {
        if (!queryStatement.hasOrderByExpression()) {
            return;
        }
        LinkedHashMap<IDeviceID, Set<Expression>> deviceToOrderByExpressions = new LinkedHashMap<IDeviceID, Set<Expression>>();
        LinkedHashMap<IDeviceID, List<SortItem>> deviceToSortItems = new LinkedHashMap<IDeviceID, List<SortItem>>();
        LinkedHashSet<Expression> deviceViewOrderByExpression = new LinkedHashSet<Expression>();
        for (PartialPath device : deviceSet) {
            LinkedHashSet<Expression> orderByExpressionsForOneDevice = new LinkedHashSet<Expression>();
            for (Expression expressionForItem : queryStatement.getExpressionSortItemList()) {
                List<Expression> expressions = ExpressionAnalyzer.concatDeviceAndBindSchemaForExpression(expressionForItem, device, schemaTree, queryContext);
                if (expressions.isEmpty()) {
                    throw new SemanticException(String.format("%s in order by clause doesn't exist.", expressionForItem.getExpressionString()));
                }
                if (expressions.size() > 1) {
                    throw new SemanticException(String.format("%s in order by clause shouldn't refer to more than one timeseries.", expressionForItem.getExpressionString()));
                }
                expressionForItem = expressions.get(0);
                TSDataType dataType = AnalyzeVisitor.analyzeExpressionType(analysis, expressionForItem);
                if (!dataType.isComparable()) {
                    throw new SemanticException(String.format("The data type of %s is not comparable", dataType));
                }
                Expression deviceViewExpression = ExpressionAnalyzer.getMeasurementExpression(expressionForItem, analysis);
                AnalyzeVisitor.analyzeExpressionType(analysis, deviceViewExpression);
                deviceViewOrderByExpression.add(deviceViewExpression);
                orderByExpressionsForOneDevice.add(expressionForItem);
            }
            deviceToSortItems.put(device.getIDeviceIDAsFullDevice(), queryStatement.getUpdatedSortItems(orderByExpressionsForOneDevice));
            deviceToOrderByExpressions.put(device.getIDeviceIDAsFullDevice(), orderByExpressionsForOneDevice);
        }
        analysis.setOrderByExpressions(deviceViewOrderByExpression);
        queryStatement.updateSortItems(deviceViewOrderByExpression);
        analysis.setDeviceToSortItems(deviceToSortItems);
        analysis.setDeviceToOrderByExpressions(deviceToOrderByExpressions);
    }

    private void analyzeGroupBy(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, MPPQueryContext queryContext) {
        if (queryStatement.getGroupByComponent() == null) {
            return;
        }
        GroupByComponent groupByComponent = queryStatement.getGroupByComponent();
        WindowType windowType = groupByComponent.getWindowType();
        Expression groupByExpression = null;
        if (queryStatement.hasGroupByExpression()) {
            groupByExpression = groupByComponent.getControlColumnExpression();
            List<Expression> expressions = ExpressionAnalyzer.bindSchemaForExpression(groupByExpression, schemaTree, queryContext);
            if (expressions.isEmpty()) {
                throw new SemanticException(String.format("%s in group by clause doesn't exist.", groupByExpression.getExpressionString()));
            }
            if (expressions.size() > 1) {
                throw new SemanticException(String.format("%s in group by clause shouldn't refer to more than one timeseries.", groupByExpression.getExpressionString()));
            }
            List<Expression> aggregationExpression = ExpressionAnalyzer.searchAggregationExpressions(expressions.get(0));
            if (aggregationExpression != null && !aggregationExpression.isEmpty()) {
                throw new SemanticException("Aggregation expression shouldn't exist in group by clause");
            }
            groupByExpression = ExpressionAnalyzer.normalizeExpression(expressions.get(0));
        }
        if (windowType == WindowType.VARIATION_WINDOW) {
            double delta = ((GroupByVariationComponent)groupByComponent).getDelta();
            this.checkGroupByVariationExpressionType(analysis, groupByExpression, delta);
            GroupByVariationParameter groupByParameter = new GroupByVariationParameter(groupByComponent.isIgnoringNull(), delta);
            analysis.setGroupByExpression(groupByExpression);
            analysis.setGroupByParameter(groupByParameter);
        } else if (windowType == WindowType.CONDITION_WINDOW) {
            Expression keepExpression = ((GroupByConditionComponent)groupByComponent).getKeepExpression();
            this.checkGroupByConditionExpressionType(analysis, groupByExpression, keepExpression);
            GroupByConditionParameter groupByParameter = new GroupByConditionParameter(groupByComponent.isIgnoringNull(), keepExpression);
            analysis.setGroupByExpression(groupByExpression);
            analysis.setGroupByParameter(groupByParameter);
        } else if (windowType == WindowType.SESSION_WINDOW) {
            long interval = ((GroupBySessionComponent)groupByComponent).getTimeInterval();
            GroupBySessionParameter groupByParameter = new GroupBySessionParameter(interval);
            analysis.setGroupByParameter(groupByParameter);
        } else if (windowType == WindowType.COUNT_WINDOW) {
            GroupByCountParameter groupByParameter = new GroupByCountParameter(((GroupByCountComponent)groupByComponent).getCountNumber(), groupByComponent.isIgnoringNull());
            AnalyzeVisitor.analyzeExpressionType(analysis, groupByExpression);
            analysis.setGroupByExpression(groupByExpression);
            analysis.setGroupByParameter(groupByParameter);
        } else {
            throw new SemanticException("Unsupported window type");
        }
    }

    private void checkGroupByVariationExpressionType(Analysis analysis, Expression groupByExpression, double delta) {
        TSDataType type = AnalyzeVisitor.analyzeExpressionType(analysis, groupByExpression);
        if (delta != 0.0 && !type.isNumeric()) {
            throw new SemanticException("Only support numeric type when delta != 0");
        }
    }

    private void checkGroupByConditionExpressionType(Analysis analysis, Expression groupByExpression, Expression keepExpression) {
        TSDataType type = AnalyzeVisitor.analyzeExpressionType(analysis, groupByExpression);
        if (type != TSDataType.BOOLEAN) {
            throw new SemanticException("Only support boolean type in predict of group by series");
        }
        if (keepExpression instanceof CompareBinaryExpression) {
            Expression leftExpression = ((CompareBinaryExpression)keepExpression).getLeftExpression();
            Expression rightExpression = ((CompareBinaryExpression)keepExpression).getRightExpression();
            if (!(leftExpression instanceof TimeSeriesOperand && leftExpression.getExpressionString().equalsIgnoreCase("keep") && rightExpression instanceof ConstantOperand)) {
                throw new SemanticException(String.format("Please check the keep condition ([%s]), it need to be a constant or a compare expression constructed by 'keep' and a long number.", keepExpression.getExpressionString()));
            }
            return;
        }
        if (!(keepExpression instanceof ConstantOperand)) {
            throw new SemanticException(String.format("Please check the keep condition ([%s]), it need to be a constant or a compare expression constructed by 'keep' and a long number.", keepExpression.getExpressionString()));
        }
    }

    static void analyzeGroupByTime(Analysis analysis, QueryStatement queryStatement) {
        GroupByTimeComponent groupByTimeComponent;
        if (!queryStatement.isGroupByTime()) {
            return;
        }
        if (queryStatement.isResultSetEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        if (((groupByTimeComponent = queryStatement.getGroupByTimeComponent()).getInterval().containsMonth() || groupByTimeComponent.getSlidingStep().containsMonth()) && queryStatement.getResultTimeOrder() == Ordering.DESC) {
            throw new SemanticException("Group by month doesn't support order by time desc now.");
        }
        if (!queryStatement.isCqQueryBody() && groupByTimeComponent.getStartTime() == 0L && groupByTimeComponent.getEndTime() == 0L) {
            throw new SemanticException("The query time range should be specified in the GROUP BY TIME clause.");
        }
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(groupByTimeComponent);
        analysis.setGroupByTimeParameter(groupByTimeParameter);
        Expression globalTimePredicate = analysis.getGlobalTimePredicate();
        GroupByTimeExpression groupByTimePredicate = ExpressionFactory.groupByTime(groupByTimeParameter);
        globalTimePredicate = globalTimePredicate == null ? groupByTimePredicate : ExpressionFactory.and(globalTimePredicate, groupByTimePredicate);
        analysis.setGlobalTimePredicate(globalTimePredicate);
    }

    static void analyzeFill(Analysis analysis, QueryStatement queryStatement) {
        if (queryStatement.getFillComponent() == null) {
            return;
        }
        FillComponent fillComponent = queryStatement.getFillComponent();
        analysis.setFillDescriptor(new FillDescriptor(fillComponent.getFillPolicy(), fillComponent.getFillValue(), fillComponent.getTimeDurationThreshold()));
    }

    private void analyzeDataPartition(Analysis analysis, QueryStatement queryStatement, ISchemaTree schemaTree, MPPQueryContext context) {
        HashSet<IDeviceID> deviceSet = new HashSet();
        if (queryStatement.isAlignByDevice()) {
            deviceSet = new HashSet<IDeviceID>(analysis.getOutputDeviceToQueriedDevicesMap().values());
        } else {
            for (Expression expression : analysis.getSourceExpressions()) {
                deviceSet.add(ExpressionAnalyzer.getDeviceNameInSourceExpression(expression));
            }
        }
        DataPartition dataPartition = this.fetchDataPartitionByDevices(deviceSet, schemaTree, context);
        analysis.setDataPartitionInfo(dataPartition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataPartition fetchDataPartitionByDevices(Set<IDeviceID> deviceSet, ISchemaTree schemaTree, MPPQueryContext context) {
        long startTime = System.nanoTime();
        try {
            DataPartition dataPartition;
            Pair<List<TTimePartitionSlot>, Pair<Boolean, Boolean>> res = AnalyzeVisitor.getTimePartitionSlotList(context.getGlobalTimeFilter(), context);
            if (((List)res.left).isEmpty() && Boolean.FALSE.equals(((Pair)res.right).left)) {
                DataPartition dataPartition2 = new DataPartition(Collections.emptyMap(), CONFIG.getSeriesPartitionExecutorClass(), CONFIG.getSeriesPartitionSlotNum());
                return dataPartition2;
            }
            HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
            for (IDeviceID deviceID : deviceSet) {
                DataPartitionQueryParam queryParam = new DataPartitionQueryParam(deviceID, (List)res.left, ((Boolean)((Pair)res.right).left).booleanValue(), ((Boolean)((Pair)res.right).right).booleanValue());
                sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedDatabase(deviceID), key -> new ArrayList()).add(queryParam);
            }
            if (((Boolean)((Pair)res.right).left).booleanValue() || ((Boolean)((Pair)res.right).right).booleanValue()) {
                dataPartition = this.partitionFetcher.getDataPartitionWithUnclosedTimeRange(sgNameToQueryParamsMap);
                return dataPartition;
            }
            dataPartition = this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
            return dataPartition;
        }
        finally {
            long partitionFetchCost = System.nanoTime() - startTime;
            QueryPlanCostMetricSet.getInstance().recordTreePlanCost("partition_fetcher", partitionFetchCost);
            context.setFetchPartitionCost(partitionFetchCost);
        }
    }

    public static Pair<List<TTimePartitionSlot>, Pair<Boolean, Boolean>> getTimePartitionSlotList(Filter timeFilter, MPPQueryContext context) {
        boolean needRightAll;
        TTimePartitionSlot timePartitionSlot;
        long endTime;
        boolean needLeftAll;
        if (timeFilter == null) {
            return new Pair(Collections.emptyList(), (Object)new Pair((Object)true, (Object)true));
        }
        List timeRangeList = timeFilter.getTimeRanges();
        if (timeRangeList.isEmpty()) {
            return new Pair(Collections.emptyList(), (Object)new Pair((Object)false, (Object)false));
        }
        if (timeRangeList.size() == 1 && ((TimeRange)timeRangeList.get(0)).getMin() == Long.MIN_VALUE && ((TimeRange)timeRangeList.get(timeRangeList.size() - 1)).getMax() == Long.MAX_VALUE) {
            return new Pair(Collections.emptyList(), (Object)new Pair((Object)true, (Object)true));
        }
        int index = 0;
        int size = timeRangeList.size();
        if (((TimeRange)timeRangeList.get(0)).getMin() == Long.MIN_VALUE) {
            needLeftAll = true;
            endTime = TimePartitionUtils.getTimePartitionUpperBound((long)((TimeRange)timeRangeList.get(0)).getMax());
            timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)((TimeRange)timeRangeList.get(0)).getMax());
        } else {
            endTime = TimePartitionUtils.getTimePartitionUpperBound((long)((TimeRange)timeRangeList.get(0)).getMin());
            timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)((TimeRange)timeRangeList.get(0)).getMin());
            needLeftAll = false;
        }
        if (((TimeRange)timeRangeList.get(size - 1)).getMax() == Long.MAX_VALUE) {
            needRightAll = true;
            --size;
        } else {
            needRightAll = false;
        }
        ArrayList<TTimePartitionSlot> result = new ArrayList<TTimePartitionSlot>();
        TimeRange currentTimeRange = (TimeRange)timeRangeList.get(index);
        AnalyzeVisitor.reserveMemoryForTimePartitionSlot(currentTimeRange.getMax(), currentTimeRange.getMin(), context);
        while (index < size) {
            long curLeft = ((TimeRange)timeRangeList.get(index)).getMin();
            long curRight = ((TimeRange)timeRangeList.get(index)).getMax();
            if (curLeft >= endTime) {
                result.add(timePartitionSlot);
                endTime = TimePartitionUtils.getTimePartitionUpperBound((long)curLeft);
                timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)curLeft);
                continue;
            }
            if (curRight >= endTime) {
                result.add(timePartitionSlot);
                timePartitionSlot = new TTimePartitionSlot(endTime);
                endTime = endTime + TimePartitionUtils.getTimePartitionInterval() > endTime ? endTime + TimePartitionUtils.getTimePartitionInterval() : Long.MAX_VALUE;
                continue;
            }
            if (++index >= size) continue;
            currentTimeRange = (TimeRange)timeRangeList.get(index);
            AnalyzeVisitor.reserveMemoryForTimePartitionSlot(currentTimeRange.getMax(), currentTimeRange.getMin(), context);
        }
        result.add(timePartitionSlot);
        if (needRightAll) {
            TTimePartitionSlot lastTimePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)((TimeRange)timeRangeList.get(timeRangeList.size() - 1)).getMin());
            if (lastTimePartitionSlot.startTime != timePartitionSlot.startTime) {
                result.add(lastTimePartitionSlot);
            }
        }
        return new Pair(result, (Object)new Pair((Object)needLeftAll, (Object)needRightAll));
    }

    private static void reserveMemoryForTimePartitionSlot(long maxTime, long minTime, MPPQueryContext context) {
        if (maxTime == Long.MAX_VALUE || minTime == Long.MIN_VALUE) {
            return;
        }
        long size = TimePartitionUtils.getEstimateTimePartitionSize((long)minTime, (long)maxTime);
        context.reserveMemoryForFrontEnd(RamUsageEstimator.shallowSizeOfInstance(TTimePartitionSlot.class) * size);
    }

    private void analyzeInto(Analysis analysis, QueryStatement queryStatement, List<PartialPath> deviceSet, List<Pair<Expression, String>> outputExpressions, MPPQueryContext context) {
        if (!queryStatement.isSelectInto()) {
            return;
        }
        queryStatement.setOrderByComponent(null);
        ArrayList<PartialPath> sourceDevices = new ArrayList<PartialPath>(deviceSet);
        List sourceColumns = outputExpressions.stream().map(Pair::getLeft).collect(Collectors.toCollection(ArrayList::new));
        IntoComponent intoComponent = queryStatement.getIntoComponent();
        intoComponent.validate(sourceDevices, sourceColumns);
        DeviceViewIntoPathDescriptor deviceViewIntoPathDescriptor = new DeviceViewIntoPathDescriptor();
        PathPatternTree targetPathTree = new PathPatternTree();
        IntoComponent.IntoDeviceMeasurementIterator intoDeviceMeasurementIterator = intoComponent.getIntoDeviceMeasurementIterator();
        for (PartialPath sourceDevice : sourceDevices) {
            PartialPath deviceTemplate = intoDeviceMeasurementIterator.getDeviceTemplate();
            boolean isAlignedDevice = intoDeviceMeasurementIterator.isAlignedDevice();
            PartialPath targetDevice = SelectIntoUtils.constructTargetDevice(sourceDevice, deviceTemplate);
            deviceViewIntoPathDescriptor.specifyDeviceAlignment(targetDevice.toString(), isAlignedDevice);
            for (Pair<Expression, String> pair : outputExpressions) {
                Expression sourceColumn = (Expression)pair.left;
                String measurementTemplate = intoDeviceMeasurementIterator.getMeasurementTemplate();
                String targetMeasurement = sourceColumn instanceof TimeSeriesOperand ? SelectIntoUtils.constructTargetMeasurement((PartialPath)sourceDevice.concatAsMeasurementPath(pair.right == null ? sourceColumn.getExpressionString() : (String)pair.right), measurementTemplate) : ASTVisitor.parseNodeString(measurementTemplate);
                deviceViewIntoPathDescriptor.specifyTargetDeviceMeasurement(sourceDevice, targetDevice, sourceColumn.getExpressionString(), targetMeasurement);
                targetPathTree.appendFullPath(targetDevice, targetMeasurement);
                deviceViewIntoPathDescriptor.recordSourceColumnDataType(sourceColumn.getExpressionString(), analysis.getType(sourceColumn));
                intoDeviceMeasurementIterator.nextMeasurement();
            }
            intoDeviceMeasurementIterator.nextDevice();
        }
        deviceViewIntoPathDescriptor.validate();
        long startTime = System.nanoTime();
        ISchemaTree targetSchemaTree = this.schemaFetcher.fetchSchema(targetPathTree, true, context);
        QueryPlanCostMetricSet.getInstance().recordTreePlanCost("schema_fetcher", System.nanoTime() - startTime);
        deviceViewIntoPathDescriptor.bindType(targetSchemaTree);
        analysis.setDeviceViewIntoPathDescriptor(deviceViewIntoPathDescriptor);
    }

    private void analyzeInto(Analysis analysis, QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions, MPPQueryContext context) {
        if (!queryStatement.isSelectInto()) {
            return;
        }
        queryStatement.setOrderByComponent(null);
        List sourceColumns = outputExpressions.stream().map(Pair::getLeft).collect(Collectors.toCollection(ArrayList::new));
        IntoComponent intoComponent = queryStatement.getIntoComponent();
        intoComponent.validate(sourceColumns);
        IntoPathDescriptor intoPathDescriptor = new IntoPathDescriptor();
        PathPatternTree targetPathTree = new PathPatternTree();
        IntoComponent.IntoPathIterator intoPathIterator = intoComponent.getIntoPathIterator();
        for (Pair<Expression, String> pair : outputExpressions) {
            PartialPath targetPath;
            Expression sourceExpression = (Expression)pair.left;
            String viewPath = (String)pair.right;
            PartialPath deviceTemplate = intoPathIterator.getDeviceTemplate();
            String measurementTemplate = intoPathIterator.getMeasurementTemplate();
            boolean isAlignedDevice = intoPathIterator.isAlignedDevice();
            String sourceColumn = sourceExpression.getExpressionString();
            if (sourceExpression instanceof TimeSeriesOperand) {
                PartialPath sourcePath;
                if (viewPath != null) {
                    try {
                        if (viewPath.startsWith("root.")) {
                            sourcePath = new MeasurementPath(viewPath);
                        }
                        sourcePath = new PartialPath(viewPath);
                    }
                    catch (IllegalPathException e) {
                        throw new SemanticException(String.format("View path %s of source column %s is illegal path", viewPath, sourceColumn));
                    }
                } else {
                    sourcePath = ((TimeSeriesOperand)sourceExpression).getPath();
                }
                targetPath = SelectIntoUtils.constructTargetPath(sourcePath, deviceTemplate, measurementTemplate);
            } else {
                targetPath = SelectIntoUtils.constructTargetPathWithoutPlaceHolder(deviceTemplate, measurementTemplate);
            }
            intoPathDescriptor.specifyTargetPath(sourceColumn, viewPath, targetPath);
            intoPathDescriptor.specifyDeviceAlignment(targetPath.getDevicePath().toString(), isAlignedDevice);
            targetPathTree.appendFullPath(targetPath);
            intoPathDescriptor.recordSourceColumnDataType(sourceColumn, analysis.getType(sourceExpression));
            intoPathIterator.next();
        }
        intoPathDescriptor.validate();
        long startTime = System.nanoTime();
        ISchemaTree targetSchemaTree = this.schemaFetcher.fetchSchema(targetPathTree, true, context);
        this.updateSchemaTreeByViews(analysis, targetSchemaTree, context);
        QueryPlanCostMetricSet.getInstance().recordTreePlanCost("schema_fetcher", System.nanoTime() - startTime);
        intoPathDescriptor.bindType(targetSchemaTree);
        analysis.setIntoPathDescriptor(intoPathDescriptor);
    }

    private void checkDataTypeConsistencyInAlignByDevice(Analysis analysis, List<Expression> expressions) {
        TSDataType checkedDataType = analysis.getType(expressions.get(0));
        for (Expression expression : expressions) {
            if (analysis.getType(expression) == checkedDataType) continue;
            throw new SemanticException("ALIGN BY DEVICE: the data types of the same measurement column should be the same across devices.");
        }
    }

    private void checkAliasUniqueness(String alias, Set<String> aliasSet) {
        if (alias != null) {
            if (aliasSet.contains(alias)) {
                throw new SemanticException(String.format("alias '%s' can only be matched with one time series", alias));
            }
            aliasSet.add(alias);
        }
    }

    private void checkAliasUniqueness(String alias, Map<Expression, Map<IDeviceID, Expression>> measurementToDeviceSelectExpressions) {
        if (alias != null && measurementToDeviceSelectExpressions.keySet().size() > 1) {
            throw new SemanticException(String.format("alias '%s' can only be matched with one time series", alias));
        }
    }

    @Override
    public Analysis visitInsert(InsertStatement insertStatement, MPPQueryContext context) {
        int i;
        context.setQueryType(QueryType.WRITE);
        long[] timeArray = insertStatement.getTimes();
        PartialPath devicePath = insertStatement.getDevice();
        String[] measurementList = insertStatement.getMeasurementList();
        if (timeArray.length == 1) {
            InsertRowStatement insertRowStatement = new InsertRowStatement();
            insertRowStatement.setDevicePath(devicePath);
            insertRowStatement.setTime(timeArray[0]);
            insertRowStatement.setMeasurements(measurementList);
            insertRowStatement.setDataTypes(new TSDataType[measurementList.length]);
            insertRowStatement.setValues(insertStatement.getValuesList().get(0));
            insertRowStatement.setNeedInferType(true);
            insertRowStatement.setAligned(insertStatement.isAligned());
            return insertRowStatement.accept(this, context);
        }
        InsertRowsOfOneDeviceStatement insertRowsOfOneDeviceStatement = new InsertRowsOfOneDeviceStatement();
        if (!this.checkSorted(timeArray)) {
            Integer[] index = new Integer[timeArray.length];
            for (i = 0; i < index.length; ++i) {
                index[i] = i;
            }
            Arrays.sort(index, Comparator.comparingLong(o -> timeArray[o]));
            Arrays.sort(timeArray, 0, timeArray.length);
            insertStatement.setValuesList(Arrays.stream(index).map(insertStatement.getValuesList()::get).collect(Collectors.toList()));
        }
        ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
        for (i = 0; i < timeArray.length; ++i) {
            InsertRowStatement statement = new InsertRowStatement();
            statement.setDevicePath(devicePath);
            String[] measurements = new String[measurementList.length];
            System.arraycopy(measurementList, 0, measurements, 0, measurements.length);
            statement.setMeasurements(measurements);
            statement.setTime(timeArray[i]);
            TSDataType[] dataTypes = new TSDataType[measurementList.length];
            statement.setDataTypes(dataTypes);
            statement.setValues(insertStatement.getValuesList().get(i));
            statement.setAligned(insertStatement.isAligned());
            statement.setNeedInferType(true);
            insertRowStatementList.add(statement);
        }
        insertRowsOfOneDeviceStatement.setInsertRowStatementList(insertRowStatementList);
        return insertRowsOfOneDeviceStatement.accept(this, context);
    }

    private boolean checkSorted(long[] times) {
        for (int i = 1; i < times.length; ++i) {
            if (times[i] >= times[i - 1]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Analysis visitCreateTimeseries(CreateTimeSeriesStatement createTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        if (createTimeSeriesStatement.getPath().getNodeLength() < 3) {
            throw new SemanticException(new IllegalPathException(createTimeSeriesStatement.getPath().getFullPath()));
        }
        this.analyzeSchemaProps(createTimeSeriesStatement.getProps());
        if (createTimeSeriesStatement.getTags() != null && !createTimeSeriesStatement.getTags().isEmpty() && createTimeSeriesStatement.getAttributes() != null && !createTimeSeriesStatement.getAttributes().isEmpty()) {
            for (String tagKey : createTimeSeriesStatement.getTags().keySet()) {
                if (!createTimeSeriesStatement.getAttributes().containsKey(tagKey)) continue;
                throw new SemanticException(String.format("Tag and attribute shouldn't have the same property key [%s]", tagKey));
            }
        }
        Analysis analysis = new Analysis();
        analysis.setRealStatement(createTimeSeriesStatement);
        this.checkIsTemplateCompatible((PartialPath)createTimeSeriesStatement.getPath(), createTimeSeriesStatement.getAlias(), context);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendFullPath((PartialPath)createTimeSeriesStatement.getPath());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(patternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    private void checkIsTemplateCompatible(PartialPath timeSeriesPath, String alias, MPPQueryContext context) {
        DataNodeSchemaLockManager.getInstance().takeReadLock(context, SchemaLockType.TIMESERIES_VS_TEMPLATE);
        Pair<Template, PartialPath> templateInfo = this.schemaFetcher.checkTemplateSetAndPreSetInfo(timeSeriesPath, alias);
        if (templateInfo != null) {
            throw new SemanticException((Throwable)((Object)new TemplateIncompatibleException(timeSeriesPath.getFullPath(), ((Template)templateInfo.left).getName(), (PartialPath)templateInfo.right)));
        }
    }

    private void checkIsTemplateCompatible(PartialPath devicePath, List<String> measurements, List<String> aliasList, MPPQueryContext context) {
        DataNodeSchemaLockManager.getInstance().takeReadLock(context, SchemaLockType.TIMESERIES_VS_TEMPLATE);
        for (int i = 0; i < measurements.size(); ++i) {
            Pair<Template, PartialPath> templateInfo = this.schemaFetcher.checkTemplateSetAndPreSetInfo((PartialPath)devicePath.concatAsMeasurementPath(measurements.get(i)), aliasList == null ? null : aliasList.get(i));
            if (templateInfo == null) continue;
            throw new SemanticException((Throwable)((Object)new TemplateIncompatibleException(devicePath.getFullPath() + measurements, ((Template)templateInfo.left).getName(), (PartialPath)templateInfo.right)));
        }
    }

    private void analyzeSchemaProps(Map<String, String> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        HashMap<String, String> caseChangeMap = new HashMap<String, String>();
        for (String string : props.keySet()) {
            caseChangeMap.put(string.toLowerCase(Locale.ROOT), string);
        }
        for (Map.Entry entry : caseChangeMap.entrySet()) {
            String lowerCaseKey = (String)entry.getKey();
            if (!IoTDBConstant.ALLOWED_SCHEMA_PROPS.contains(lowerCaseKey)) {
                throw new SemanticException(new MetadataException(String.format("%s is not a legal prop.", entry.getValue())));
            }
            props.put(lowerCaseKey, props.remove(entry.getValue()));
        }
        if (props.containsKey("deadband")) {
            props.put("loss", props.remove("deadband"));
        }
    }

    private void analyzeSchemaProps(List<Map<String, String>> propsList) {
        if (propsList == null) {
            return;
        }
        for (Map<String, String> props : propsList) {
            this.analyzeSchemaProps(props);
        }
    }

    @Override
    public Analysis visitCreateAlignedTimeseries(CreateAlignedTimeSeriesStatement createAlignedTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        if (createAlignedTimeSeriesStatement.getDevicePath().getNodeLength() < 2) {
            throw new SemanticException(new IllegalPathException(createAlignedTimeSeriesStatement.getDevicePath().getFullPath()));
        }
        List<String> measurements = createAlignedTimeSeriesStatement.getMeasurements();
        HashSet<String> measurementsSet = new HashSet<String>(measurements);
        if (measurementsSet.size() < measurements.size()) {
            throw new SemanticException("Measurement under an aligned device is not allowed to have the same measurement name");
        }
        Analysis analysis = new Analysis();
        analysis.setRealStatement(createAlignedTimeSeriesStatement);
        this.checkIsTemplateCompatible(createAlignedTimeSeriesStatement.getDevicePath(), createAlignedTimeSeriesStatement.getMeasurements(), createAlignedTimeSeriesStatement.getAliasList(), context);
        PathPatternTree pathPatternTree = new PathPatternTree();
        for (String measurement : createAlignedTimeSeriesStatement.getMeasurements()) {
            pathPatternTree.appendFullPath(createAlignedTimeSeriesStatement.getDevicePath(), measurement);
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(pathPatternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitInternalCreateTimeseries(InternalCreateTimeSeriesStatement internalCreateTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setRealStatement(internalCreateTimeSeriesStatement);
        this.checkIsTemplateCompatible(internalCreateTimeSeriesStatement.getDevicePath(), internalCreateTimeSeriesStatement.getMeasurements(), null, context);
        PathPatternTree pathPatternTree = new PathPatternTree();
        for (String measurement : internalCreateTimeSeriesStatement.getMeasurements()) {
            pathPatternTree.appendFullPath(internalCreateTimeSeriesStatement.getDevicePath(), measurement);
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(pathPatternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesStatement internalCreateMultiTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setRealStatement(internalCreateMultiTimeSeriesStatement);
        PathPatternTree pathPatternTree = new PathPatternTree();
        for (Map.Entry<PartialPath, Pair<Boolean, MeasurementGroup>> entry : internalCreateMultiTimeSeriesStatement.getDeviceMap().entrySet()) {
            this.checkIsTemplateCompatible(entry.getKey(), ((MeasurementGroup)entry.getValue().right).getMeasurements(), null, context);
            pathPatternTree.appendFullPath(entry.getKey().concatNode("*"));
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(pathPatternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitCreateMultiTimeSeries(CreateMultiTimeSeriesStatement createMultiTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setRealStatement(createMultiTimeSeriesStatement);
        this.analyzeSchemaProps(createMultiTimeSeriesStatement.getPropsList());
        List<MeasurementPath> timeseriesPathList = createMultiTimeSeriesStatement.getPaths();
        List<String> aliasList = createMultiTimeSeriesStatement.getAliasList();
        for (int i = 0; i < timeseriesPathList.size(); ++i) {
            this.checkIsTemplateCompatible((PartialPath)timeseriesPathList.get(i), aliasList == null ? null : aliasList.get(i), context);
        }
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath partialPath : createMultiTimeSeriesStatement.getPaths()) {
            patternTree.appendFullPath(partialPath);
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(patternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitAlterTimeSeries(AlterTimeSeriesStatement alterTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setRealStatement(alterTimeSeriesStatement);
        Pair<Template, PartialPath> templateInfo = this.schemaFetcher.checkTemplateSetAndPreSetInfo((PartialPath)alterTimeSeriesStatement.getPath(), alterTimeSeriesStatement.getAlias());
        if (templateInfo != null) {
            throw new RuntimeException((Throwable)((Object)new TemplateIncompatibleException(String.format("Cannot alter template timeseries [%s] since device template [%s] already set on path [%s].", alterTimeSeriesStatement.getPath().getFullPath(), ((Template)templateInfo.left).getName(), templateInfo.right))));
        }
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendFullPath((PartialPath)alterTimeSeriesStatement.getPath());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitInsertTablet(InsertTabletStatement insertTabletStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        AnalyzeUtils.analyzeInsert(context, insertTabletStatement, () -> SchemaValidator.validate(this.schemaFetcher, insertTabletStatement, context), this.partitionFetcher::getOrCreateDataPartition, AnalyzeUtils::computeTreeDataPartitionParams, analysis, true);
        return analysis;
    }

    @Override
    public Analysis visitInsertRow(InsertRowStatement insertRowStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        insertRowStatement.semanticCheck();
        Analysis analysis = new Analysis();
        AnalyzeUtils.validateSchema(analysis, insertRowStatement, () -> SchemaValidator.validate(this.schemaFetcher, insertRowStatement, context));
        InsertBaseStatement realInsertStatement = AnalyzeUtils.removeLogicalView(analysis, insertRowStatement);
        if (analysis.isFinishQueryAfterAnalyze()) {
            return analysis;
        }
        analysis.setRealStatement(realInsertStatement);
        if (realInsertStatement instanceof InsertRowStatement) {
            InsertRowStatement realInsertRowStatement = (InsertRowStatement)realInsertStatement;
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDeviceID(realInsertRowStatement.getDevicePath().getIDeviceIDAsFullDevice());
            dataPartitionQueryParam.setTimePartitionSlotList(Collections.singletonList(realInsertRowStatement.getTimePartitionSlot()));
            AnalyzeUtils.analyzeDataPartition(analysis, Collections.singletonList(dataPartitionQueryParam), context.getSession().getUserName(), this.partitionFetcher::getOrCreateDataPartition);
        } else {
            AnalyzeUtils.analyzeDataPartition(analysis, AnalyzeUtils.computeTreeDataPartitionParams(realInsertStatement, context), context.getSession().getUserName(), this.partitionFetcher::getOrCreateDataPartition);
        }
        return analysis;
    }

    @Override
    public Analysis visitInsertRows(InsertRowsStatement insertRowsStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        insertRowsStatement.semanticCheck();
        Analysis analysis = new Analysis();
        AnalyzeUtils.validateSchema(analysis, insertRowsStatement, () -> SchemaValidator.validate(this.schemaFetcher, insertRowsStatement, context));
        InsertRowsStatement realInsertRowsStatement = (InsertRowsStatement)AnalyzeUtils.removeLogicalView(analysis, insertRowsStatement);
        if (analysis.isFinishQueryAfterAnalyze()) {
            return analysis;
        }
        analysis.setRealStatement(realInsertRowsStatement);
        AnalyzeUtils.analyzeDataPartition(analysis, AnalyzeUtils.computeTreeDataPartitionParams(realInsertRowsStatement, context), context.getSession().getUserName(), this.partitionFetcher::getOrCreateDataPartition);
        return analysis;
    }

    @Override
    public Analysis visitInsertMultiTablets(InsertMultiTabletsStatement insertMultiTabletsStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        insertMultiTabletsStatement.semanticCheck();
        Analysis analysis = new Analysis();
        AnalyzeUtils.validateSchema(analysis, insertMultiTabletsStatement, () -> SchemaValidator.validate(this.schemaFetcher, insertMultiTabletsStatement, context));
        InsertMultiTabletsStatement realStatement = (InsertMultiTabletsStatement)AnalyzeUtils.removeLogicalView(analysis, insertMultiTabletsStatement);
        if (analysis.isFinishQueryAfterAnalyze()) {
            return analysis;
        }
        analysis.setRealStatement(realStatement);
        AnalyzeUtils.analyzeDataPartition(analysis, AnalyzeUtils.computeTreeDataPartitionParams(realStatement, context), context.getSession().getUserName(), this.partitionFetcher::getOrCreateDataPartition);
        return analysis;
    }

    @Override
    public Analysis visitInsertRowsOfOneDevice(InsertRowsOfOneDeviceStatement insertRowsOfOneDeviceStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        insertRowsOfOneDeviceStatement.semanticCheck();
        Analysis analysis = new Analysis();
        AnalyzeUtils.validateSchema(analysis, insertRowsOfOneDeviceStatement, () -> SchemaValidator.validate(this.schemaFetcher, insertRowsOfOneDeviceStatement, context));
        InsertBaseStatement realInsertStatement = AnalyzeUtils.removeLogicalView(analysis, insertRowsOfOneDeviceStatement);
        if (analysis.isFinishQueryAfterAnalyze()) {
            return analysis;
        }
        analysis.setRealStatement(realInsertStatement);
        if (realInsertStatement instanceof InsertRowsOfOneDeviceStatement) {
            InsertRowsOfOneDeviceStatement realStatement = (InsertRowsOfOneDeviceStatement)realInsertStatement;
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDeviceID(realStatement.getDevicePath().getIDeviceIDAsFullDevice());
            dataPartitionQueryParam.setTimePartitionSlotList(realStatement.getTimePartitionSlots());
            AnalyzeUtils.analyzeDataPartition(analysis, Collections.singletonList(dataPartitionQueryParam), context.getSession().getUserName(), this.partitionFetcher::getOrCreateDataPartition);
        } else {
            AnalyzeUtils.analyzeDataPartition(analysis, AnalyzeUtils.computeTreeDataPartitionParams(realInsertStatement, context), context.getSession().getUserName(), this.partitionFetcher::getOrCreateDataPartition);
        }
        return analysis;
    }

    @Override
    public Analysis visitPipeEnrichedStatement(PipeEnrichedStatement pipeEnrichedStatement, MPPQueryContext context) {
        if (pipeEnrichedStatement.getInnerStatement() instanceof LoadTsFileStatement) {
            ((LoadTsFileStatement)pipeEnrichedStatement.getInnerStatement()).markIsGeneratedByPipe();
        }
        Analysis analysis = pipeEnrichedStatement.getInnerStatement().accept(this, context);
        analysis.setDatabaseName(context.getDatabaseName().orElse(null));
        pipeEnrichedStatement.setInnerStatement(analysis.getTreeStatement());
        analysis.setRealStatement(pipeEnrichedStatement);
        return analysis;
    }

    @Override
    public Analysis visitLoadFile(LoadTsFileStatement loadTsFileStatement, MPPQueryContext context) {
        Analysis analysis;
        context.setQueryType(QueryType.WRITE);
        LoadTsFileAnalyzer loadTsFileAnalyzer = new LoadTsFileAnalyzer(loadTsFileStatement, loadTsFileStatement.isGeneratedByPipe(), context);
        try {
            analysis = (Analysis)loadTsFileAnalyzer.analyzeFileByFile(new Analysis());
        }
        catch (Throwable throwable) {
            try {
                try {
                    loadTsFileAnalyzer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                String exceptionMessage = String.format("Failed to execute load tsfile statement %s. Detail: %s", loadTsFileStatement, e.getMessage() == null ? e.getClass().getName() : e.getMessage());
                logger.warn(exceptionMessage, (Throwable)e);
                Analysis analysis2 = new Analysis();
                analysis2.setFinishQueryAfterAnalyze(true);
                analysis2.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.LOAD_FILE_ERROR, (String)exceptionMessage));
                return analysis2;
            }
        }
        loadTsFileAnalyzer.close();
        return analysis;
    }

    private boolean analyzeTimeseriesRegionScan(WhereCondition timeCondition, PathPatternTree patternTree, Analysis analysis, MPPQueryContext context, PathPatternTree authorityScope) throws IllegalPathException {
        this.analyzeGlobalTimeConditionInShowMetaData(timeCondition, analysis);
        context.generateGlobalTimeFilter(analysis);
        patternTree.constructTree();
        ISchemaTree schemaTree = this.schemaFetcher.fetchRawSchemaInMeasurementLevel(patternTree, authorityScope, context);
        if (schemaTree.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return false;
        }
        this.removeLogicViewMeasurement(schemaTree);
        HashMap<PartialPath, Map<PartialPath, List<TimeseriesContext>>> deviceToTimeseriesContext = new HashMap<PartialPath, Map<PartialPath, List<TimeseriesContext>>>();
        List<DeviceSchemaInfo> deviceSchemaInfoList = schemaTree.getMatchedDevices(SchemaConstant.ALL_MATCH_PATTERN);
        HashSet<IDeviceID> deviceSet = new HashSet<IDeviceID>();
        for (DeviceSchemaInfo deviceSchemaInfo : deviceSchemaInfoList) {
            boolean isAligned = deviceSchemaInfo.isAligned();
            PartialPath devicePath = deviceSchemaInfo.getDevicePath();
            deviceSet.add(devicePath.getIDeviceIDAsFullDevice());
            if (isAligned) {
                ArrayList<String> measurementList = new ArrayList<String>();
                ArrayList<IMeasurementSchema> schemaList = new ArrayList<IMeasurementSchema>();
                ArrayList<TimeseriesContext> timeseriesContextList = new ArrayList<TimeseriesContext>();
                for (IMeasurementSchemaInfo measurementSchemaInfo : deviceSchemaInfo.getMeasurementSchemaInfoList()) {
                    schemaList.add(measurementSchemaInfo.getSchema());
                    measurementList.add(measurementSchemaInfo.getName());
                    timeseriesContextList.add(new TimeseriesContext(measurementSchemaInfo));
                }
                AlignedPath alignedPath = new AlignedPath(devicePath.getNodes(), measurementList, schemaList);
                deviceToTimeseriesContext.computeIfAbsent(devicePath, k -> new HashMap()).put(alignedPath, timeseriesContextList);
                continue;
            }
            for (IMeasurementSchemaInfo measurementSchemaInfo : deviceSchemaInfo.getMeasurementSchemaInfoList()) {
                MeasurementPath measurementPath = new MeasurementPath(devicePath.concatNode(measurementSchemaInfo.getName()).getNodes());
                deviceToTimeseriesContext.computeIfAbsent(devicePath, k -> new HashMap()).put(measurementPath, Collections.singletonList(new TimeseriesContext(measurementSchemaInfo)));
            }
        }
        analysis.setDeviceToTimeseriesSchemas(deviceToTimeseriesContext);
        DataPartition dataPartition = this.fetchDataPartitionByDevices(deviceSet, schemaTree, context);
        analysis.setDataPartitionInfo(dataPartition);
        return true;
    }

    @Override
    public Analysis visitShowTimeSeries(ShowTimeSeriesStatement showTimeSeriesStatement, MPPQueryContext context) {
        PathPatternTree patternTree;
        Analysis analysis;
        block6: {
            analysis = new Analysis();
            analysis.setRealStatement(showTimeSeriesStatement);
            if (showTimeSeriesStatement.getPathPattern().getNodeLength() <= 1) {
                analysis.setFinishQueryAfterAnalyze(true);
                analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowTimeSeriesHeader());
                return analysis;
            }
            patternTree = new PathPatternTree();
            patternTree.appendPathPattern(showTimeSeriesStatement.getPathPattern());
            if (showTimeSeriesStatement.hasTimeCondition()) {
                try {
                    boolean hasSchema = this.analyzeTimeseriesRegionScan(showTimeSeriesStatement.getTimeCondition(), patternTree, analysis, context, showTimeSeriesStatement.getAuthorityScope());
                    if (!hasSchema) {
                        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowTimeSeriesHeader());
                        return analysis;
                    }
                    break block6;
                }
                catch (IllegalPathException e) {
                    throw new StatementAnalyzeException(e.getMessage());
                }
            }
            SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
            analysis.setSchemaPartitionInfo(schemaPartitionInfo);
            Map<Integer, Template> templateMap = this.schemaFetcher.checkAllRelatedTemplate(showTimeSeriesStatement.getPathPattern());
            analysis.setRelatedTemplateInfo(templateMap);
        }
        if (showTimeSeriesStatement.isOrderByHeat()) {
            patternTree.constructTree();
            logger.debug("[StartFetchSchema]");
            ISchemaTree schemaTree = this.schemaFetcher.fetchSchema(patternTree, true, context);
            this.updateSchemaTreeByViews(analysis, schemaTree, context);
            logger.debug("[EndFetchSchema]]");
            this.analyzeLastSource(analysis, Collections.singletonList(new TimeSeriesOperand(showTimeSeriesStatement.getPathPattern())), schemaTree, context);
            this.analyzeDataPartition(analysis, new QueryStatement(), schemaTree, context);
        }
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowTimeSeriesHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowStorageGroup(ShowDatabaseStatement showDatabaseStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(showDatabaseStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowStorageGroupHeader(showDatabaseStatement.isDetailed()));
        return analysis;
    }

    @Override
    public Analysis visitShowTTL(ShowTTLStatement showTTLStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(showTTLStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowTTLHeader());
        return analysis;
    }

    private void analyzeGlobalTimeConditionInShowMetaData(WhereCondition timeCondition, Analysis analysis) {
        Expression predicate = timeCondition.getPredicate();
        Pair<Expression, Boolean> resultPair = PredicateUtils.extractGlobalTimePredicate(predicate, true, true);
        if (((Boolean)resultPair.right).booleanValue()) {
            throw new SemanticException("Value Filter can't exist in the condition of SHOW/COUNT clause, only time condition supported");
        }
        if (resultPair.left == null) {
            throw new SemanticException("Time condition can't be empty in the condition of SHOW/COUNT clause");
        }
        Expression globalTimePredicate = (Expression)resultPair.left;
        globalTimePredicate = PredicateUtils.predicateRemoveNot(globalTimePredicate);
        analysis.setGlobalTimePredicate(globalTimePredicate);
    }

    private void removeLogicViewMeasurement(ISchemaTree schemaTree) {
        if (!schemaTree.hasLogicalViewMeasurement()) {
            return;
        }
        schemaTree.removeLogicalView();
    }

    private void analyzeDeviceRegionScan(WhereCondition timeCondition, PartialPath pattern, PathPatternTree authorityScope, Analysis analysis, MPPQueryContext context) {
        this.analyzeGlobalTimeConditionInShowMetaData(timeCondition, analysis);
        context.generateGlobalTimeFilter(analysis);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(pattern);
        ISchemaTree schemaTree = this.schemaFetcher.fetchRawSchemaInDeviceLevel(patternTree, authorityScope, context);
        if (schemaTree.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return;
        }
        Map<PartialPath, DeviceContext> devicePathsToInfoMap = schemaTree.getMatchedDevices(pattern).stream().collect(Collectors.toMap(DeviceSchemaInfo::getDevicePath, DeviceContext::new));
        analysis.setDevicePathToContextMap(devicePathsToInfoMap);
        DataPartition dataPartition = this.fetchDataPartitionByDevices(devicePathsToInfoMap.keySet().stream().map(PartialPath::getIDeviceIDAsFullDevice).collect(Collectors.toSet()), schemaTree, context);
        analysis.setDataPartitionInfo(dataPartition);
    }

    @Override
    public Analysis visitShowDevices(ShowDevicesStatement showDevicesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(showDevicesStatement);
        if (showDevicesStatement.hasTimeCondition()) {
            this.analyzeDeviceRegionScan(showDevicesStatement.getTimeCondition(), showDevicesStatement.getPathPattern(), showDevicesStatement.getAuthorityScope(), analysis, context);
        } else {
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendPathPattern(showDevicesStatement.getPathPattern().concatNode("*"));
            SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
            analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        }
        analysis.setRespDatasetHeader(showDevicesStatement.hasSgCol() ? DatasetHeaderFactory.getShowDevicesWithSgHeader() : DatasetHeaderFactory.getShowDevicesHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowCluster(ShowClusterStatement showClusterStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(showClusterStatement);
        if (showClusterStatement.isDetails()) {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowClusterDetailsHeader());
        } else {
            analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowClusterHeader());
        }
        return analysis;
    }

    @Override
    public Analysis visitCountStorageGroup(CountDatabaseStatement countDatabaseStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(countDatabaseStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountStorageGroupHeader());
        return analysis;
    }

    @Override
    public Analysis visitSeriesSchemaFetch(SeriesSchemaFetchStatement seriesSchemaFetchStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(seriesSchemaFetchStatement);
        SchemaPartition schemaPartition = this.partitionFetcher.getSchemaPartition(seriesSchemaFetchStatement.getPatternTree());
        analysis.setSchemaPartitionInfo(schemaPartition);
        if (schemaPartition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        return analysis;
    }

    @Override
    public Analysis visitDeviceSchemaFetch(DeviceSchemaFetchStatement deviceSchemaFetchStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(deviceSchemaFetchStatement);
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath path : deviceSchemaFetchStatement.getPaths()) {
            patternTree.appendPathPattern(path.concatNode("*"));
        }
        patternTree.constructTree();
        SchemaPartition schemaPartition = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartition);
        if (schemaPartition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        return analysis;
    }

    @Override
    public Analysis visitCountDevices(CountDevicesStatement countDevicesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(countDevicesStatement);
        if (countDevicesStatement.hasTimeCondition()) {
            this.analyzeDeviceRegionScan(countDevicesStatement.getTimeCondition(), countDevicesStatement.getPathPattern(), countDevicesStatement.getAuthorityScope(), analysis, context);
        } else {
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendPathPattern(countDevicesStatement.getPathPattern().concatNode("*"));
            SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
            analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        }
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountDevicesHeader());
        return analysis;
    }

    @Override
    public Analysis visitCountTimeSeries(CountTimeSeriesStatement countTimeSeriesStatement, MPPQueryContext context) {
        Analysis analysis;
        block4: {
            analysis = new Analysis();
            analysis.setRealStatement(countTimeSeriesStatement);
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendPathPattern(countTimeSeriesStatement.getPathPattern());
            if (countTimeSeriesStatement.hasTimeCondition()) {
                try {
                    boolean hasSchema = this.analyzeTimeseriesRegionScan(countTimeSeriesStatement.getTimeCondition(), patternTree, analysis, context, countTimeSeriesStatement.getAuthorityScope());
                    if (!hasSchema) {
                        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountTimeSeriesHeader());
                        return analysis;
                    }
                    break block4;
                }
                catch (IllegalPathException e) {
                    throw new StatementAnalyzeException(e.getMessage());
                }
            }
            SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
            analysis.setSchemaPartitionInfo(schemaPartitionInfo);
            Map<Integer, Template> templateMap = this.schemaFetcher.checkAllRelatedTemplate(countTimeSeriesStatement.getPathPattern());
            analysis.setRelatedTemplateInfo(templateMap);
        }
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountTimeSeriesHeader());
        return analysis;
    }

    @Override
    public Analysis visitCountLevelTimeSeries(CountLevelTimeSeriesStatement countLevelTimeSeriesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(countLevelTimeSeriesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(countLevelTimeSeriesStatement.getPathPattern());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        Map<Integer, Template> templateMap = this.schemaFetcher.checkAllRelatedTemplate(countLevelTimeSeriesStatement.getPathPattern());
        analysis.setRelatedTemplateInfo(templateMap);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountLevelTimeSeriesHeader());
        return analysis;
    }

    @Override
    public Analysis visitCountNodes(CountNodesStatement countStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(countStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(countStatement.getPathPattern());
        SchemaNodeManagementPartition schemaNodeManagementPartition = this.partitionFetcher.getSchemaNodeManagementPartitionWithLevel(patternTree, countStatement.getAuthorityScope(), countStatement.getLevel());
        if (schemaNodeManagementPartition == null) {
            return analysis;
        }
        if (!schemaNodeManagementPartition.getMatchedNode().isEmpty() && schemaNodeManagementPartition.getSchemaPartition().getSchemaPartitionMap().isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        analysis.setMatchedNodes(schemaNodeManagementPartition.getMatchedNode());
        analysis.setSchemaPartitionInfo(schemaNodeManagementPartition.getSchemaPartition());
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountNodesHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowChildPaths(ShowChildPathsStatement showChildPathsStatement, MPPQueryContext context) {
        return this.visitSchemaNodeManagementPartition(showChildPathsStatement, showChildPathsStatement.getPartialPath(), showChildPathsStatement.getAuthorityScope(), DatasetHeaderFactory.getShowChildPathsHeader());
    }

    @Override
    public Analysis visitShowChildNodes(ShowChildNodesStatement showChildNodesStatement, MPPQueryContext context) {
        return this.visitSchemaNodeManagementPartition(showChildNodesStatement, showChildNodesStatement.getPartialPath(), showChildNodesStatement.getAuthorityScope(), DatasetHeaderFactory.getShowChildNodesHeader());
    }

    @Override
    public Analysis visitShowVersion(ShowVersionStatement showVersionStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(showVersionStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowVersionHeader());
        analysis.setFinishQueryAfterAnalyze(true);
        return analysis;
    }

    private Analysis visitSchemaNodeManagementPartition(Statement statement, PartialPath path, PathPatternTree scope, DatasetHeader header) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(statement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(path);
        SchemaNodeManagementPartition schemaNodeManagementPartition = this.partitionFetcher.getSchemaNodeManagementPartition(patternTree, scope);
        if (schemaNodeManagementPartition == null) {
            return analysis;
        }
        if (!schemaNodeManagementPartition.getMatchedNode().isEmpty() && schemaNodeManagementPartition.getSchemaPartition().getSchemaPartitionMap().isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        analysis.setMatchedNodes(schemaNodeManagementPartition.getMatchedNode());
        analysis.setSchemaPartitionInfo(schemaNodeManagementPartition.getSchemaPartition());
        analysis.setRespDatasetHeader(header);
        return analysis;
    }

    @Override
    public Analysis visitDeleteData(DeleteDataStatement deleteDataStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setRealStatement(deleteDataStatement);
        PathPatternTree patternTree = new PathPatternTree();
        deleteDataStatement.getPathList().forEach(arg_0 -> ((PathPatternTree)patternTree).appendPathPattern(arg_0));
        ISchemaTree schemaTree = this.schemaFetcher.fetchSchema(patternTree, true, context);
        HashSet<IDeviceID> deduplicatedDeviceIDs = new HashSet<IDeviceID>();
        if (schemaTree.hasLogicalViewMeasurement()) {
            this.updateSchemaTreeByViews(analysis, schemaTree, context);
            HashSet<MeasurementPath> deletePatternSet = new HashSet<MeasurementPath>(deleteDataStatement.getPathList());
            for (MeasurementPath measurementPath : (List)schemaTree.searchMeasurementPaths((PartialPath)SchemaConstant.ALL_MATCH_PATTERN).left) {
                IMeasurementSchema measurementSchema = measurementPath.getMeasurementSchema();
                if (measurementSchema.isLogicalView()) {
                    LogicalViewSchema logicalViewSchema = (LogicalViewSchema)measurementSchema;
                    if (logicalViewSchema.isWritable()) {
                        PartialPath sourcePathOfAliasSeries = logicalViewSchema.getSourcePathIfWritable();
                        boolean pathMatched = false;
                        for (MeasurementPath deletionPattern : deleteDataStatement.getPathList()) {
                            if (!deletionPattern.matchFullPath(sourcePathOfAliasSeries)) continue;
                            pathMatched = true;
                            break;
                        }
                        if (pathMatched) continue;
                        deletePatternSet.add(new MeasurementPath(sourcePathOfAliasSeries.getNodes()));
                        deduplicatedDeviceIDs.add(sourcePathOfAliasSeries.getIDeviceID());
                    }
                    deletePatternSet.remove(measurementPath);
                    continue;
                }
                deduplicatedDeviceIDs.add(measurementPath.getIDeviceID());
            }
            deleteDataStatement.setPathList(new ArrayList<MeasurementPath>(deletePatternSet));
        } else {
            for (PartialPath devicePattern : patternTree.getAllDevicePaths()) {
                schemaTree.getMatchedDevices(devicePattern).forEach(deviceSchemaInfo -> deduplicatedDeviceIDs.add(deviceSchemaInfo.getDevicePath().getIDeviceIDAsFullDevice()));
            }
        }
        analysis.setSchemaTree(schemaTree);
        HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
        deduplicatedDeviceIDs.forEach(deviceID -> {
            DataPartitionQueryParam queryParam = new DataPartitionQueryParam();
            queryParam.setDeviceID(deviceID);
            sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedDatabase((IDeviceID)deviceID), key -> new ArrayList()).add(queryParam);
        });
        DataPartition dataPartition = this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
        analysis.setDataPartitionInfo(dataPartition);
        analysis.setFinishQueryAfterAnalyze(dataPartition.isEmpty());
        return analysis;
    }

    @Override
    public Analysis visitCreateSchemaTemplate(CreateSchemaTemplateStatement createTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        List<String> measurements = createTemplateStatement.getMeasurements();
        HashSet<String> measurementsSet = new HashSet<String>(measurements);
        if (measurementsSet.size() < measurements.size()) {
            throw new SemanticException("Measurement under template is not allowed to have the same measurement name");
        }
        Analysis analysis = new Analysis();
        analysis.setRealStatement(createTemplateStatement);
        return analysis;
    }

    @Override
    public Analysis visitShowNodesInSchemaTemplate(ShowNodesInSchemaTemplateStatement showNodesInSchemaTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(showNodesInSchemaTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowNodesInSchemaTemplateHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowSchemaTemplate(ShowSchemaTemplateStatement showSchemaTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(showSchemaTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowSchemaTemplateHeader());
        return analysis;
    }

    @Override
    public Analysis visitSetSchemaTemplate(SetSchemaTemplateStatement setSchemaTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setRealStatement(setSchemaTemplateStatement);
        return analysis;
    }

    @Override
    public Analysis visitShowPathSetTemplate(ShowPathSetTemplateStatement showPathSetTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(showPathSetTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowPathSetTemplateHeader());
        return analysis;
    }

    @Override
    public Analysis visitActivateTemplate(ActivateTemplateStatement activateTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setRealStatement(activateTemplateStatement);
        PartialPath activatePath = activateTemplateStatement.getPath();
        Pair<Template, PartialPath> templateSetInfo = this.schemaFetcher.checkTemplateSetInfo(activatePath);
        if (templateSetInfo == null) {
            throw new StatementAnalyzeException((Exception)((Object)new MetadataException(String.format("Path [%s] has not been set any template.", activatePath.getFullPath()))));
        }
        analysis.setTemplateSetInfo((Pair<Template, List<PartialPath>>)new Pair((Object)((Template)templateSetInfo.left), Collections.singletonList((PartialPath)templateSetInfo.right)));
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(activatePath.concatNode("*"));
        SchemaPartition partition = this.partitionFetcher.getOrCreateSchemaPartition(patternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(partition);
        return analysis;
    }

    @Override
    public Analysis visitBatchActivateTemplate(BatchActivateTemplateStatement batchActivateTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setRealStatement(batchActivateTemplateStatement);
        HashMap<PartialPath, Pair<Template, PartialPath>> deviceTemplateSetInfoMap = new HashMap<PartialPath, Pair<Template, PartialPath>>(batchActivateTemplateStatement.getDevicePathList().size());
        for (PartialPath partialPath : batchActivateTemplateStatement.getDevicePathList()) {
            Pair<Template, PartialPath> templateSetInfo = this.schemaFetcher.checkTemplateSetInfo(partialPath);
            if (templateSetInfo == null) {
                throw new StatementAnalyzeException((Exception)((Object)new MetadataException(String.format("Path [%s] has not been set any template.", partialPath.getFullPath()))));
            }
            deviceTemplateSetInfoMap.put(partialPath, templateSetInfo);
        }
        analysis.setDeviceTemplateSetInfoMap(deviceTemplateSetInfoMap);
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath devicePath : batchActivateTemplateStatement.getDevicePathList()) {
            patternTree.appendFullPath((PartialPath)devicePath.concatAsMeasurementPath("*"));
        }
        SchemaPartition schemaPartition = this.partitionFetcher.getOrCreateSchemaPartition(patternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(schemaPartition);
        return analysis;
    }

    @Override
    public Analysis visitInternalBatchActivateTemplate(InternalBatchActivateTemplateStatement internalBatchActivateTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setRealStatement(internalBatchActivateTemplateStatement);
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath activatePath : internalBatchActivateTemplateStatement.getDeviceMap().keySet()) {
            patternTree.appendFullPath(activatePath.concatNode("*"));
        }
        SchemaPartition partition = this.partitionFetcher.getOrCreateSchemaPartition(patternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(partition);
        return analysis;
    }

    @Override
    public Analysis visitShowPathsUsingTemplate(ShowPathsUsingTemplateStatement showPathsUsingTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(showPathsUsingTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowPathsUsingTemplateHeader());
        Pair<Template, List<PartialPath>> templateSetInfo = this.schemaFetcher.getAllPathsSetTemplate(showPathsUsingTemplateStatement.getTemplateName());
        if (templateSetInfo == null || templateSetInfo.right == null || ((List)templateSetInfo.right).isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return analysis;
        }
        analysis.setTemplateSetInfo(templateSetInfo);
        PathPatternTree patternTree = new PathPatternTree();
        PartialPath rawPathPattern = showPathsUsingTemplateStatement.getPathPattern();
        ArrayList<PartialPath> specifiedPatternList = new ArrayList<PartialPath>();
        ((List)templateSetInfo.right).forEach(setPath -> {
            for (PartialPath specifiedPattern : rawPathPattern.alterPrefixPath(setPath)) {
                patternTree.appendPathPattern(specifiedPattern);
                specifiedPatternList.add(specifiedPattern);
            }
        });
        if (specifiedPatternList.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return analysis;
        }
        analysis.setSpecifiedTemplateRelatedPathPatternList(specifiedPatternList);
        SchemaPartition partition = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(partition);
        if (partition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return analysis;
        }
        return analysis;
    }

    @Override
    public Analysis visitShowQueries(ShowQueriesStatement showQueriesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(showQueriesStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowQueriesHeader());
        analysis.setVirtualSource(true);
        List<TDataNodeLocation> allReadableDataNodeLocations = DataNodeLocationSupplierFactory.getReadableDataNodeLocations();
        if (allReadableDataNodeLocations.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        if (allReadableDataNodeLocations.isEmpty()) {
            throw new StatementAnalyzeException("no Running DataNodes");
        }
        analysis.setReadableDataNodeLocations(allReadableDataNodeLocations);
        HashSet<Expression> sourceExpressions = new HashSet<Expression>();
        for (ColumnHeader columnHeader : analysis.getRespDatasetHeader().getColumnHeaders()) {
            sourceExpressions.add(TimeSeriesOperand.constructColumnHeaderExpression(columnHeader.getColumnName(), columnHeader.getColumnType()));
        }
        analysis.setSourceExpressions(sourceExpressions);
        sourceExpressions.forEach(expression -> AnalyzeVisitor.analyzeExpressionType(analysis, expression));
        this.analyzeWhere(analysis, showQueriesStatement);
        analysis.setMergeOrderParameter(new OrderByParameter(showQueriesStatement.getSortItemList()));
        return analysis;
    }

    private void analyzeWhere(Analysis analysis, ShowQueriesStatement showQueriesStatement) {
        WhereCondition whereCondition = showQueriesStatement.getWhereCondition();
        if (whereCondition == null) {
            return;
        }
        Expression whereExpression = ExpressionAnalyzer.bindTypeForTimeSeriesOperand(whereCondition.getPredicate(), ColumnHeaderConstant.showQueriesColumnHeaders);
        TSDataType outputType = AnalyzeVisitor.analyzeExpressionType(analysis, whereExpression);
        if (outputType != TSDataType.BOOLEAN) {
            throw new SemanticException(String.format(WHERE_WRONG_TYPE_ERROR_MSG, outputType));
        }
        analysis.setWhereExpression(whereExpression);
    }

    @Override
    public Analysis visitCreateLogicalView(CreateLogicalViewStatement createLogicalViewStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        context.setQueryType(QueryType.WRITE);
        analysis.setRealStatement(createLogicalViewStatement);
        if (createLogicalViewStatement.getViewExpressions() == null) {
            QueryStatement queryStatement = createLogicalViewStatement.getQueryStatement();
            if (queryStatement != null) {
                Pair<List<Expression>, Analysis> queryAnalysisPair = this.analyzeQueryInLogicalViewStatement(analysis, queryStatement, context);
                if (((Analysis)queryAnalysisPair.right).isFinishQueryAfterAnalyze()) {
                    return analysis;
                }
                if (queryAnalysisPair.left != null) {
                    try {
                        createLogicalViewStatement.setSourceExpressions((List)queryAnalysisPair.left);
                    }
                    catch (UnsupportedViewException e) {
                        analysis.setFinishQueryAfterAnalyze(true);
                        analysis.setFailStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                        return analysis;
                    }
                }
            }
            createLogicalViewStatement.parseIntoItemIfNecessary();
            this.checkSourcePathsInCreateLogicalView(analysis, createLogicalViewStatement);
            if (analysis.isFinishQueryAfterAnalyze()) {
                return analysis;
            }
            List<Expression> sourceExpressionList = createLogicalViewStatement.getSourceExpressionList();
            this.checkViewsInSource(analysis, sourceExpressionList, context);
            if (analysis.isFinishQueryAfterAnalyze()) {
                return analysis;
            }
        }
        this.checkTargetPathsInCreateLogicalView(analysis, createLogicalViewStatement, context);
        if (analysis.isFinishQueryAfterAnalyze()) {
            return analysis;
        }
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath thisFullPath : createLogicalViewStatement.getTargetPathList()) {
            patternTree.appendFullPath(thisFullPath);
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(patternTree, context.getSession().getUserName());
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    private Pair<List<Expression>, Analysis> analyzeQueryInLogicalViewStatement(Analysis analysis, QueryStatement queryStatement, MPPQueryContext context) {
        Analysis queryAnalysis = this.visitQuery(queryStatement, context);
        analysis.setSchemaTree(queryAnalysis.getSchemaTree());
        List<Pair<Expression, String>> outputExpressions = queryAnalysis.getOutputExpressions();
        if (queryAnalysis.isFailed()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(queryAnalysis.getFailStatus());
            return new Pair(null, (Object)analysis);
        }
        if (outputExpressions == null) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode(), (String)"Columns in the query statement is empty. Please check your SQL."));
            return new Pair(null, (Object)analysis);
        }
        if (queryAnalysis.useLogicalView()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode(), (String)"Can not create a view based on existing views. Check the query in your SQL."));
            return new Pair(null, (Object)analysis);
        }
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        for (Pair<Expression, String> thisPair : outputExpressions) {
            expressionList.add((Expression)thisPair.left);
        }
        return new Pair(expressionList, (Object)analysis);
    }

    private void checkSourcePathsInCreateLogicalView(Analysis analysis, CreateLogicalViewStatement createLogicalViewStatement) {
        Pair<Boolean, String> checkResult = createLogicalViewStatement.checkSourcePathsIfNotUsingQueryStatement();
        if (Boolean.FALSE.equals(checkResult.left)) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.ILLEGAL_PATH.getStatusCode(), (String)("The path " + (String)checkResult.right + " is illegal.")));
            return;
        }
        List<PartialPath> targetPathList = createLogicalViewStatement.getTargetPathList();
        if (createLogicalViewStatement.getSourceExpressionList().size() != targetPathList.size()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode(), (String)String.format("The number of target paths (%d) and sources (%d) are miss matched! Please check your SQL.", createLogicalViewStatement.getTargetPathList().size(), createLogicalViewStatement.getSourceExpressionList().size())));
        }
    }

    private void checkViewsInSource(Analysis analysis, List<Expression> sourceExpressionList, MPPQueryContext context) {
        ArrayList<PartialPath> pathsNeedCheck = new ArrayList<PartialPath>();
        for (Expression expression : sourceExpressionList) {
            if (!(expression instanceof TimeSeriesOperand)) continue;
            pathsNeedCheck.add(((TimeSeriesOperand)expression).getPath());
        }
        Pair<ISchemaTree, Integer> schemaOfNeedToCheck = this.fetchSchemaOfPathsAndCount(pathsNeedCheck, analysis, context);
        if (((Integer)schemaOfNeedToCheck.right).intValue() != pathsNeedCheck.size()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode(), (String)"Can not create a view based on non-exist time series."));
            return;
        }
        Pair<List<PartialPath>, PartialPath> viewInSourceCheckResult = this.findAllViewsInPaths(pathsNeedCheck, (ISchemaTree)schemaOfNeedToCheck.left);
        if (viewInSourceCheckResult.right != null) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode(), (String)("Path " + ((PartialPath)viewInSourceCheckResult.right).toString() + " does not exist! You can not create a view based on non-exist time series.")));
            return;
        }
        if (!((List)viewInSourceCheckResult.left).isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode(), (String)"Can not create a view based on existing views."));
        }
    }

    private Pair<ISchemaTree, Integer> fetchSchemaOfPathsAndCount(List<PartialPath> pathList, Analysis analysis, MPPQueryContext context) {
        ISchemaTree schemaTree = analysis.getSchemaTree();
        if (schemaTree == null) {
            PathPatternTree pathPatternTree = new PathPatternTree();
            for (PartialPath path : pathList) {
                pathPatternTree.appendPathPattern(path);
            }
            schemaTree = this.schemaFetcher.fetchSchema(pathPatternTree, true, context);
        }
        int numOfExistPaths = 0;
        for (PartialPath path : pathList) {
            Pair<List<MeasurementPath>, Integer> pathPair = schemaTree.searchMeasurementPaths(path);
            numOfExistPaths += !((List)pathPair.left).isEmpty() ? 1 : 0;
        }
        return new Pair((Object)schemaTree, (Object)numOfExistPaths);
    }

    private Pair<List<PartialPath>, PartialPath> findAllViewsInPaths(List<PartialPath> pathList, ISchemaTree schemaTree) {
        ArrayList<MeasurementPath> result = new ArrayList<MeasurementPath>();
        for (PartialPath path : pathList) {
            Pair<List<MeasurementPath>, Integer> measurementPathList = schemaTree.searchMeasurementPaths(path);
            if (((List)measurementPathList.left).isEmpty()) {
                return new Pair(result, (Object)path);
            }
            for (MeasurementPath measurementPath : (List)measurementPathList.left) {
                if (!measurementPath.getMeasurementSchema().isLogicalView()) continue;
                result.add(measurementPath);
            }
        }
        return new Pair(result, null);
    }

    private void checkTargetPathsInCreateLogicalView(Analysis analysis, CreateLogicalViewStatement createLogicalViewStatement, MPPQueryContext context) {
        Pair<Boolean, String> checkResult = createLogicalViewStatement.checkTargetPaths();
        if (Boolean.FALSE.equals(checkResult.left)) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.ILLEGAL_PATH.getStatusCode(), (String)("The path " + (String)checkResult.right + " is illegal.")));
            return;
        }
        List<PartialPath> targetPathList = createLogicalViewStatement.getTargetPathList();
        HashSet<String> targetStringSet = new HashSet<String>();
        for (PartialPath path : targetPathList) {
            boolean repeatPathNotExist = targetStringSet.add(path.toString());
            if (repeatPathNotExist) continue;
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.ILLEGAL_PATH.getStatusCode(), (String)String.format("Path [%s] is redundant in target paths.", path)));
            return;
        }
        try {
            for (PartialPath path : createLogicalViewStatement.getTargetPathList()) {
                this.checkIsTemplateCompatible(path, null, context);
            }
        }
        catch (Exception e) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.UNSUPPORTED_OPERATION.getStatusCode(), (String)"Can not create view under template."));
        }
    }

    @Override
    public Analysis visitShowLogicalView(ShowLogicalViewStatement showLogicalViewStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.READ);
        Analysis analysis = new Analysis();
        analysis.setRealStatement(showLogicalViewStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(showLogicalViewStatement.getPathPattern());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowLogicalViewHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowCurrentTimestamp(ShowCurrentTimestampStatement showCurrentTimestampStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setRealStatement(showCurrentTimestampStatement);
        analysis.setFinishQueryAfterAnalyze(true);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowCurrentTimestampHeader());
        return analysis;
    }
}

