/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator;

import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITableTimeRangeIterator;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar.DateBinFunctionColumnTransformer;
import org.apache.tsfile.read.common.TimeRange;

public class TableDateBinTimeRangeIterator
implements ITableTimeRangeIterator {
    private final DateBinFunctionColumnTransformer dateBinTransformer;
    private boolean finished = false;
    private TimeRange curTimeRange;

    public TableDateBinTimeRangeIterator(DateBinFunctionColumnTransformer dateBinTransformer) {
        this.dateBinTransformer = dateBinTransformer;
    }

    @Override
    public boolean canFinishCurrentTimeRange(long startTime) {
        if (this.curTimeRange == null) {
            return false;
        }
        return startTime > this.curTimeRange.getMax();
    }

    @Override
    public void updateCurTimeRange(long startTime) {
        long[] timeArray = this.dateBinTransformer.dateBinStartEnd(startTime);
        if (this.curTimeRange != null) {
            if (timeArray[0] != this.curTimeRange.getMin()) {
                this.curTimeRange = new TimeRange(timeArray[0], timeArray[1] - 1L);
            }
        } else {
            this.curTimeRange = new TimeRange(timeArray[0], timeArray[1] - 1L);
        }
    }

    @Override
    public void setFinished() {
        this.curTimeRange = null;
        this.finished = true;
    }

    @Override
    public ITableTimeRangeIterator.TimeIteratorType getType() {
        return ITableTimeRangeIterator.TimeIteratorType.DATE_BIN_TIME_ITERATOR;
    }

    @Override
    public boolean hasNextTimeRange() {
        return !this.finished;
    }

    @Override
    public boolean hasCachedTimeRange() {
        return this.curTimeRange != null;
    }

    @Override
    public TimeRange getCurTimeRange() {
        return this.curTimeRange;
    }

    @Override
    public void resetCurTimeRange() {
        this.curTimeRange = null;
    }
}

