/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.consensus.deletion;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.RecoverProgressIndex;
import org.apache.iotdb.commons.pipe.datastructure.resource.PersistentResource;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.AbstractDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletionResource
implements PersistentResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletionResource.class);
    private final Consumer<DeletionResource> removeHook;
    private final AtomicInteger pipeTaskReferenceCount;
    private final AbstractDeleteDataNode deleteDataNode;
    private final ConsensusGroupId consensusGroupId;
    private volatile Status currentStatus;
    private volatile Exception cause;

    public DeletionResource(AbstractDeleteDataNode deleteDataNode, Consumer<DeletionResource> removeHook, String regionId) {
        this.deleteDataNode = deleteDataNode;
        this.removeHook = removeHook;
        this.currentStatus = Status.RUNNING;
        this.consensusGroupId = ConsensusGroupId.Factory.create((int)TConsensusGroupType.DataRegion.getValue(), (int)Integer.parseInt(regionId));
        this.pipeTaskReferenceCount = new AtomicInteger(DataRegionConsensusImpl.getInstance().getReplicationNum(this.consensusGroupId) - 1);
    }

    public synchronized void decreaseReference() {
        if (this.pipeTaskReferenceCount.get() == 1) {
            this.removeSelf();
        }
        this.pipeTaskReferenceCount.decrementAndGet();
    }

    public void removeSelf() {
        LOGGER.info("DeletionResource {} has been released, trigger a remove of DAL...", (Object)this);
        this.removeHook.accept(this);
    }

    public long getReferenceCount() {
        return this.pipeTaskReferenceCount.get();
    }

    public synchronized void onPersistFailed(Exception e) {
        this.cause = e;
        this.currentStatus = Status.FAILURE;
        this.notifyAll();
    }

    public synchronized void onPersistSucceed() {
        this.currentStatus = Status.SUCCESS;
        this.notifyAll();
    }

    public synchronized Status waitForResult() {
        while (this.currentStatus == Status.RUNNING) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted when waiting for result.", (Throwable)e);
                Thread.currentThread().interrupt();
                this.currentStatus = Status.FAILURE;
                break;
            }
        }
        return this.currentStatus;
    }

    public ProgressIndex getProgressIndex() {
        return this.deleteDataNode.getProgressIndex();
    }

    public long getFileStartTime() {
        return 0L;
    }

    public long getFileEndTime() {
        return 0L;
    }

    public AbstractDeleteDataNode getDeleteDataNode() {
        return this.deleteDataNode;
    }

    public ByteBuffer serialize() {
        ByteBuffer deletion = this.deleteDataNode.serializeToDAL();
        ByteBuffer result = ByteBuffer.allocate(deletion.limit());
        result.put(deletion);
        return result;
    }

    public static DeletionResource deserialize(ByteBuffer buffer, String regionId, Consumer<DeletionResource> removeHook) throws IOException {
        AbstractDeleteDataNode node = DeleteNodeType.deserializeFromDAL(buffer);
        return new DeletionResource(node, removeHook, regionId);
    }

    public static boolean isDeleteNodeGeneratedInLocalByIoTV2(AbstractDeleteDataNode node) {
        if (node.getProgressIndex() instanceof RecoverProgressIndex) {
            RecoverProgressIndex recoverProgressIndex = (RecoverProgressIndex)node.getProgressIndex();
            return recoverProgressIndex.getDataNodeId2LocalIndex().containsKey(IoTDBDescriptor.getInstance().getConfig().getDataNodeId());
        }
        return false;
    }

    public String toString() {
        return String.format("DeletionResource[%s]{referenceCount=%s}", this.deleteDataNode, this.getReferenceCount());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletionResource otherEvent = (DeletionResource)o;
        return Objects.equals(this.deleteDataNode, otherEvent.deleteDataNode);
    }

    public int hashCode() {
        return Objects.hash(this.deleteDataNode);
    }

    public Exception getCause() {
        return this.cause;
    }

    public static enum Status {
        SUCCESS,
        FAILURE,
        RUNNING;

    }
}

