/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.util.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.pipe.connector.util.builder.PipeTsFileBuilder;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTreeModelTsFileBuilder
extends PipeTsFileBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTreeModelTsFileBuilder.class);
    private final List<Tablet> tabletList = new ArrayList<Tablet>();
    private final List<Boolean> isTabletAlignedList = new ArrayList<Boolean>();

    public PipeTreeModelTsFileBuilder(AtomicLong currentBatchId, AtomicLong tsFileIdGenerator) {
        super(currentBatchId, tsFileIdGenerator);
    }

    @Override
    public void bufferTableModelTablet(String dataBase, Tablet tablet) {
        throw new UnsupportedOperationException("PipeTreeModelTsFileBuilder does not support table model tablet to build TSFile");
    }

    @Override
    public void bufferTreeModelTablet(Tablet tablet, Boolean isAligned) {
        this.tabletList.add(tablet);
        this.isTabletAlignedList.add(isAligned);
    }

    @Override
    public List<Pair<String, File>> convertTabletToTsFileWithDBInfo() throws IOException, WriteProcessException {
        return this.writeTabletsToTsFiles();
    }

    @Override
    public boolean isEmpty() {
        return this.tabletList.isEmpty();
    }

    @Override
    public void onSuccess() {
        super.onSuccess();
        this.tabletList.clear();
        this.isTabletAlignedList.clear();
    }

    @Override
    public synchronized void close() {
        super.close();
        this.tabletList.clear();
        this.isTabletAlignedList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<String, File>> writeTabletsToTsFiles() throws IOException, WriteProcessException {
        HashMap<String, List> device2Tablets = new HashMap<String, List>();
        HashMap<String, Boolean> device2Aligned = new HashMap<String, Boolean>();
        int size = this.tabletList.size();
        for (int i = 0; i < size; ++i) {
            Tablet tablet2 = this.tabletList.get(i);
            String deviceId = tablet2.getDeviceId();
            device2Tablets.computeIfAbsent(deviceId, k -> new ArrayList()).add(tablet2);
            device2Aligned.put(deviceId, this.isTabletAlignedList.get(i));
        }
        for (List tablets : device2Tablets.values()) {
            tablets.sort(Comparator.comparingLong(tablet -> tablet.getTimestamp(0)));
        }
        ArrayList devices = new ArrayList(device2Tablets.keySet());
        devices.sort(Comparator.naturalOrder());
        LinkedHashMap<String, LinkedList<Tablet>> device2TabletsLinkedList = new LinkedHashMap<String, LinkedList<Tablet>>();
        for (String device : devices) {
            device2TabletsLinkedList.put(device, new LinkedList((Collection)device2Tablets.get(device)));
        }
        devices.clear();
        device2Tablets.clear();
        ArrayList<Pair<String, File>> sealedFiles = new ArrayList<Pair<String, File>>();
        while (!device2TabletsLinkedList.isEmpty()) {
            if (Objects.isNull(this.fileWriter)) {
                this.createFileWriter();
            }
            try {
                this.tryBestToWriteTabletsIntoOneFile(device2TabletsLinkedList, device2Aligned);
            }
            catch (Exception e) {
                LOGGER.warn("Batch id = {}: Failed to write tablets into tsfile, because {}", new Object[]{this.currentBatchId.get(), e.getMessage(), e});
                try {
                    this.fileWriter.close();
                }
                catch (Exception closeException) {
                    LOGGER.warn("Batch id = {}: Failed to close the tsfile {} after failed to write tablets into, because {}", new Object[]{this.currentBatchId.get(), this.fileWriter.getIOWriter().getFile().getPath(), closeException.getMessage(), closeException});
                }
                finally {
                    sealedFiles.add((Pair<String, File>)new Pair(null, (Object)this.fileWriter.getIOWriter().getFile()));
                }
                for (Pair pair : sealedFiles) {
                    boolean deleteSuccess = FileUtils.deleteQuietly((File)((File)pair.right));
                    LOGGER.warn("Batch id = {}: {} delete the tsfile {} after failed to write tablets into {}. {}", new Object[]{this.currentBatchId.get(), deleteSuccess ? "Successfully" : "Failed to", ((File)pair.right).getPath(), this.fileWriter.getIOWriter().getFile().getPath(), deleteSuccess ? "" : "Maybe the tsfile needs to be deleted manually."});
                }
                sealedFiles.clear();
                this.fileWriter = null;
                throw e;
            }
            this.fileWriter.close();
            File sealedFile = this.fileWriter.getIOWriter().getFile();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Batch id = {}: Seal tsfile {} successfully.", (Object)this.currentBatchId.get(), (Object)sealedFile.getPath());
            }
            sealedFiles.add((Pair<String, File>)new Pair(null, (Object)sealedFile));
            this.fileWriter = null;
        }
        return sealedFiles;
    }

    private void tryBestToWriteTabletsIntoOneFile(LinkedHashMap<String, LinkedList<Tablet>> device2TabletsLinkedList, Map<String, Boolean> device2Aligned) throws IOException, WriteProcessException {
        Iterator<Map.Entry<String, LinkedList<Tablet>>> iterator = device2TabletsLinkedList.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean isAligned;
            Map.Entry<String, LinkedList<Tablet>> entry = iterator.next();
            String deviceId = entry.getKey();
            LinkedList<Tablet> tablets = entry.getValue();
            ArrayList<Tablet> tabletsToWrite = new ArrayList<Tablet>();
            Tablet lastTablet = null;
            while (!tablets.isEmpty()) {
                Tablet tablet2 = tablets.peekFirst();
                if (!Objects.isNull(lastTablet) && lastTablet.getTimestamp(lastTablet.getRowSize() - 1) >= tablet2.getTimestamp(0)) break;
                tabletsToWrite.add(tablet2);
                lastTablet = tablet2;
                tablets.pollFirst();
            }
            if (tablets.isEmpty()) {
                iterator.remove();
            }
            if (isAligned = device2Aligned.get(deviceId).booleanValue()) {
                HashMap deviceId2MeasurementSchemas = new HashMap();
                tabletsToWrite.forEach(tablet -> deviceId2MeasurementSchemas.compute(tablet.getDeviceId(), (k, v) -> {
                    if (Objects.isNull(v)) {
                        return new ArrayList(tablet.getSchemas());
                    }
                    v.addAll(tablet.getSchemas());
                    return v;
                }));
                for (Map.Entry deviceIdWithMeasurementSchemas : deviceId2MeasurementSchemas.entrySet()) {
                    this.fileWriter.registerAlignedTimeseries(new Path((String)deviceIdWithMeasurementSchemas.getKey()), (List)deviceIdWithMeasurementSchemas.getValue());
                }
                for (Tablet tablet3 : tabletsToWrite) {
                    this.fileWriter.writeAligned(tablet3);
                }
                continue;
            }
            for (Tablet tablet4 : tabletsToWrite) {
                for (IMeasurementSchema schema : tablet4.getSchemas()) {
                    try {
                        this.fileWriter.registerTimeseries(IDeviceID.Factory.DEFAULT_FACTORY.create(tablet4.getDeviceId()), schema);
                    }
                    catch (WriteProcessException writeProcessException) {}
                }
                this.fileWriter.writeTree(tablet4);
            }
        }
    }
}

