/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.TableDeletionEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.TreeDeletionEntry;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.tsfile.file.metadata.AbstractAlignedChunkMetadata;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.Pair;

public class ModificationUtils {
    private ModificationUtils() {
    }

    public static boolean overlap(long startA, long endA, long startB, long endB) {
        return endB >= startA && startB <= endA;
    }

    public static void modifyChunkMetaData(List<? extends IChunkMetadata> chunkMetaData, List<ModEntry> modifications) {
        for (IChunkMetadata iChunkMetadata : chunkMetaData) {
            for (ModEntry modification : modifications) {
                ModificationUtils.doModifyChunkMetaData(modification, iChunkMetadata);
            }
        }
        chunkMetaData.removeIf(metaData -> {
            if (metaData.getDeleteIntervalList() != null) {
                for (TimeRange range : metaData.getDeleteIntervalList()) {
                    if (range.contains(metaData.getStartTime(), metaData.getEndTime())) {
                        return true;
                    }
                    if (!range.overlaps(new TimeRange(metaData.getStartTime(), metaData.getEndTime()))) continue;
                    metaData.setModified(true);
                }
            }
            return false;
        });
    }

    public static void modifyAlignedChunkMetaData(List<AlignedChunkMetadata> chunkMetaData, List<List<ModEntry>> modifications) {
        for (AlignedChunkMetadata metaData : chunkMetaData) {
            ModificationUtils.modifyValueColumns((AbstractAlignedChunkMetadata)metaData, modifications);
        }
        chunkMetaData.removeIf(alignedChunkMetadata -> ModificationUtils.areAllValueColumnsDeleted((AbstractAlignedChunkMetadata)alignedChunkMetadata, false));
    }

    private static void modifyValueColumns(AbstractAlignedChunkMetadata metaData, List<List<ModEntry>> valueColumnsModifications) {
        List valueChunkMetadataList = metaData.getValueChunkMetadataList();
        for (int j = 0; j < valueChunkMetadataList.size(); ++j) {
            IChunkMetadata v = (IChunkMetadata)valueChunkMetadataList.get(j);
            if (v == null) continue;
            List<ModEntry> modificationList = valueColumnsModifications.get(j);
            for (ModEntry modification : modificationList) {
                ModificationUtils.doModifyChunkMetaData(modification, v);
            }
        }
    }

    private static boolean areAllValueColumnsDeleted(AbstractAlignedChunkMetadata alignedChunkMetadata, boolean modified) {
        boolean allValueColumnsAreDeleted = true;
        List valueChunkMetadataList = alignedChunkMetadata.getValueChunkMetadataList();
        for (int i = 0; i < valueChunkMetadataList.size(); ++i) {
            IChunkMetadata valueChunkMetadata = (IChunkMetadata)valueChunkMetadataList.get(i);
            if (valueChunkMetadata == null) continue;
            boolean currentRemoved = false;
            if (valueChunkMetadata.getDeleteIntervalList() != null) {
                for (TimeRange range : valueChunkMetadata.getDeleteIntervalList()) {
                    if (range.contains(valueChunkMetadata.getStartTime(), valueChunkMetadata.getEndTime())) {
                        valueChunkMetadataList.set(i, null);
                        currentRemoved = true;
                        break;
                    }
                    if (!range.overlaps(new TimeRange(valueChunkMetadata.getStartTime(), valueChunkMetadata.getEndTime()))) continue;
                    valueChunkMetadata.setModified(true);
                    modified = true;
                }
            }
            if (currentRemoved) continue;
            allValueColumnsAreDeleted = false;
        }
        alignedChunkMetadata.setModified(modified);
        return allValueColumnsAreDeleted;
    }

    public static void modifyAlignedChunkMetaData(List<? extends AbstractAlignedChunkMetadata> chunkMetaData, List<ModEntry> timeColumnModifications, List<List<ModEntry>> valueColumnsModifications, boolean ignoreAllNullRows) {
        for (AbstractAlignedChunkMetadata abstractAlignedChunkMetadata : chunkMetaData) {
            IChunkMetadata timeColumnChunkMetadata = abstractAlignedChunkMetadata.getTimeChunkMetadata();
            for (ModEntry modification : timeColumnModifications) {
                ModificationUtils.doModifyChunkMetaData(modification, timeColumnChunkMetadata);
            }
            ModificationUtils.modifyValueColumns(abstractAlignedChunkMetadata, valueColumnsModifications);
        }
        chunkMetaData.removeIf(alignedChunkMetadata -> {
            boolean modified = false;
            IChunkMetadata timeColumnChunkMetadata = alignedChunkMetadata.getTimeChunkMetadata();
            if (timeColumnChunkMetadata.getDeleteIntervalList() != null) {
                for (TimeRange range : timeColumnChunkMetadata.getDeleteIntervalList()) {
                    if (range.contains(timeColumnChunkMetadata.getStartTime(), timeColumnChunkMetadata.getEndTime())) {
                        return true;
                    }
                    if (!range.overlaps(new TimeRange(timeColumnChunkMetadata.getStartTime(), timeColumnChunkMetadata.getEndTime()))) continue;
                    timeColumnChunkMetadata.setModified(true);
                    modified = true;
                }
            }
            boolean allValueColumnsAreDeleted = ModificationUtils.areAllValueColumnsDeleted(alignedChunkMetadata, modified);
            return ignoreAllNullRows && allValueColumnsAreDeleted;
        });
    }

    public static boolean isPointDeleted(long timestamp, List<TimeRange> deletionList, int[] deleteCursor) {
        if (deleteCursor.length != 1) {
            throw new IllegalArgumentException("deleteCursor should be an array whose size is 1");
        }
        while (deletionList != null && deleteCursor[0] < deletionList.size()) {
            if (deletionList.get(deleteCursor[0]).contains(timestamp)) {
                return true;
            }
            if (deletionList.get(deleteCursor[0]).getMax() < timestamp) {
                deleteCursor[0] = deleteCursor[0] + 1;
                continue;
            }
            return false;
        }
        return false;
    }

    public static boolean isPointDeletedWithoutOrderedRange(long timestamp, List<TimeRange> timeRangeList) {
        for (TimeRange range : timeRangeList) {
            if (!range.contains(timestamp)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPointDeleted(long timestamp, List<TimeRange> deletionList) {
        int[] deleteCursor = new int[]{0};
        return ModificationUtils.isPointDeleted(timestamp, deletionList, deleteCursor);
    }

    public static boolean isAllDeletedByMods(Collection<ModEntry> modifications, IDeviceID device, long startTime, long endTime) {
        for (ModEntry modification : modifications) {
            if (!modification.affectsAll(device) || !modification.getTimeRange().contains(startTime, endTime)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllDeletedByMods(Collection<ModEntry> modifications, long startTime, long endTime) {
        if (modifications == null || modifications.isEmpty()) {
            return false;
        }
        for (ModEntry modification : modifications) {
            if (!modification.getTimeRange().contains(startTime, endTime)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTimeseriesDeletedByMods(Collection<ModEntry> modifications, IDeviceID device, String timeseriesId, long startTime, long endTime) {
        for (ModEntry modification : modifications) {
            if (!modification.affects(device) || !modification.affects(timeseriesId) || !modification.getTimeRange().contains(startTime, endTime)) continue;
            return true;
        }
        return false;
    }

    private static void doModifyChunkMetaData(ModEntry modification, IChunkMetadata metaData) {
        metaData.insertIntoSortedDeletions(modification.getTimeRange());
    }

    public static List<List<TimeRange>> constructDeletionList(IDeviceID deviceID, List<String> measurementList, IMemTable memTable, List<Pair<ModEntry, IMemTable>> modsToMemtable, long timeLowerBound) {
        if (measurementList.isEmpty()) {
            return Collections.emptyList();
        }
        List<ModEntry> modifications = ModificationUtils.getModificationsForMemtable(memTable, modsToMemtable);
        ArrayList<List<TimeRange>> deletionList = new ArrayList<List<TimeRange>>();
        for (String measurement : measurementList) {
            ArrayList<TimeRange> columnDeletionList = new ArrayList<TimeRange>();
            columnDeletionList.add(new TimeRange(Long.MIN_VALUE, timeLowerBound));
            for (ModEntry modification : modifications) {
                if (!modification.affects(deviceID) || !modification.affects(measurement) || modification.getEndTime() <= timeLowerBound) continue;
                long lowerBound = Math.max(modification.getStartTime(), timeLowerBound);
                columnDeletionList.add(new TimeRange(lowerBound, modification.getEndTime()));
            }
            deletionList.add(TimeRange.sortAndMerge(columnDeletionList));
        }
        return deletionList;
    }

    public static List<TimeRange> constructDeletionList(IDeviceID deviceID, String measurement, IMemTable memTable, List<Pair<ModEntry, IMemTable>> modsToMemtable, long timeLowerBound) {
        ArrayList<TimeRange> deletionList = new ArrayList<TimeRange>();
        deletionList.add(new TimeRange(Long.MIN_VALUE, timeLowerBound));
        for (ModEntry modification : ModificationUtils.getModificationsForMemtable(memTable, modsToMemtable)) {
            if (!modification.affects(deviceID) || !modification.affects(measurement) || modification.getEndTime() <= timeLowerBound) continue;
            long lowerBound = Math.max(modification.getStartTime(), timeLowerBound);
            deletionList.add(new TimeRange(lowerBound, modification.getEndTime()));
        }
        return TimeRange.sortAndMerge(deletionList);
    }

    private static List<ModEntry> getModificationsForMemtable(IMemTable memTable, List<Pair<ModEntry, IMemTable>> modsToMemtable) {
        ArrayList<ModEntry> modifications = new ArrayList<ModEntry>();
        boolean foundMemtable = false;
        for (Pair<ModEntry, IMemTable> entry : modsToMemtable) {
            if (!foundMemtable && !((IMemTable)entry.right).equals(memTable)) continue;
            modifications.add((ModEntry)entry.left);
            foundMemtable = true;
        }
        return modifications;
    }

    public static boolean canMerge(TimeRange left, TimeRange right) {
        long extendedRightMin = right.getMin() == Long.MIN_VALUE ? right.getMin() : right.getMin() - 1L;
        return extendedRightMin <= left.getMax();
    }

    public static boolean canMerge(ModEntry left, ModEntry right) {
        if (!Objects.equals(left.getClass(), right.getClass()) || !ModificationUtils.canMerge(left.getTimeRange(), right.getTimeRange())) {
            return false;
        }
        if (left instanceof TreeDeletionEntry) {
            return Objects.equals(((TreeDeletionEntry)left).getPathPattern(), ((TreeDeletionEntry)right).getPathPattern());
        }
        if (left instanceof TableDeletionEntry) {
            return Objects.equals(((TableDeletionEntry)left).getPredicate(), ((TableDeletionEntry)right).getPredicate());
        }
        return false;
    }

    public static List<ModEntry> sortAndMerge(List<ModEntry> modifications) {
        modifications.sort(Comparator.comparing(ModEntry::getTimeRange));
        ArrayList<ModEntry> result = new ArrayList<ModEntry>();
        if (!modifications.isEmpty()) {
            ModEntry current = modifications.get(0).clone();
            for (int i = 1; i < modifications.size(); ++i) {
                ModEntry next = modifications.get(i);
                if (ModificationUtils.canMerge(current, next)) {
                    current.getTimeRange().merge(next.getTimeRange());
                    continue;
                }
                result.add(current);
                current = next.clone();
            }
            result.add(current);
        }
        return result;
    }

    public static boolean isDeviceDeletedByMods(Collection<ModEntry> currentModifications, ITimeIndex currentTimeIndex, IDeviceID device) throws IllegalPathException {
        if (currentTimeIndex == null) {
            return false;
        }
        Optional startTime = currentTimeIndex.getStartTime(device);
        Optional endTime = currentTimeIndex.getEndTime(device);
        if (startTime.isPresent() && endTime.isPresent()) {
            return ModificationUtils.isAllDeletedByMods(currentModifications, device, (Long)startTime.get(), (Long)endTime.get());
        }
        return false;
    }
}

