/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.table.column;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class TsTableColumnSchema {
    protected String columnName;
    protected TSDataType dataType;
    protected Map<String, String> props = null;

    TsTableColumnSchema(String columnName, TSDataType dataType) {
        this.columnName = columnName;
        this.dataType = dataType;
    }

    TsTableColumnSchema(String columnName, TSDataType dataType, Map<String, String> props) {
        this.columnName = columnName;
        this.dataType = dataType;
        this.props = props;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public Map<String, String> getProps() {
        if (Objects.isNull(this.props)) {
            this.props = new HashMap<String, String>();
        }
        return this.props;
    }

    public abstract TsTableColumnCategory getColumnCategory();

    void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.columnName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((TSDataType)this.dataType, (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.props, (OutputStream)outputStream);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(this.columnName);
    }

    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnName", (Object)this.columnName).add("dataType", (Object)this.dataType).add("props", this.props).toString();
    }
}

