/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.visibility;

import java.util.Arrays;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.datastructure.visibility.Visibility;
import org.apache.iotdb.pipe.api.annotation.TableModel;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisibilityUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(VisibilityUtils.class);

    private VisibilityUtils() {
    }

    public static boolean isCompatible(Visibility visibility, boolean isTableModel) {
        if (Objects.equals((Object)Visibility.BOTH, (Object)visibility)) {
            return true;
        }
        return isTableModel ? Objects.equals((Object)Visibility.TABLE_ONLY, (Object)visibility) : Objects.equals((Object)Visibility.TREE_ONLY, (Object)visibility);
    }

    public static boolean isCompatible(Visibility base, Visibility incoming) {
        if (Objects.equals((Object)base, (Object)Visibility.BOTH)) {
            return true;
        }
        if (Objects.equals((Object)base, (Object)Visibility.TREE_ONLY)) {
            return Objects.equals((Object)incoming, (Object)Visibility.TREE_ONLY);
        }
        if (Objects.equals((Object)base, (Object)Visibility.TABLE_ONLY)) {
            return Objects.equals((Object)incoming, (Object)Visibility.TABLE_ONLY);
        }
        return false;
    }

    public static boolean isCompatible(Visibility pipeVisibility, Visibility ... pluginVisibilities) {
        return Arrays.stream(pluginVisibilities).allMatch(pluginVisibility -> VisibilityUtils.isCompatible(pluginVisibility, pipeVisibility));
    }

    public static Visibility calculateFromPluginClass(Class<?> pipePluginClass) {
        boolean isTreeModelAnnotationPresent = pipePluginClass.isAnnotationPresent(TreeModel.class);
        boolean isTableModelAnnotationPresent = pipePluginClass.isAnnotationPresent(TableModel.class);
        if (!isTreeModelAnnotationPresent && !isTableModelAnnotationPresent) {
            return Visibility.TREE_ONLY;
        }
        if (isTreeModelAnnotationPresent && !isTableModelAnnotationPresent) {
            return Visibility.TREE_ONLY;
        }
        if (!isTreeModelAnnotationPresent && isTableModelAnnotationPresent) {
            return Visibility.TABLE_ONLY;
        }
        return Visibility.BOTH;
    }

    public static Visibility calculateFromExtractorParameters(PipeParameters extractorParameters) {
        boolean isCaptureTable;
        boolean isDoubleLiving = extractorParameters.getBooleanOrDefault(Arrays.asList("extractor.mode.double-living", "source.mode.double-living"), false);
        if (isDoubleLiving) {
            return Visibility.BOTH;
        }
        boolean isTreeDialect = extractorParameters.getStringOrDefault("__system.sql-dialect", "tree").equals("tree");
        Boolean _isCaptureTree = extractorParameters.getBooleanByKeys(new String[]{"extractor.capture.tree", "source.capture.tree"});
        boolean isCaptureTree = Objects.nonNull(_isCaptureTree) ? _isCaptureTree : isTreeDialect;
        Boolean _isCaptureTable = extractorParameters.getBooleanByKeys(new String[]{"extractor.capture.table", "source.capture.table"});
        boolean bl = Objects.nonNull(_isCaptureTable) ? _isCaptureTable : (isCaptureTable = !isTreeDialect);
        if (isCaptureTree && isCaptureTable) {
            return Visibility.BOTH;
        }
        if (isCaptureTree) {
            return Visibility.TREE_ONLY;
        }
        if (isCaptureTable) {
            return Visibility.TABLE_ONLY;
        }
        LOGGER.error("BROKEN INVARIANT: DETECT INVISIBLE EXTRACTOR PARAMETERS {}", (Object)extractorParameters.getAttribute());
        return Visibility.NONE;
    }
}

