/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription;

import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionParameterNotValidException;
import org.apache.iotdb.session.AbstractSessionBuilder;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.SessionConnection;
import org.apache.iotdb.session.subscription.SubscriptionSessionConnection;

public final class SubscriptionSessionWrapper
extends Session {
    public SubscriptionSessionWrapper(AbstractSessionBuilder builder) {
        super(builder);
    }

    @Override
    public void open() throws IoTDBConnectionException {
        super.open();
    }

    @Override
    public void close() throws IoTDBConnectionException {
        super.close();
    }

    @Override
    public SessionConnection constructSessionConnection(Session session, TEndPoint endpoint, ZoneId zoneId) throws IoTDBConnectionException {
        if (Objects.isNull(endpoint)) {
            throw new SubscriptionParameterNotValidException("Subscription session must be configured with an endpoint.");
        }
        return new SubscriptionSessionConnection(session, endpoint, zoneId, (Supplier<List<TEndPoint>>)this.availableNodes, this.maxRetryCount, this.retryIntervalInMs, this.sqlDialect, this.database);
    }

    public SubscriptionSessionConnection getSessionConnection() {
        return (SubscriptionSessionConnection)this.defaultSessionConnection;
    }

    public int getThriftMaxFrameSize() {
        return this.thriftMaxFrameSize;
    }
}

