/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.splitter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.storageengine.load.splitter.ChunkData;
import org.apache.iotdb.db.storageengine.load.splitter.DeletionData;
import org.apache.iotdb.db.storageengine.load.splitter.TsFileDataType;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public interface TsFileData {
    public long getDataSize();

    public TsFileDataType getType();

    public void serialize(DataOutputStream var1) throws IOException;

    public static TsFileData deserialize(InputStream stream) throws IOException, PageException, IllegalPathException {
        TsFileDataType type = TsFileDataType.values()[ReadWriteIOUtils.readInt((InputStream)stream)];
        switch (type) {
            case CHUNK: {
                return ChunkData.deserialize(stream);
            }
            case DELETION: {
                return DeletionData.deserialize(stream);
            }
        }
        throw new UnsupportedOperationException("Unknown TsFileData type: " + (Object)((Object)type));
    }
}

