/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinAggregationFunction;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.relational.function.BoundSignature;
import org.apache.iotdb.db.queryengine.plan.relational.function.FunctionId;
import org.apache.iotdb.db.queryengine.plan.relational.function.FunctionKind;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.FunctionNullability;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ResolvedFunction;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationTreeDeviceViewScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.Pair;

public class Util {
    private Util() {
    }

    public static Pair<AggregationNode, AggregationNode> split(AggregationNode node, SymbolAllocator symbolAllocator, QueryId queryId) {
        LinkedHashMap<Symbol, AggregationNode.Aggregation> intermediateAggregation = new LinkedHashMap<Symbol, AggregationNode.Aggregation>();
        LinkedHashMap<Symbol, AggregationNode.Aggregation> finalAggregation = new LinkedHashMap<Symbol, AggregationNode.Aggregation>();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
            AggregationNode.Aggregation originalAggregation = entry.getValue();
            ResolvedFunction resolvedFunction = originalAggregation.getResolvedFunction();
            Type intermediateType = TableBuiltinAggregationFunction.getIntermediateType((String)resolvedFunction.getSignature().getName(), resolvedFunction.getSignature().getArgumentTypes());
            Symbol intermediateSymbol = symbolAllocator.newSymbol(resolvedFunction.getSignature().getName(), intermediateType);
            Preconditions.checkState((!originalAggregation.getOrderingScheme().isPresent() ? 1 : 0) != 0, (Object)"Aggregate with ORDER BY does not support partial aggregation");
            intermediateAggregation.put(intermediateSymbol, new AggregationNode.Aggregation(resolvedFunction, originalAggregation.getArguments(), originalAggregation.isDistinct(), originalAggregation.getFilter(), originalAggregation.getOrderingScheme(), originalAggregation.getMask()));
            finalAggregation.put(entry.getKey(), new AggregationNode.Aggregation(resolvedFunction, (List<Expression>)ImmutableList.of((Object)intermediateSymbol.toSymbolReference()), false, Optional.empty(), Optional.empty(), Optional.empty()));
        }
        return new Pair((Object)new AggregationNode(node.getPlanNodeId(), null, finalAggregation, node.getGroupingSets(), node.getPreGroupedSymbols(), AggregationNode.Step.FINAL, node.getHashSymbol(), node.getGroupIdSymbol()), (Object)new AggregationNode(queryId.genPlanNodeId(), null, intermediateAggregation, node.getGroupingSets(), node.getPreGroupedSymbols(), node.getStep() == AggregationNode.Step.SINGLE ? AggregationNode.Step.PARTIAL : AggregationNode.Step.INTERMEDIATE, node.getHashSymbol(), node.getGroupIdSymbol()));
    }

    public static Pair<AggregationNode, AggregationTableScanNode> split(AggregationTableScanNode node, SymbolAllocator symbolAllocator, QueryId queryId) {
        AggregationTreeDeviceViewScanNode aggregationTreeDeviceViewScanNode = node instanceof AggregationTreeDeviceViewScanNode ? (AggregationTreeDeviceViewScanNode)node : null;
        LinkedHashMap<Symbol, AggregationNode.Aggregation> intermediateAggregation = new LinkedHashMap<Symbol, AggregationNode.Aggregation>();
        LinkedHashMap<Symbol, AggregationNode.Aggregation> finalAggregation = new LinkedHashMap<Symbol, AggregationNode.Aggregation>();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
            AggregationNode.Aggregation originalAggregation = entry.getValue();
            ResolvedFunction resolvedFunction = originalAggregation.getResolvedFunction();
            Type intermediateType = TableBuiltinAggregationFunction.getIntermediateType((String)resolvedFunction.getSignature().getName(), resolvedFunction.getSignature().getArgumentTypes());
            Symbol intermediateSymbol = symbolAllocator.newSymbol(resolvedFunction.getSignature().getName(), intermediateType);
            Preconditions.checkState((!originalAggregation.getOrderingScheme().isPresent() ? 1 : 0) != 0, (Object)"Aggregate with ORDER BY does not support partial aggregation");
            intermediateAggregation.put(intermediateSymbol, new AggregationNode.Aggregation(resolvedFunction, originalAggregation.getArguments(), originalAggregation.isDistinct(), originalAggregation.getFilter(), originalAggregation.getOrderingScheme(), originalAggregation.getMask()));
            finalAggregation.put(entry.getKey(), new AggregationNode.Aggregation(resolvedFunction, (List<Expression>)ImmutableList.of((Object)intermediateSymbol.toSymbolReference()), false, Optional.empty(), Optional.empty(), Optional.empty()));
        }
        AggregationTableScanNode rightResult = aggregationTreeDeviceViewScanNode == null ? new AggregationTableScanNode(queryId.genPlanNodeId(), node.getQualifiedObjectName(), node.getOutputSymbols(), node.getAssignments(), (List<DeviceEntry>)ImmutableList.of(), node.getIdAndAttributeIndexMap(), node.getScanOrder(), node.getTimePredicate().orElse(null), node.getPushDownPredicate(), node.getPushDownLimit(), node.getPushDownOffset(), node.isPushLimitToEachDevice(), node.containsNonAlignedDevice(), node.getProjection(), intermediateAggregation, node.getGroupingSets(), node.getPreGroupedSymbols(), AggregationNode.Step.PARTIAL, node.getGroupIdSymbol()) : new AggregationTreeDeviceViewScanNode(queryId.genPlanNodeId(), node.getQualifiedObjectName(), node.getOutputSymbols(), node.getAssignments(), (List<DeviceEntry>)ImmutableList.of(), node.getIdAndAttributeIndexMap(), node.getScanOrder(), node.getTimePredicate().orElse(null), node.getPushDownPredicate(), node.getPushDownLimit(), node.getPushDownOffset(), node.isPushLimitToEachDevice(), node.containsNonAlignedDevice(), node.getProjection(), intermediateAggregation, node.getGroupingSets(), node.getPreGroupedSymbols(), AggregationNode.Step.PARTIAL, node.getGroupIdSymbol(), aggregationTreeDeviceViewScanNode.getTreeDBName(), aggregationTreeDeviceViewScanNode.getMeasurementColumnNameMap());
        return new Pair((Object)new AggregationNode(node.getPlanNodeId(), null, finalAggregation, node.getGroupingSets(), node.getPreGroupedSymbols(), AggregationNode.Step.FINAL, Optional.empty(), node.getGroupIdSymbol()), (Object)rightResult);
    }

    public static ResolvedFunction getResolvedBuiltInAggregateFunction(Metadata metadata, String functionName, List<Type> argumentTypes) {
        Type type = metadata.getFunctionReturnType(functionName, argumentTypes);
        return new ResolvedFunction(new BoundSignature(functionName.toLowerCase(Locale.ENGLISH), type, argumentTypes), new FunctionId("noop"), FunctionKind.AGGREGATE, true, FunctionNullability.getAggregationFunctionNullability(argumentTypes.size()));
    }
}

