/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ApplyNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class PruneApplyCorrelation
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode();

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode applyNode, Captures captures, Rule.Context context) {
        Set<Symbol> subquerySymbols = SymbolsExtractor.extractUnique(applyNode.getSubquery(), context.getLookup());
        List newCorrelation = (List)applyNode.getCorrelation().stream().filter(subquerySymbols::contains).collect(ImmutableList.toImmutableList());
        if (newCorrelation.size() < applyNode.getCorrelation().size()) {
            return Rule.Result.ofPlanNode(new ApplyNode(applyNode.getPlanNodeId(), applyNode.getInput(), applyNode.getSubquery(), applyNode.getSubqueryAssignments(), newCorrelation, applyNode.getOriginSubquery()));
        }
        return Rule.Result.empty();
    }
}

