/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.util.sorter;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.iotdb.db.pipe.connector.util.sorter.PipeTabletEventSorter;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class PipeTreeModelTabletEventSorter {
    private final Tablet tablet;
    private boolean isSorted = true;
    private boolean isDeduplicated = true;
    private Integer[] index;
    private int deduplicatedSize;

    public PipeTreeModelTabletEventSorter(Tablet tablet) {
        this.tablet = tablet;
        this.deduplicatedSize = tablet == null ? 0 : tablet.getRowSize();
    }

    public void deduplicateAndSortTimestampsIfNecessary() {
        int i;
        if (this.tablet == null || this.tablet.getRowSize() == 0) {
            return;
        }
        long[] timestamps = this.tablet.getTimestamps();
        int size = this.tablet.getRowSize();
        for (i = 1; i < size; ++i) {
            long currentTimestamp = timestamps[i];
            long previousTimestamp = timestamps[i - 1];
            if (currentTimestamp < previousTimestamp) {
                this.isSorted = false;
                break;
            }
            if (currentTimestamp != previousTimestamp) continue;
            this.isDeduplicated = false;
        }
        if (this.isSorted && this.isDeduplicated) {
            return;
        }
        this.index = new Integer[this.tablet.getRowSize()];
        size = this.tablet.getRowSize();
        for (i = 0; i < size; ++i) {
            this.index[i] = i;
        }
        if (!this.isSorted) {
            this.sortTimestamps();
            this.deduplicateTimestamps();
            this.isDeduplicated = true;
        }
        if (!this.isDeduplicated) {
            this.deduplicateTimestamps();
        }
        this.sortAndDeduplicateValuesAndBitMaps();
    }

    private void sortTimestamps() {
        Arrays.sort(this.index, Comparator.comparingLong(arg_0 -> ((Tablet)this.tablet).getTimestamp(arg_0)));
        Arrays.sort(this.tablet.getTimestamps(), 0, this.tablet.getRowSize());
    }

    private void deduplicateTimestamps() {
        this.deduplicatedSize = 1;
        long[] timestamps = this.tablet.getTimestamps();
        int size = this.tablet.getRowSize();
        for (int i = 1; i < size; ++i) {
            if (timestamps[i] == timestamps[i - 1]) continue;
            this.index[this.deduplicatedSize] = this.index[i];
            timestamps[this.deduplicatedSize] = timestamps[i];
            ++this.deduplicatedSize;
        }
        this.tablet.setRowSize(this.deduplicatedSize);
    }

    private void sortAndDeduplicateValuesAndBitMaps() {
        int columnIndex = 0;
        int size = this.tablet.getSchemas().size();
        for (int i = 0; i < size; ++i) {
            IMeasurementSchema schema = (IMeasurementSchema)this.tablet.getSchemas().get(i);
            if (schema == null) continue;
            this.tablet.getValues()[columnIndex] = PipeTabletEventSorter.reorderValueList(this.deduplicatedSize, this.tablet.getValues()[columnIndex], schema.getType(), this.index);
            if (this.tablet.getBitMaps() != null && this.tablet.getBitMaps()[columnIndex] != null) {
                this.tablet.getBitMaps()[columnIndex] = PipeTabletEventSorter.reorderBitMap(this.deduplicatedSize, this.tablet.getBitMaps()[columnIndex], this.index);
            }
            ++columnIndex;
        }
    }
}

