/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.extractor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanVisitor;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorRelationalPlan;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorTreePlan;

public class PipeConfigPhysicalPlanTableScopeParseVisitor
extends ConfigPhysicalPlanVisitor<Optional<ConfigPhysicalPlan>, Void> {
    @Override
    public Optional<ConfigPhysicalPlan> visitPlan(ConfigPhysicalPlan plan, Void context) {
        return Optional.of(plan);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantUserAll(AuthorRelationalPlan plan, Void context) {
        return this.visitTableAuthorPlan(plan, ConfigPhysicalPlanType.GrantUser);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantRoleAll(AuthorRelationalPlan plan, Void context) {
        return this.visitTableAuthorPlan(plan, ConfigPhysicalPlanType.GrantRole);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeUserAll(AuthorRelationalPlan plan, Void context) {
        return this.visitTableAuthorPlan(plan, ConfigPhysicalPlanType.RevokeUser);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeRoleAll(AuthorRelationalPlan plan, Void context) {
        return this.visitTableAuthorPlan(plan, ConfigPhysicalPlanType.RevokeRole);
    }

    private Optional<ConfigPhysicalPlan> visitTableAuthorPlan(AuthorRelationalPlan authorRelationalPlan, ConfigPhysicalPlanType type) {
        Set<Integer> permissions = Arrays.stream(PrivilegeType.values()).filter(PrivilegeType::forRelationalSys).map(Enum::ordinal).collect(Collectors.toSet());
        return !permissions.isEmpty() ? Optional.of(new AuthorTreePlan(type, authorRelationalPlan.getUserName(), authorRelationalPlan.getRoleName(), authorRelationalPlan.getPassword(), authorRelationalPlan.getNewPassword(), permissions, authorRelationalPlan.getGrantOpt(), Collections.emptyList())) : Optional.empty();
    }
}

