/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.region;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionGroupAllocator;

public class GreedyRegionGroupAllocator
implements IRegionGroupAllocator {
    public static final Random RANDOM = new Random();

    @Override
    public TRegionReplicaSet generateOptimalRegionReplicasDistribution(Map<Integer, TDataNodeConfiguration> availableDataNodeMap, Map<Integer, Double> freeDiskSpaceMap, List<TRegionReplicaSet> allocatedRegionGroups, List<TRegionReplicaSet> databaseAllocatedRegionGroups, int replicationFactor, TConsensusGroupId consensusGroupId) {
        List<TDataNodeLocation> weightList = this.buildWeightList(availableDataNodeMap, freeDiskSpaceMap, allocatedRegionGroups);
        return new TRegionReplicaSet(consensusGroupId, weightList.stream().limit(replicationFactor).collect(Collectors.toList()));
    }

    private List<TDataNodeLocation> buildWeightList(Map<Integer, TDataNodeConfiguration> availableDataNodeMap, Map<Integer, Double> freeDiskSpaceMap, List<TRegionReplicaSet> allocatedRegionGroups) {
        HashMap regionCounter = new HashMap(availableDataNodeMap.size());
        allocatedRegionGroups.forEach(regionReplicaSet -> regionReplicaSet.getDataNodeLocations().forEach(dataNodeLocation -> regionCounter.merge(dataNodeLocation.getDataNodeId(), 1, Integer::sum)));
        ArrayList entryList = new ArrayList();
        availableDataNodeMap.forEach((datanodeId, dataNodeConfiguration) -> entryList.add(new DataNodeEntry((int)datanodeId, regionCounter.getOrDefault(datanodeId, 0), freeDiskSpaceMap.getOrDefault(datanodeId, 0.0))));
        return entryList.stream().sorted().map(entry -> ((TDataNodeConfiguration)availableDataNodeMap.get(entry.dataNodeId)).getLocation()).collect(Collectors.toList());
    }

    public static class DataNodeEntry
    implements Comparable<DataNodeEntry> {
        public int dataNodeId;
        public int regionCount;
        public double freeDiskSpace;
        public int randomWeight;

        public DataNodeEntry(int dataNodeId, int regionCount, double freeDiskSpace) {
            this.dataNodeId = dataNodeId;
            this.regionCount = regionCount;
            this.freeDiskSpace = freeDiskSpace;
            this.randomWeight = RANDOM.nextInt();
        }

        @Override
        public int compareTo(DataNodeEntry other) {
            if (this.regionCount != other.regionCount) {
                return this.regionCount - other.regionCount;
            }
            if (this.freeDiskSpace != other.freeDiskSpace) {
                return (int)(other.freeDiskSpace - this.freeDiskSpace);
            }
            return this.randomWeight - other.randomWeight;
        }
    }
}

