/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter;

public enum SchemaFilterType {
    NULL(-1),
    TAGS_FILTER(1),
    PATH_CONTAINS(2),
    DATA_TYPE(3),
    VIEW_TYPE(4),
    AND(5),
    TEMPLATE_FILTER(6),
    ID(7),
    ATTRIBUTE(8),
    OR(9),
    NOT(10),
    PRECISE(11),
    IN(12),
    LIKE(13),
    COMPARISON(14);

    private final short code;

    private SchemaFilterType(short code) {
        this.code = code;
    }

    public short getCode() {
        return this.code;
    }

    public static SchemaFilterType getSchemaFilterType(short code) {
        switch (code) {
            case -1: {
                return NULL;
            }
            case 1: {
                return TAGS_FILTER;
            }
            case 2: {
                return PATH_CONTAINS;
            }
            case 3: {
                return DATA_TYPE;
            }
            case 4: {
                return VIEW_TYPE;
            }
            case 5: {
                return AND;
            }
            case 6: {
                return TEMPLATE_FILTER;
            }
            case 7: {
                return ID;
            }
            case 8: {
                return ATTRIBUTE;
            }
            case 9: {
                return OR;
            }
            case 10: {
                return NOT;
            }
            case 11: {
                return PRECISE;
            }
            case 12: {
                return IN;
            }
            case 13: {
                return LIKE;
            }
            case 14: {
                return COMPARISON;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + code);
    }
}

