/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.container;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.async.AsyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.client.property.PipeConsensusClientProperty;
import org.apache.iotdb.commons.client.sync.SyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;

public class PipeConsensusClientMgrContainer {
    private static final CommonConfig CONF = CommonDescriptor.getInstance().getConfig();
    private final PipeConsensusClientProperty config = PipeConsensusClientProperty.newBuilder().setIsRpcThriftCompressionEnabled(CONF.isRpcThriftCompressionEnabled()).setMaxClientNumForEachNode(CONF.getMaxClientNumForEachNode()).setSelectorNumOfClientManager(CONF.getSelectorNumOfClientManager()).build();

    private PipeConsensusClientMgrContainer() {
    }

    public IClientManager<TEndPoint, AsyncPipeConsensusServiceClient> newAsyncClientManager() {
        return new IClientManager.Factory<TEndPoint, AsyncPipeConsensusServiceClient>().createClientManager(new ClientPoolFactory.AsyncPipeConsensusServiceClientPoolFactory(this.config));
    }

    public IClientManager<TEndPoint, SyncPipeConsensusServiceClient> newSyncClientManager() {
        return new IClientManager.Factory<TEndPoint, SyncPipeConsensusServiceClient>().createClientManager(new ClientPoolFactory.SyncPipeConsensusServiceClientPoolFactory(this.config));
    }

    public static PipeConsensusClientMgrContainer getInstance() {
        return PipeConsensusClientMgrContainerHolder.INSTANCE;
    }

    public static void build() {
        PipeConsensusClientMgrContainerHolder.build();
    }

    private static class PipeConsensusClientMgrContainerHolder {
        private static PipeConsensusClientMgrContainer INSTANCE;

        private PipeConsensusClientMgrContainerHolder() {
        }

        public static void build() {
            if (INSTANCE == null) {
                INSTANCE = new PipeConsensusClientMgrContainer();
            }
        }
    }
}

