/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.testonly;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.testonly.ProcedureTestUtils;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestOnly
public class CreateManyDatabasesProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateManyDatabasesProcedure.class);
    public static final int INITIAL_STATE = 0;
    public static final int MAX_STATE = 100;
    public static final String DATABASE_NAME_PREFIX = "root.test_";
    public static final long SLEEP_FOREVER = Long.MAX_VALUE;
    private boolean createFailedOnce = false;
    private boolean isDeserialized = false;

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv configNodeProcedureEnv, Integer state) throws InterruptedException {
        if (state < 100) {
            if (state == 99 && !this.isDeserialized) {
                Thread.sleep(Long.MAX_VALUE);
            }
            try {
                this.createDatabase(configNodeProcedureEnv, state);
            }
            catch (ProcedureException e) {
                this.setFailure(e);
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            this.setNextState(state + 1);
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }
        return StateMachineProcedure.Flow.NO_MORE_STATE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createDatabase(ConfigNodeProcedureEnv env, int id) throws ProcedureException {
        String databaseName = DATABASE_NAME_PREFIX + id;
        TSStatus status = ProcedureTestUtils.createDatabase(env.getConfigManager(), databaseName);
        if (TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode() == status.getCode()) {
            if (this.createFailedOnce) throw new ProcedureException("createDatabase fail twice");
            this.createFailedOnce = true;
            return;
        } else {
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == status.getCode()) return;
            throw new ProcedureException("Unexpected fail, tsStatus is " + status);
        }
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv configNodeProcedureEnv, Integer integer) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected Integer getState(int stateId) {
        return stateId;
    }

    @Override
    protected int getStateId(Integer integer) {
        return integer;
    }

    @Override
    protected Integer getInitialState() {
        return 0;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.CREATE_MANY_DATABASES_PROCEDURE.getTypeCode());
        super.serialize(stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.isDeserialized = true;
    }
}

