/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.service;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.balancer.RouteBalancer;
import org.apache.iotdb.confignode.manager.load.cache.LoadCache;
import org.apache.iotdb.confignode.manager.load.cache.consensus.ConsensusGroupStatistics;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionGroupStatistics;
import org.apache.iotdb.confignode.manager.load.subscriber.ConsensusGroupStatisticsChangeEvent;
import org.apache.iotdb.confignode.manager.load.subscriber.NodeStatisticsChangeEvent;
import org.apache.iotdb.confignode.manager.load.subscriber.RegionGroupStatisticsChangeEvent;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventService.class);
    private static final long HEARTBEAT_INTERVAL = ConfigNodeDescriptor.getInstance().getConf().getHeartbeatIntervalInMs();
    private final Object eventServiceMonitor = new Object();
    private Future<?> currentEventServiceFuture;
    private final ScheduledExecutorService eventServiceExecutor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.CONFIG_NODE_EVENT_SERVICE.getName());
    private final LoadCache loadCache;
    private final Map<Integer, NodeStatistics> previousNodeStatisticsMap;
    private final Map<TConsensusGroupId, RegionGroupStatistics> previousRegionGroupStatisticsMap;
    private final Map<TConsensusGroupId, ConsensusGroupStatistics> previousConsensusGroupStatisticsMap;
    private final EventBus eventPublisher;

    public EventService(IManager configManager, LoadCache loadCache, RouteBalancer routeBalancer) {
        this.loadCache = loadCache;
        this.previousNodeStatisticsMap = new TreeMap<Integer, NodeStatistics>();
        this.previousRegionGroupStatisticsMap = new TreeMap<TConsensusGroupId, RegionGroupStatistics>();
        this.previousConsensusGroupStatisticsMap = new TreeMap<TConsensusGroupId, ConsensusGroupStatistics>();
        this.eventPublisher = new AsyncEventBus(ThreadName.CONFIG_NODE_LOAD_PUBLISHER.getName(), (Executor)IoTDBThreadPoolFactory.newFixedThreadPool((int)5, (String)ThreadName.CONFIG_NODE_LOAD_PUBLISHER.getName()));
        this.eventPublisher.register((Object)configManager.getPipeManager().getPipeRuntimeCoordinator());
        this.eventPublisher.register((Object)routeBalancer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEventService() {
        Object object = this.eventServiceMonitor;
        synchronized (object) {
            if (this.currentEventServiceFuture == null) {
                this.currentEventServiceFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.eventServiceExecutor, this::broadcastChangeEventIfNecessary, (long)0L, (long)HEARTBEAT_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
                LOGGER.info("Event service is started successfully.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEventService() {
        Object object = this.eventServiceMonitor;
        synchronized (object) {
            if (this.currentEventServiceFuture != null) {
                this.currentEventServiceFuture.cancel(false);
                this.currentEventServiceFuture = null;
                LOGGER.info("Event service is stopped successfully.");
            }
        }
    }

    private void broadcastChangeEventIfNecessary() {
        this.checkAndBroadcastNodeStatisticsChangeEventIfNecessary();
        this.checkAndBroadcastRegionGroupStatisticsChangeEventIfNecessary();
        this.checkAndBroadcastConsensusGroupStatisticsChangeEventIfNecessary();
    }

    public synchronized void checkAndBroadcastNodeStatisticsChangeEventIfNecessary() {
        Map<Integer, NodeStatistics> currentNodeStatisticsMap = this.loadCache.getCurrentNodeStatisticsMap();
        TreeMap<Integer, Pair<NodeStatistics, NodeStatistics>> differentNodeStatisticsMap = new TreeMap<Integer, Pair<NodeStatistics, NodeStatistics>>();
        currentNodeStatisticsMap.forEach((nodeId, currentNodeStatistics) -> {
            NodeStatistics previousNodeStatistics = this.previousNodeStatisticsMap.get(nodeId);
            if (previousNodeStatistics == null || currentNodeStatistics.isNewerThan(previousNodeStatistics) && !currentNodeStatistics.equals(previousNodeStatistics)) {
                differentNodeStatisticsMap.put((Integer)nodeId, (Pair<NodeStatistics, NodeStatistics>)new Pair((Object)previousNodeStatistics, currentNodeStatistics));
                this.previousNodeStatisticsMap.put((Integer)nodeId, (NodeStatistics)currentNodeStatistics);
            }
        });
        this.previousNodeStatisticsMap.forEach((nodeId, previousNodeStatistics) -> {
            if (!currentNodeStatisticsMap.containsKey(nodeId)) {
                differentNodeStatisticsMap.put((Integer)nodeId, (Pair<NodeStatistics, NodeStatistics>)new Pair(previousNodeStatistics, null));
            }
        });
        this.previousNodeStatisticsMap.keySet().retainAll(currentNodeStatisticsMap.keySet());
        if (!differentNodeStatisticsMap.isEmpty()) {
            this.eventPublisher.post((Object)new NodeStatisticsChangeEvent(differentNodeStatisticsMap));
            this.recordNodeStatistics(differentNodeStatisticsMap);
        }
    }

    private void recordNodeStatistics(Map<Integer, Pair<NodeStatistics, NodeStatistics>> differentNodeStatisticsMap) {
        LOGGER.info("[NodeStatistics] NodeStatisticsMap: ");
        for (Map.Entry<Integer, Pair<NodeStatistics, NodeStatistics>> nodeCacheEntry : differentNodeStatisticsMap.entrySet()) {
            LOGGER.info("[NodeStatistics]\t {}: {} -> {}", new Object[]{"nodeId{" + nodeCacheEntry.getKey() + "}", nodeCacheEntry.getValue().getLeft(), nodeCacheEntry.getValue().getRight()});
        }
    }

    public synchronized void checkAndBroadcastRegionGroupStatisticsChangeEventIfNecessary() {
        Map<TConsensusGroupId, RegionGroupStatistics> currentRegionGroupStatisticsMap = this.loadCache.getCurrentRegionGroupStatisticsMap();
        TreeMap<TConsensusGroupId, Pair<RegionGroupStatistics, RegionGroupStatistics>> differentRegionGroupStatisticsMap = new TreeMap<TConsensusGroupId, Pair<RegionGroupStatistics, RegionGroupStatistics>>();
        currentRegionGroupStatisticsMap.forEach((regionGroupId, currentRegionGroupStatistics) -> {
            RegionGroupStatistics previousRegionGroupStatistics = this.previousRegionGroupStatisticsMap.get(regionGroupId);
            if (previousRegionGroupStatistics == null || currentRegionGroupStatistics.isNewerThan(previousRegionGroupStatistics) && !currentRegionGroupStatistics.equals(previousRegionGroupStatistics)) {
                differentRegionGroupStatisticsMap.put((TConsensusGroupId)regionGroupId, (Pair<RegionGroupStatistics, RegionGroupStatistics>)new Pair((Object)previousRegionGroupStatistics, currentRegionGroupStatistics));
                this.previousRegionGroupStatisticsMap.put((TConsensusGroupId)regionGroupId, (RegionGroupStatistics)currentRegionGroupStatistics);
            }
        });
        this.previousRegionGroupStatisticsMap.forEach((regionGroupId, previousRegionGroupStatistics) -> {
            if (!currentRegionGroupStatisticsMap.containsKey(regionGroupId)) {
                differentRegionGroupStatisticsMap.put((TConsensusGroupId)regionGroupId, (Pair<RegionGroupStatistics, RegionGroupStatistics>)new Pair(previousRegionGroupStatistics, null));
            }
        });
        this.previousRegionGroupStatisticsMap.keySet().retainAll(currentRegionGroupStatisticsMap.keySet());
        if (!differentRegionGroupStatisticsMap.isEmpty()) {
            this.eventPublisher.post((Object)new RegionGroupStatisticsChangeEvent(differentRegionGroupStatisticsMap));
            this.recordRegionGroupStatistics(differentRegionGroupStatisticsMap);
        }
    }

    private void recordRegionGroupStatistics(Map<TConsensusGroupId, Pair<RegionGroupStatistics, RegionGroupStatistics>> differentRegionGroupStatisticsMap) {
        LOGGER.info("[RegionGroupStatistics] RegionGroupStatisticsMap: ");
        for (Map.Entry<TConsensusGroupId, Pair<RegionGroupStatistics, RegionGroupStatistics>> regionGroupStatisticsEntry : differentRegionGroupStatisticsMap.entrySet()) {
            RegionGroupStatistics previousStatistics = (RegionGroupStatistics)regionGroupStatisticsEntry.getValue().getLeft();
            RegionGroupStatistics currentStatistics = (RegionGroupStatistics)regionGroupStatisticsEntry.getValue().getRight();
            LOGGER.info("[RegionGroupStatistics]\t RegionGroup {}: {} -> {}", new Object[]{regionGroupStatisticsEntry.getKey(), previousStatistics == null ? null : previousStatistics.getRegionGroupStatus(), currentStatistics == null ? null : currentStatistics.getRegionGroupStatus()});
            List<Object> leftIds = previousStatistics == null ? Collections.emptyList() : previousStatistics.getRegionIds();
            List<Object> rightIds = currentStatistics == null ? Collections.emptyList() : currentStatistics.getRegionIds();
            for (Integer n : leftIds) {
                if (rightIds.contains(n)) {
                    LOGGER.info("[RegionGroupStatistics]\t Region in DataNode {}: {} -> {}", new Object[]{n, previousStatistics.getRegionStatus(n), currentStatistics.getRegionStatus(n)});
                    continue;
                }
                LOGGER.info("[RegionGroupStatistics]\t Region in DataNode {}: {} -> null", (Object)n, (Object)previousStatistics.getRegionStatus(n));
            }
            for (Integer n : rightIds) {
                if (leftIds.contains(n)) continue;
                LOGGER.info("[RegionGroupStatistics]\t Region in DataNode {}: null -> {}", (Object)n, (Object)currentStatistics.getRegionStatus(n));
            }
        }
    }

    public synchronized void checkAndBroadcastConsensusGroupStatisticsChangeEventIfNecessary() {
        Map<TConsensusGroupId, ConsensusGroupStatistics> currentConsensusGroupStatisticsMap = this.loadCache.getCurrentConsensusGroupStatisticsMap();
        TreeMap<TConsensusGroupId, Pair<ConsensusGroupStatistics, ConsensusGroupStatistics>> differentConsensusGroupStatisticsMap = new TreeMap<TConsensusGroupId, Pair<ConsensusGroupStatistics, ConsensusGroupStatistics>>();
        currentConsensusGroupStatisticsMap.forEach((consensusGroupId, currentConsensusGroupStatistics) -> {
            ConsensusGroupStatistics previousConsensusGroupStatistics = this.previousConsensusGroupStatisticsMap.get(consensusGroupId);
            if (previousConsensusGroupStatistics == null || currentConsensusGroupStatistics.isNewerThan(previousConsensusGroupStatistics) && !currentConsensusGroupStatistics.equals(previousConsensusGroupStatistics)) {
                differentConsensusGroupStatisticsMap.put((TConsensusGroupId)consensusGroupId, (Pair<ConsensusGroupStatistics, ConsensusGroupStatistics>)new Pair((Object)previousConsensusGroupStatistics, currentConsensusGroupStatistics));
                this.previousConsensusGroupStatisticsMap.put((TConsensusGroupId)consensusGroupId, (ConsensusGroupStatistics)currentConsensusGroupStatistics);
            }
        });
        this.previousConsensusGroupStatisticsMap.forEach((consensusGroupId, previousConsensusGroupStatistics) -> {
            if (!currentConsensusGroupStatisticsMap.containsKey(consensusGroupId)) {
                differentConsensusGroupStatisticsMap.put((TConsensusGroupId)consensusGroupId, (Pair<ConsensusGroupStatistics, ConsensusGroupStatistics>)new Pair(previousConsensusGroupStatistics, null));
            }
        });
        this.previousConsensusGroupStatisticsMap.keySet().retainAll(currentConsensusGroupStatisticsMap.keySet());
        if (!differentConsensusGroupStatisticsMap.isEmpty()) {
            this.eventPublisher.post((Object)new ConsensusGroupStatisticsChangeEvent(differentConsensusGroupStatisticsMap));
            this.recordConsensusGroupStatistics(differentConsensusGroupStatisticsMap);
        }
    }

    private void recordConsensusGroupStatistics(Map<TConsensusGroupId, Pair<ConsensusGroupStatistics, ConsensusGroupStatistics>> differentConsensusGroupStatisticsMap) {
        LOGGER.info("[ConsensusGroupStatistics] ConsensusGroupStatisticsMap: ");
        for (Map.Entry<TConsensusGroupId, Pair<ConsensusGroupStatistics, ConsensusGroupStatistics>> consensusGroupStatisticsEntry : differentConsensusGroupStatisticsMap.entrySet()) {
            if (Objects.equals(consensusGroupStatisticsEntry.getValue().getRight(), consensusGroupStatisticsEntry.getValue().getLeft())) continue;
            LOGGER.info("[ConsensusGroupStatistics]\t {}: {} -> {}", new Object[]{consensusGroupStatisticsEntry.getKey(), consensusGroupStatisticsEntry.getValue().getLeft(), consensusGroupStatisticsEntry.getValue().getRight()});
        }
    }

    @TestOnly
    public EventBus getEventPublisher() {
        return this.eventPublisher;
    }
}

