/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TGetDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowDatabaseResp;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.reporter.iotdb.IoTDBInternalReporter;
import org.apache.iotdb.metrics.utils.InternalReporterType;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.session.util.SessionUtils;
import org.apache.thrift.TException;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBInternalLocalReporter
extends IoTDBInternalReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBInternalLocalReporter.class);
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private final SessionInfo sessionInfo;
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;
    private Future<?> currentServiceFuture;
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();

    public IoTDBInternalLocalReporter() {
        this.partitionFetcher = ClusterPartitionFetcher.getInstance();
        this.schemaFetcher = ClusterSchemaFetcher.getInstance();
        this.sessionInfo = new SessionInfo(0L, AuthorityChecker.SUPER_USER, ZoneId.systemDefault());
        IClientManager<ConfigRegionId, ConfigNodeClient> configNodeClientManager = ConfigNodeClientManager.getInstance();
        try (ConfigNodeClient client = (ConfigNodeClient)configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetDatabaseReq req = new TGetDatabaseReq(Arrays.asList("root.__system".split("\\.")), SchemaConstant.ALL_MATCH_SCOPE_BINARY);
            TShowDatabaseResp showDatabaseResp = client.showDatabase(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == showDatabaseResp.getStatus().getCode() && showDatabaseResp.getDatabaseInfoMapSize() == 0) {
                TDatabaseSchema databaseSchema = new TDatabaseSchema();
                databaseSchema.setName("root.__system");
                databaseSchema.setIsTableModel(false);
                TSStatus tsStatus = client.setDatabase(databaseSchema);
                if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                    LOGGER.error("IoTDBSessionReporter checkOrCreateDatabase failed.");
                }
            }
        }
        catch (ClientManagerException | TException e) {
            LOGGER.warn("IoTDBSessionReporter checkOrCreateDatabase failed because ", e);
        }
    }

    public InternalReporterType getType() {
        return InternalReporterType.IOTDB;
    }

    public boolean start() {
        if (this.currentServiceFuture != null) {
            LOGGER.warn("IoTDB Internal Reporter already start");
            return false;
        }
        this.currentServiceFuture = ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.service, () -> this.writeMetricToIoTDB(this.autoGauges), (long)1L, (long)MetricConfigDescriptor.getInstance().getMetricConfig().getAsyncCollectPeriodInSecond().intValue(), (TimeUnit)TimeUnit.SECONDS);
        LOGGER.info("IoTDBInternalReporter start!");
        return true;
    }

    public boolean stop() {
        if (this.currentServiceFuture != null) {
            this.currentServiceFuture.cancel(true);
            this.currentServiceFuture = null;
        }
        this.clear();
        LOGGER.info("IoTDBInternalReporter stop!");
        return true;
    }

    public ReporterType getReporterType() {
        return ReporterType.IOTDB;
    }

    protected void writeMetricToIoTDB(Map<String, Object> valueMap, String prefix, long time) {
        this.service.execute(() -> {
            try {
                TSStatus result = this.insertRecord(valueMap, prefix, time);
                if (result.getCode() == TSStatusCode.METADATA_ERROR.getStatusCode()) {
                    this.createTimeSeries(valueMap, prefix);
                    result = this.insertRecord(valueMap, prefix, time);
                }
                if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    LOGGER.warn("Failed to update the value of metric with status {}", (Object)result);
                }
            }
            catch (IoTDBConnectionException e1) {
                LOGGER.warn("Failed to update the value of metric because of connection failure, because ", (Throwable)e1);
            }
            catch (IllegalPathException | QueryProcessException e2) {
                LOGGER.warn("Failed to update the value of metric because of internal error, because ", (Throwable)e2);
            }
        });
    }

    private TSStatus insertRecord(Map<String, Object> valueMap, String prefix, long time) throws IoTDBConnectionException, QueryProcessException, IllegalPathException {
        TSInsertRecordReq request = new TSInsertRecordReq();
        ArrayList<String> measurements = new ArrayList<String>();
        ArrayList<TSDataType> types = new ArrayList<TSDataType>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            String measurement = entry.getKey();
            Object value = entry.getValue();
            measurements.add(measurement);
            types.add(this.inferType(value));
            values.add(value);
        }
        ByteBuffer buffer = SessionUtils.getValueBuffer(types, values);
        request.setPrefixPath(prefix);
        request.setTimestamp(time);
        request.setMeasurements(measurements);
        request.setValues(buffer);
        request.setIsAligned(false);
        InsertRowStatement s = StatementGenerator.createStatement(request);
        long queryId = SESSION_MANAGER.requestQueryId();
        ExecutionResult result = COORDINATOR.executeForTreeModel(s, queryId, this.sessionInfo, "", this.partitionFetcher, this.schemaFetcher);
        return result.status;
    }

    private void createTimeSeries(Map<String, Object> valueMap, String prefix) throws IllegalPathException {
        TSCreateMultiTimeseriesReq request = new TSCreateMultiTimeseriesReq();
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Integer> encodings = new ArrayList<Integer>();
        ArrayList<Integer> compressors = new ArrayList<Integer>();
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            String measurement = entry.getKey();
            paths.add(prefix + "." + measurement);
            TSDataType type = this.inferType(entry.getValue());
            types.add(type.ordinal());
            encodings.add(Integer.valueOf(EncodingInferenceUtils.getDefaultEncoding(type).serialize()));
            compressors.add(Integer.valueOf(TSFileDescriptor.getInstance().getConfig().getCompressor().serialize()));
        }
        request.setPaths(paths);
        request.setDataTypes(types);
        request.setEncodings(encodings);
        request.setCompressors(compressors);
        CreateMultiTimeSeriesStatement s = StatementGenerator.createStatement(request);
        long queryId = SESSION_MANAGER.requestQueryId();
        ExecutionResult result = COORDINATOR.executeForTreeModel(s, queryId, this.sessionInfo, "", this.partitionFetcher, this.schemaFetcher);
        if (result.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to auto create timeseries for {} with status {}", paths, (Object)result.status);
        }
    }

    protected void writeMetricsToIoTDB(Map<String, Map<String, Object>> valueMap, long time) {
        for (Map.Entry<String, Map<String, Object>> value : valueMap.entrySet()) {
            this.writeMetricToIoTDB(value.getValue(), value.getKey(), time);
        }
    }
}

