/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class Property
extends Node {
    private final Identifier name;
    @Nullable
    private final Expression value;

    public Property(@Nonnull Identifier name) {
        super(null);
        this.name = Objects.requireNonNull(name, "name is null");
        this.value = null;
    }

    public Property(@Nonnull NodeLocation location, @Nonnull Identifier name) {
        super(Objects.requireNonNull(location, "location is null"));
        this.name = Objects.requireNonNull(name, "name is null");
        this.value = null;
    }

    public Property(@Nonnull Identifier name, @Nonnull Expression value) {
        super(null);
        this.name = Objects.requireNonNull(name, "name is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public Property(@Nonnull NodeLocation location, @Nonnull Identifier name, @Nullable Expression value) {
        super(Objects.requireNonNull(location, "location is null"));
        this.name = Objects.requireNonNull(name, "name is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public boolean isSetToDefault() {
        return this.value == null;
    }

    public Expression getNonDefaultValue() {
        Preconditions.checkState((!this.isSetToDefault() ? 1 : 0) != 0, (String)"Cannot get non-default value of property %s since its value is set to DEFAULT", (Object)this.name);
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitProperty(this, context);
    }

    public List<Node> getChildren() {
        return this.isSetToDefault() ? ImmutableList.of((Object)this.name) : ImmutableList.of((Object)this.name, (Object)this.getNonDefaultValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", this.isSetToDefault() ? "DEFAULT" : this.getNonDefaultValue()).toString();
    }
}

