/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.RelationType;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Scope;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.TranslationMap;

public class RelationPlan {
    private final PlanNode root;
    private final Scope scope;
    private final List<Symbol> fieldMappings;
    private final Optional<TranslationMap> outerContext;

    public RelationPlan(PlanNode root, Scope scope, List<Symbol> fieldMappings, Optional<TranslationMap> outerContext) {
        Objects.requireNonNull(root, "root is null");
        Objects.requireNonNull(fieldMappings, "fieldMappings is null");
        Objects.requireNonNull(scope, "scope is null");
        int allFieldCount = scope.getLocalScopeFieldCount();
        this.root = root;
        this.scope = scope;
        this.fieldMappings = ImmutableList.copyOf(fieldMappings);
        this.outerContext = outerContext;
    }

    public Symbol getSymbol(int fieldIndex) {
        Preconditions.checkArgument((fieldIndex >= 0 && fieldIndex < this.fieldMappings.size() ? 1 : 0) != 0, (String)"No field->symbol mapping for field %s", (int)fieldIndex);
        return this.fieldMappings.get(fieldIndex);
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public List<Symbol> getFieldMappings() {
        return this.fieldMappings;
    }

    public RelationType getDescriptor() {
        return this.scope.getRelationType();
    }

    public Scope getScope() {
        return this.scope;
    }

    public Optional<TranslationMap> getOuterContext() {
        return this.outerContext;
    }
}

