/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.function;

import java.util.Locale;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.function.Signature;

public class FunctionId {
    private final String id;

    public FunctionId(String id) {
        Objects.requireNonNull(id, "id is null");
        if (id.isEmpty()) {
            throw new IllegalArgumentException("id must not be empty");
        }
        if (!id.toLowerCase(Locale.US).equals(id)) {
            throw new IllegalArgumentException("id must be lowercase");
        }
        if (id.contains("@")) {
            throw new IllegalArgumentException("id must not contain '@'");
        }
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionId that = (FunctionId)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    public static FunctionId toFunctionId(String canonicalName, Signature signature) {
        return new FunctionId((canonicalName + signature).toLowerCase(Locale.US));
    }
}

