/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.exception.runtime.SerializationRunTimeException;
import org.apache.iotdb.commons.partition.ExecutorType;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.TimePredicate;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeUtil;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstance
implements IConsensusRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentInstance.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final FragmentInstanceId id;
    private final QueryType type;
    private final PlanFragment fragment;
    private ExecutorType executorType;
    private TDataNodeLocation hostDataNode;
    private final TimePredicate globalTimePredicate;
    private final long timeOut;
    private boolean isRoot;
    private final SessionInfo sessionInfo;
    private int dataNodeFINum;
    private boolean isHighestPriority;
    private transient int nextRetryIndex = 0;
    private boolean isExplainAnalyze = false;

    public FragmentInstance(PlanFragment fragment, FragmentInstanceId id, TimePredicate globalTimePredicate, QueryType type, long timeOut, SessionInfo sessionInfo) {
        this.fragment = fragment;
        this.globalTimePredicate = globalTimePredicate;
        this.id = id;
        this.type = type;
        this.timeOut = timeOut > 0L ? timeOut : CONFIG.getQueryTimeoutThreshold();
        this.isRoot = false;
        this.sessionInfo = sessionInfo;
    }

    public FragmentInstance(PlanFragment fragment, FragmentInstanceId id, TimePredicate globalTimePredicate, QueryType type, long timeOut, SessionInfo sessionInfo, boolean isExplainAnalyze, boolean isRoot) {
        this(fragment, id, globalTimePredicate, type, timeOut, sessionInfo);
        this.isRoot = isRoot;
        this.isExplainAnalyze = isExplainAnalyze;
    }

    public FragmentInstance(PlanFragment fragment, FragmentInstanceId id, QueryType type, long timeOut, SessionInfo sessionInfo, boolean isExplainAnalyze, boolean isRoot) {
        this(fragment, id, null, type, timeOut, sessionInfo);
        this.isRoot = isRoot;
        this.isExplainAnalyze = isExplainAnalyze;
    }

    public FragmentInstance(PlanFragment fragment, FragmentInstanceId id, TimePredicate globalTimePredicate, QueryType type, long timeOut, SessionInfo sessionInfo, int dataNodeFINum) {
        this(fragment, id, globalTimePredicate, type, timeOut, sessionInfo);
        this.dataNodeFINum = dataNodeFINum;
    }

    public void setExecutorAndHost(ExecutorType executorType) {
        if (executorType == null) {
            return;
        }
        this.executorType = executorType;
        this.hostDataNode = executorType.getDataNodeLocation();
    }

    public void setHostDataNode(TDataNodeLocation hostDataNode) {
        this.hostDataNode = hostDataNode;
    }

    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    @TestOnly
    public void setExecutorType(ExecutorType executorType) {
        this.executorType = executorType;
    }

    public TRegionReplicaSet getRegionReplicaSet() {
        return this.executorType.getRegionReplicaSet();
    }

    public PlanFragment getFragment() {
        return this.fragment;
    }

    public FragmentInstanceId getId() {
        return this.id;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isHighestPriority() {
        return this.isHighestPriority;
    }

    public void setHighestPriority(boolean highestPriority) {
        this.isHighestPriority = highestPriority;
    }

    public TimePredicate getGlobalTimePredicate() {
        return this.globalTimePredicate;
    }

    public QueryType getType() {
        return this.type;
    }

    public int getDataNodeFINum() {
        return this.dataNodeFINum;
    }

    public void setDataNodeFINum(int dataNodeFINum) {
        this.dataNodeFINum = dataNodeFINum;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(String.format("FragmentInstance-%s:", this.getId()));
        ret.append(String.format("Host: %s ", this.getHostDataNode() == null ? "Not set" : this.getHostDataNode().dataNodeId + " - " + this.getHostDataNode().internalEndPoint));
        ret.append(String.format("Region: %s ", this.getRegionReplicaSet() == null ? "Not set" : this.getRegionReplicaSet().getRegionId()));
        ret.append("\n---- Plan Node Tree ----\n");
        ret.append(PlanNodeUtil.nodeToString(this.getFragment().getPlanNodeTree()));
        ret.append(String.format("timeOut-%s:", this.getTimeOut()));
        return ret.toString();
    }

    public static FragmentInstance deserializeFrom(ByteBuffer buffer) {
        FragmentInstanceId id = FragmentInstanceId.deserialize(buffer);
        PlanFragment planFragment = PlanFragment.deserialize(buffer);
        long timeOut = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        boolean hasSessionInfo = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        SessionInfo sessionInfo = hasSessionInfo ? SessionInfo.deserializeFrom(buffer) : null;
        boolean hasTimePredicate = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        TimePredicate globalTimePredicate = hasTimePredicate ? TimePredicate.deserialize(buffer) : null;
        QueryType queryType = QueryType.values()[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
        int dataNodeFINum = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        FragmentInstance fragmentInstance = new FragmentInstance(planFragment, id, globalTimePredicate, queryType, timeOut, sessionInfo, dataNodeFINum);
        boolean hasHostDataNode = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        fragmentInstance.hostDataNode = hasHostDataNode ? ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)buffer) : null;
        fragmentInstance.isExplainAnalyze = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        return fragmentInstance;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer serializeToByteBuffer() {
        try (PublicBAOS publicBAOS = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)publicBAOS);){
                this.id.serialize(outputStream);
                this.fragment.serialize(outputStream);
                ReadWriteIOUtils.write((long)this.timeOut, (OutputStream)outputStream);
                ReadWriteIOUtils.write((Boolean)(this.sessionInfo != null ? 1 : 0), (OutputStream)outputStream);
                if (this.sessionInfo != null) {
                    this.sessionInfo.serialize(outputStream);
                }
                ReadWriteIOUtils.write((Boolean)(this.globalTimePredicate != null ? 1 : 0), (OutputStream)outputStream);
                if (this.globalTimePredicate != null) {
                    this.globalTimePredicate.serialize(outputStream);
                }
                ReadWriteIOUtils.write((int)this.type.ordinal(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((int)this.dataNodeFINum, (OutputStream)outputStream);
                ReadWriteIOUtils.write((Boolean)(this.hostDataNode != null ? 1 : 0), (OutputStream)outputStream);
                if (this.hostDataNode != null) {
                    ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.hostDataNode, (DataOutputStream)outputStream);
                }
                ReadWriteIOUtils.write((Boolean)this.isExplainAnalyze, (OutputStream)outputStream);
                byteBuffer = ByteBuffer.wrap(publicBAOS.getBuf(), 0, publicBAOS.size());
            }
            return byteBuffer;
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error occurs when serializing this FragmentInstance.", (Throwable)e);
            throw new SerializationRunTimeException((Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentInstance instance = (FragmentInstance)o;
        return Objects.equals(this.id, instance.id) && this.type == instance.type && Objects.equals(this.fragment, instance.fragment) && Objects.equals(this.executorType, instance.executorType) && Objects.equals(this.hostDataNode, instance.hostDataNode) && Objects.equals(this.globalTimePredicate, instance.globalTimePredicate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.fragment, this.executorType, this.hostDataNode, this.globalTimePredicate});
    }

    public TDataNodeLocation getHostDataNode() {
        return this.hostDataNode;
    }

    public TDataNodeLocation getNextRetriedHostDataNode() {
        this.nextRetryIndex = (this.nextRetryIndex + 1) % this.executorType.getRegionReplicaSet().getDataNodeLocations().size();
        this.hostDataNode = (TDataNodeLocation)this.executorType.getRegionReplicaSet().getDataNodeLocations().get(this.nextRetryIndex);
        return this.hostDataNode;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public boolean isExplainAnalyze() {
        return this.isExplainAnalyze;
    }
}

