/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.MeasurementGroup;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalBatchActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.AlterSchemaTemplateStatement;
import org.apache.iotdb.db.schemaengine.template.ITemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.TemplateAlterOperationType;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateExtendInfo;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

class AutoCreateSchemaExecutor {
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Coordinator coordinator;
    private final ITemplateManager templateManager;
    private final ISchemaFetcher schemaFetcher;

    AutoCreateSchemaExecutor(Coordinator coordinator, ITemplateManager templateManager, ISchemaFetcher schemaFetcher) {
        this.coordinator = coordinator;
        this.templateManager = templateManager;
        this.schemaFetcher = schemaFetcher;
    }

    private ExecutionResult executeStatement(Statement statement, MPPQueryContext context) {
        return this.coordinator.executeForTreeModel(statement, SessionManager.getInstance().requestQueryId(), context == null ? null : context.getSession(), "", ClusterPartitionFetcher.getInstance(), this.schemaFetcher, Long.MAX_VALUE, false);
    }

    void autoCreateTimeSeries(ClusterSchemaTree schemaTree, PartialPath devicePath, List<Integer> indexOfTargetMeasurements, String[] measurements, IntFunction<TSDataType> getDataType, boolean isAligned, MPPQueryContext context) {
        ArrayList<String> missingMeasurements = new ArrayList<String>(indexOfTargetMeasurements.size());
        ArrayList<TSDataType> dataTypesOfMissingMeasurement = new ArrayList<TSDataType>(indexOfTargetMeasurements.size());
        ArrayList<TSEncoding> encodingsOfMissingMeasurement = new ArrayList<TSEncoding>(indexOfTargetMeasurements.size());
        ArrayList<CompressionType> compressionTypesOfMissingMeasurement = new ArrayList<CompressionType>(indexOfTargetMeasurements.size());
        indexOfTargetMeasurements.forEach(index -> {
            TSDataType tsDataType = (TSDataType)getDataType.apply((int)index);
            if (tsDataType != null) {
                missingMeasurements.add(measurements[index]);
                dataTypesOfMissingMeasurement.add(tsDataType);
                encodingsOfMissingMeasurement.add(EncodingInferenceUtils.getDefaultEncoding(tsDataType));
                compressionTypesOfMissingMeasurement.add(TSFileDescriptor.getInstance().getConfig().getCompressor());
            }
        });
        if (!missingMeasurements.isEmpty()) {
            this.internalCreateTimeSeries(schemaTree, devicePath, missingMeasurements, dataTypesOfMissingMeasurement, encodingsOfMissingMeasurement, compressionTypesOfMissingMeasurement, isAligned, context);
        }
    }

    void autoCreateTimeSeries(ClusterSchemaTree schemaTree, List<PartialPath> devicePathList, List<Integer> indexOfTargetDevices, List<List<Integer>> indexOfTargetMeasurementsList, List<String[]> measurementsList, List<TSDataType[]> tsDataTypesList, List<Boolean> isAlignedList, MPPQueryContext context) {
        HashMap<PartialPath, Pair<Boolean, MeasurementGroup>> devicesNeedAutoCreateTimeSeries = new HashMap<PartialPath, Pair<Boolean, MeasurementGroup>>();
        int size = indexOfTargetDevices.size();
        for (int i = 0; i < size; ++i) {
            int deviceIndex = indexOfTargetDevices.get(i);
            PartialPath devicePath = devicePathList.get(deviceIndex);
            List<Integer> indexOfTargetMeasurements = indexOfTargetMeasurementsList.get(i);
            int finalDeviceIndex = deviceIndex;
            List<Integer> finalIndexOfMeasurementsNotInTemplate = indexOfTargetMeasurements;
            devicesNeedAutoCreateTimeSeries.compute(devicePath, (k, v) -> {
                if (v == null) {
                    v = new Pair((Object)((Boolean)isAlignedList.get(finalDeviceIndex)), (Object)new MeasurementGroup());
                }
                MeasurementGroup measurementGroup = (MeasurementGroup)v.right;
                String[] measurements = (String[])measurementsList.get(finalDeviceIndex);
                TSDataType[] tsDataTypes = (TSDataType[])tsDataTypesList.get(finalDeviceIndex);
                Iterator iterator = finalIndexOfMeasurementsNotInTemplate.iterator();
                while (iterator.hasNext()) {
                    int measurementIndex = (Integer)iterator.next();
                    if (tsDataTypes[measurementIndex] == null) continue;
                    measurementGroup.addMeasurement(measurements[measurementIndex], tsDataTypes[measurementIndex], EncodingInferenceUtils.getDefaultEncoding(tsDataTypes[measurementIndex]), TSFileDescriptor.getInstance().getConfig().getCompressor());
                }
                return v;
            });
        }
        if (!devicesNeedAutoCreateTimeSeries.isEmpty()) {
            this.internalCreateTimeSeries(schemaTree, devicesNeedAutoCreateTimeSeries, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoExtendTemplate(String templateName, List<String> measurementList, List<TSDataType> dataTypeList, MPPQueryContext context) {
        long startTime = System.nanoTime();
        try {
            TSStatus status;
            String userName = context.getSession().getUserName();
            if (!AuthorityChecker.SUPER_USER.equals(userName) && (status = AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.EXTEND_TEMPLATE), PrivilegeType.EXTEND_TEMPLATE)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new IoTDBRuntimeException(status.getMessage(), status.getCode());
            }
        }
        finally {
            PerformanceOverviewMetrics.getInstance().recordAuthCost(System.nanoTime() - startTime);
        }
        this.internalExtendTemplate(templateName, measurementList, dataTypeList, null, null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoExtendTemplate(Map<String, TemplateExtendInfo> templateExtendInfoMap, MPPQueryContext context) {
        long startTime = System.nanoTime();
        try {
            TSStatus status;
            String userName = context.getSession().getUserName();
            if (!AuthorityChecker.SUPER_USER.equals(userName) && (status = AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.EXTEND_TEMPLATE), PrivilegeType.EXTEND_TEMPLATE)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new IoTDBRuntimeException(status.getMessage(), status.getCode());
            }
        }
        finally {
            PerformanceOverviewMetrics.getInstance().recordAuthCost(System.nanoTime() - startTime);
        }
        for (Map.Entry<String, TemplateExtendInfo> entry : templateExtendInfoMap.entrySet()) {
            TemplateExtendInfo templateExtendInfo = entry.getValue().deduplicate();
            this.internalExtendTemplate(entry.getKey(), templateExtendInfo.getMeasurements(), templateExtendInfo.getDataTypes(), templateExtendInfo.getEncodings(), templateExtendInfo.getCompressors(), context);
        }
    }

    void autoActivateTemplate(ClusterSchemaTree schemaTree, PartialPath devicePath, int templateId, MPPQueryContext context) {
        this.internalActivateTemplate(devicePath, context);
        Template template = this.templateManager.getTemplate(templateId);
        schemaTree.appendTemplateDevice(devicePath, template.isDirectAligned(), templateId, template);
    }

    void autoActivateTemplate(ClusterSchemaTree schemaTree, List<PartialPath> deviceList, List<Pair<Template, PartialPath>> templateSetInfoList, MPPQueryContext context) {
        HashMap<PartialPath, Pair<Template, PartialPath>> devicesNeedActivateTemplate = new HashMap<PartialPath, Pair<Template, PartialPath>>();
        for (int i = 0; i < deviceList.size(); ++i) {
            devicesNeedActivateTemplate.put(deviceList.get(i), (Pair<Template, PartialPath>)new Pair((Object)this.templateManager.getTemplate(((Template)templateSetInfoList.get((int)i).left).getId()), (Object)((PartialPath)templateSetInfoList.get((int)i).right)));
        }
        this.internalActivateTemplate(devicesNeedActivateTemplate, context);
        for (Map.Entry entry : devicesNeedActivateTemplate.entrySet()) {
            PartialPath devicePath = (PartialPath)entry.getKey();
            Template template = this.templateManager.getTemplate(((Template)((Pair)entry.getValue()).left).getId());
            schemaTree.appendTemplateDevice(devicePath, template.isDirectAligned(), template.getId(), template);
        }
    }

    void autoCreateMissingMeasurements(ClusterSchemaTree schemaTree, List<PartialPath> devicePathList, List<Integer> indexOfTargetDevices, List<List<Integer>> indexOfTargetMeasurementsList, List<String[]> measurementsList, List<TSDataType[]> tsDataTypesList, List<TSEncoding[]> encodingsList, List<CompressionType[]> compressionTypesList, List<Boolean> isAlignedList, MPPQueryContext context) {
        Template template;
        PartialPath devicePath;
        HashMap<PartialPath, Pair<Template, PartialPath>> devicesNeedActivateTemplate = new HashMap<PartialPath, Pair<Template, PartialPath>>();
        HashMap<PartialPath, Pair<Boolean, MeasurementGroup>> devicesNeedAutoCreateTimeSeries = new HashMap<PartialPath, Pair<Boolean, MeasurementGroup>>();
        HashMap<String, TemplateExtendInfo> templateExtendInfoMap = new HashMap<String, TemplateExtendInfo>();
        int size = indexOfTargetDevices.size();
        for (int i = 0; i < size; ++i) {
            int deviceIndex = indexOfTargetDevices.get(i);
            devicePath = devicePathList.get(deviceIndex);
            List<Integer> indexOfTargetMeasurements = indexOfTargetMeasurementsList.get(i);
            Pair<Template, PartialPath> templateInfo = (Pair<Template, PartialPath>)devicesNeedActivateTemplate.get(devicePath);
            if (templateInfo == null) {
                templateInfo = this.templateManager.checkTemplateSetInfo(devicePath);
            }
            if (templateInfo == null) {
                int finalDeviceIndex = deviceIndex;
                List<Integer> finalIndexOfMeasurementsNotInTemplate = indexOfTargetMeasurements;
                devicesNeedAutoCreateTimeSeries.compute(devicePath, (k, v) -> {
                    if (v == null) {
                        v = new Pair((Object)((Boolean)isAlignedList.get(finalDeviceIndex)), (Object)new MeasurementGroup());
                    }
                    MeasurementGroup measurementGroup = (MeasurementGroup)v.right;
                    String[] measurements = (String[])measurementsList.get(finalDeviceIndex);
                    TSDataType[] tsDataTypes = (TSDataType[])tsDataTypesList.get(finalDeviceIndex);
                    TSEncoding[] encodings = encodingsList == null ? null : (TSEncoding[])encodingsList.get(finalDeviceIndex);
                    CompressionType[] compressionTypes = compressionTypesList == null ? null : (CompressionType[])compressionTypesList.get(finalDeviceIndex);
                    Iterator iterator = finalIndexOfMeasurementsNotInTemplate.iterator();
                    while (iterator.hasNext()) {
                        int measurementIndex = (Integer)iterator.next();
                        if (tsDataTypes[measurementIndex] == null) continue;
                        measurementGroup.addMeasurement(measurements[measurementIndex], tsDataTypes[measurementIndex], encodings == null ? EncodingInferenceUtils.getDefaultEncoding(tsDataTypes[measurementIndex]) : encodings[measurementIndex], compressionTypes == null ? TSFileDescriptor.getInstance().getConfig().getCompressor() : compressionTypes[measurementIndex]);
                    }
                    return v;
                });
                continue;
            }
            template = (Template)templateInfo.left;
            List<Integer> indexOfMeasurementsNotInTemplate = this.checkMeasurementsInSchemaTemplate(indexOfTargetMeasurements, measurementsList.get(deviceIndex), template);
            if (schemaTree.getMatchedDevices(devicePath).isEmpty()) {
                devicesNeedActivateTemplate.putIfAbsent(devicePath, templateInfo);
            }
            if (indexOfMeasurementsNotInTemplate.isEmpty()) continue;
            List<Integer> finalIndexOfMeasurementsNotInTemplate1 = indexOfMeasurementsNotInTemplate;
            int finalDeviceIndex1 = deviceIndex;
            templateExtendInfoMap.compute(template.getName(), (k, v) -> {
                TemplateExtendInfo templateExtendInfo = v == null ? new TemplateExtendInfo((String)k) : v;
                Iterator iterator = finalIndexOfMeasurementsNotInTemplate1.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    String measurement = ((String[])measurementsList.get(finalDeviceIndex1))[index];
                    TSDataType dataType = ((TSDataType[])tsDataTypesList.get(finalDeviceIndex1))[index];
                    TSEncoding encoding = encodingsList != null && encodingsList.get(finalDeviceIndex1) != null ? ((TSEncoding[])encodingsList.get(finalDeviceIndex1))[index] : EncodingInferenceUtils.getDefaultEncoding(dataType);
                    CompressionType compressionType = compressionTypesList != null && compressionTypesList.get(finalDeviceIndex1) != null ? ((CompressionType[])compressionTypesList.get(finalDeviceIndex1))[index] : TSFileDescriptor.getInstance().getConfig().getCompressor();
                    templateExtendInfo.addMeasurement(measurement, dataType, encoding, compressionType);
                }
                return templateExtendInfo;
            });
        }
        if (!templateExtendInfoMap.isEmpty()) {
            for (Map.Entry entry : templateExtendInfoMap.entrySet()) {
                TemplateExtendInfo templateExtendInfo = ((TemplateExtendInfo)entry.getValue()).deduplicate();
                this.internalExtendTemplate((String)entry.getKey(), templateExtendInfo.getMeasurements(), templateExtendInfo.getDataTypes(), templateExtendInfo.getEncodings(), templateExtendInfo.getCompressors(), context);
            }
            for (Pair value : devicesNeedActivateTemplate.values()) {
                value.left = this.templateManager.getTemplate(((Template)value.left).getId());
            }
        }
        if (!devicesNeedActivateTemplate.isEmpty()) {
            this.internalActivateTemplate(devicesNeedActivateTemplate, context);
            for (Map.Entry entry : devicesNeedActivateTemplate.entrySet()) {
                devicePath = (PartialPath)entry.getKey();
                template = this.templateManager.getTemplate(((Template)((Pair)entry.getValue()).left).getId());
                schemaTree.appendTemplateDevice(devicePath, template.isDirectAligned(), template.getId(), template);
            }
        }
        if (!devicesNeedAutoCreateTimeSeries.isEmpty()) {
            this.internalCreateTimeSeries(schemaTree, devicesNeedAutoCreateTimeSeries, context);
        }
    }

    private List<Integer> checkMeasurementsInSchemaTemplate(List<Integer> indexOfTargetMeasurements, String[] measurements, Template template) {
        boolean shouldActivateTemplate = false;
        for (int index : indexOfTargetMeasurements) {
            if (!template.hasSchema(measurements[index])) continue;
            shouldActivateTemplate = true;
            break;
        }
        if (shouldActivateTemplate) {
            ArrayList<Integer> recheckedIndexOfMissingMeasurements = new ArrayList<Integer>();
            for (int index : indexOfTargetMeasurements) {
                if (template.hasSchema(measurements[index])) continue;
                recheckedIndexOfMissingMeasurements.add(index);
            }
            return recheckedIndexOfMissingMeasurements;
        }
        return indexOfTargetMeasurements;
    }

    private void internalCreateTimeSeries(ClusterSchemaTree schemaTree, PartialPath devicePath, List<String> measurements, List<TSDataType> tsDataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, boolean isAligned, MPPQueryContext context) {
        List<MeasurementPath> measurementPathList = this.executeInternalCreateTimeseriesStatement(new InternalCreateTimeSeriesStatement(devicePath, measurements, tsDataTypes, encodings, compressors, isAligned), context);
        Set alreadyExistingMeasurementIndexSet = measurementPathList.stream().map(o -> measurements.indexOf(o.getMeasurement())).collect(Collectors.toSet());
        schemaTree.appendMeasurementPaths(measurementPathList);
        int size = measurements.size();
        for (int i = 0; i < size; ++i) {
            if (alreadyExistingMeasurementIndexSet.contains(i)) continue;
            schemaTree.appendSingleMeasurement((PartialPath)devicePath.concatAsMeasurementPath(measurements.get(i)), (IMeasurementSchema)new MeasurementSchema(measurements.get(i), tsDataTypes.get(i), encodings.get(i), compressors.get(i)), null, null, null, isAligned);
        }
    }

    private List<MeasurementPath> executeInternalCreateTimeseriesStatement(Statement statement, MPPQueryContext context) {
        TSStatus status = AuthorityChecker.checkAuthority(statement, context.getSession().getUserName());
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new IoTDBRuntimeException(status.getMessage(), status.getCode());
        }
        ExecutionResult executionResult = this.executeStatement(statement, context);
        int statusCode = executionResult.status.getCode();
        if (statusCode == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return Collections.emptyList();
        }
        if (statusCode != TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            throw new IoTDBRuntimeException(executionResult.status.getMessage(), statusCode);
        }
        HashSet<TSStatus> failedCreationSet = new HashSet<TSStatus>();
        ArrayList<MeasurementPath> alreadyExistingMeasurements = new ArrayList<MeasurementPath>();
        for (TSStatus subStatus : executionResult.status.subStatus) {
            if (subStatus.code == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) {
                alreadyExistingMeasurements.add(MeasurementPath.parseDataFromString((String)subStatus.getMessage()));
                continue;
            }
            failedCreationSet.add(subStatus);
        }
        if (!failedCreationSet.isEmpty()) {
            throw new SemanticException(new MetadataException(failedCreationSet.stream().map(TSStatus::toString).collect(Collectors.joining("; "))));
        }
        return alreadyExistingMeasurements;
    }

    private void internalActivateTemplate(PartialPath devicePath, MPPQueryContext context) {
        ActivateTemplateStatement statement = new ActivateTemplateStatement(devicePath);
        TSStatus status = AuthorityChecker.checkAuthority((Statement)statement, context.getSession().getUserName());
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new IoTDBRuntimeException(status.getMessage(), status.getCode());
        }
        ExecutionResult executionResult = this.executeStatement(statement, context);
        status = executionResult.status;
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.TEMPLATE_IS_IN_USE.getStatusCode()) {
            throw new SemanticException(new IoTDBException(status.getMessage(), status.getCode()));
        }
    }

    private void internalActivateTemplate(Map<PartialPath, Pair<Template, PartialPath>> devicesNeedActivateTemplate, MPPQueryContext context) {
        InternalBatchActivateTemplateStatement statement = new InternalBatchActivateTemplateStatement(devicesNeedActivateTemplate);
        TSStatus status = AuthorityChecker.checkAuthority((Statement)statement, context.getSession().getUserName());
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new IoTDBRuntimeException(status.getMessage(), status.getCode());
        }
        ExecutionResult executionResult = this.executeStatement(statement, context);
        status = executionResult.status;
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || status.getCode() == TSStatusCode.TEMPLATE_IS_IN_USE.getStatusCode()) {
            return;
        }
        if (status.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            HashSet<String> failedActivationSet = new HashSet<String>();
            for (TSStatus subStatus : status.subStatus) {
                if (subStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || subStatus.getCode() == TSStatusCode.TEMPLATE_IS_IN_USE.getStatusCode()) continue;
                failedActivationSet.add(subStatus.message);
            }
            if (!failedActivationSet.isEmpty()) {
                throw new SemanticException(new MetadataException(String.join((CharSequence)"; ", failedActivationSet)));
            }
        } else {
            throw new SemanticException(new IoTDBException(status.getMessage(), status.getCode()));
        }
    }

    private void internalCreateTimeSeries(ClusterSchemaTree schemaTree, Map<PartialPath, Pair<Boolean, MeasurementGroup>> devicesNeedAutoCreateTimeSeries, MPPQueryContext context) {
        List<MeasurementPath> measurementPathList = this.executeInternalCreateTimeseriesStatement(new InternalCreateMultiTimeSeriesStatement(devicesNeedAutoCreateTimeSeries), context);
        schemaTree.appendMeasurementPaths(measurementPathList);
        HashMap<PartialPath, Set> alreadyExistingMeasurementMap = new HashMap<PartialPath, Set>();
        for (MeasurementPath measurementPath : measurementPathList) {
            alreadyExistingMeasurementMap.computeIfAbsent(measurementPath.getDevicePath(), k -> new HashSet()).add(measurementPath.getMeasurement());
        }
        for (Map.Entry<PartialPath, Pair<Boolean, MeasurementGroup>> entry : devicesNeedAutoCreateTimeSeries.entrySet()) {
            Set measurementSet = (Set)alreadyExistingMeasurementMap.get(entry.getKey());
            MeasurementGroup measurementGroup = (MeasurementGroup)entry.getValue().right;
            int size = measurementGroup.size();
            for (int i = 0; i < size; ++i) {
                if (measurementSet != null && measurementSet.contains(measurementGroup.getMeasurements().get(i))) continue;
                schemaTree.appendSingleMeasurement((PartialPath)entry.getKey().concatAsMeasurementPath(measurementGroup.getMeasurements().get(i)), (IMeasurementSchema)new MeasurementSchema(measurementGroup.getMeasurements().get(i), measurementGroup.getDataTypes().get(i), measurementGroup.getEncodings().get(i), measurementGroup.getCompressors().get(i)), null, null, null, (Boolean)entry.getValue().left);
            }
        }
    }

    private void internalExtendTemplate(String templateName, List<String> measurementList, List<TSDataType> dataTypeList, List<TSEncoding> encodingList, List<CompressionType> compressionTypeList, MPPQueryContext context) {
        ExecutionResult executionResult = this.executeStatement(new AlterSchemaTemplateStatement(templateName, measurementList, dataTypeList, encodingList, compressionTypeList, TemplateAlterOperationType.EXTEND_TEMPLATE), context);
        TSStatus status = executionResult.status;
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.MEASUREMENT_ALREADY_EXISTS_IN_TEMPLATE.getStatusCode()) {
            throw new SemanticException(new IoTDBException(status.getMessage(), status.getCode()));
        }
    }
}

