/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.UpdateMemory;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash.MarkDistinctHash;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.RamUsageEstimator;

public class MarkDistinctOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(MarkDistinctOperator.class);
    private final OperatorContext operatorContext;
    private final Operator child;
    private final MarkDistinctHash markDistinctHash;
    private final int[] markDistinctChannels;
    private final MemoryReservationManager memoryReservationManager;
    private long previousRetainedSize = 0L;
    private final int maxResultLines = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber();

    public MarkDistinctOperator(OperatorContext operatorContext, Operator child, List<Type> types, List<Integer> markDistinctChannels, Optional<Integer> hashChannel) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.child = child;
        Objects.requireNonNull(hashChannel, "hashChannel is null");
        Objects.requireNonNull(markDistinctChannels, "markDistinctChannels is null");
        ImmutableList.Builder distinctTypes = ImmutableList.builder();
        for (int channel : markDistinctChannels) {
            distinctTypes.add((Object)types.get(channel));
        }
        if (hashChannel.isPresent()) {
            this.markDistinctChannels = new int[markDistinctChannels.size() + 1];
            for (int i = 0; i < markDistinctChannels.size(); ++i) {
                this.markDistinctChannels[i] = markDistinctChannels.get(i);
            }
            this.markDistinctChannels[markDistinctChannels.size()] = hashChannel.get();
        } else {
            this.markDistinctChannels = Ints.toArray(markDistinctChannels);
        }
        this.markDistinctHash = new MarkDistinctHash((List<Type>)distinctTypes.build(), hashChannel.isPresent(), UpdateMemory.NOOP);
        this.memoryReservationManager = operatorContext.getDriverContext().getFragmentInstanceContext().getMemoryReservationContext();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock input = this.child.nextWithTimer();
        if (input == null) {
            return null;
        }
        Column[] markColumn = new Column[]{this.markDistinctHash.markDistinctRows(input.getColumns(this.markDistinctChannels))};
        this.updateOccupiedMemorySize();
        return input.appendValueColumns(markColumn);
    }

    private void updateOccupiedMemorySize() {
        long memorySize = this.markDistinctHash.getEstimatedSize();
        this.operatorContext.recordSpecifiedInfo("CurrentUsedMemory", Long.toString(memorySize));
        long delta = memorySize - this.previousRetainedSize;
        if (delta > 0L) {
            this.memoryReservationManager.reserveMemoryCumulatively(delta);
        } else if (delta < 0L) {
            this.memoryReservationManager.releaseMemoryCumulatively(-delta);
        }
        this.previousRetainedSize = memorySize;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.child.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemory() + (long)this.maxResultLines;
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize() + (long)this.maxResultLines;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext);
    }
}

