/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

abstract class AbstractFillOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AbstractFillOperator.class);
    private final OperatorContext operatorContext;
    private final IFill[] fillArray;
    private final Operator child;
    private final int outputColumnCount;

    AbstractFillOperator(OperatorContext operatorContext, IFill[] fillArray, Operator child) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Preconditions.checkArgument((fillArray != null && fillArray.length > 0 ? 1 : 0) != 0, (Object)"fillArray should not be null or empty");
        this.fillArray = fillArray;
        this.child = Objects.requireNonNull(child, "child operator is null");
        this.outputColumnCount = fillArray.length;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock block = this.child.nextWithTimer();
        if (block == null) {
            return null;
        }
        Preconditions.checkArgument((this.outputColumnCount == block.getValueColumnCount() ? 1 : 0) != 0, (Object)"outputColumnCount is not equal to value column count of child operator's TsBlock");
        Column[] valueColumns = new Column[this.outputColumnCount];
        for (int i = 0; i < this.outputColumnCount; ++i) {
            valueColumns[i] = this.fillArray[i].fill(this.getHelperColumn(block), block.getColumn(i));
        }
        return TsBlock.wrapBlocksWithoutCopy((int)block.getPositionCount(), (Column)block.getTimeColumn(), (Column[])valueColumns);
    }

    abstract Column getHelperColumn(TsBlock var1);

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.child.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return 2L * this.child.calculateMaxPeekMemory() + this.child.calculateRetainedSizeAfterCallingNext();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext);
    }
}

