/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.twostage.combiner;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.processor.twostage.operator.Operator;
import org.apache.iotdb.db.pipe.processor.twostage.state.State;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Combiner {
    private static final Logger LOGGER = LoggerFactory.getLogger(Combiner.class);
    private static final long MAX_COMBINER_LIVE_TIME_IN_MS = PipeConfig.getInstance().getTwoStageAggregateMaxCombinerLiveTimeInMs();
    private final long creationTimeInMs;
    private final Operator operator;
    private final ConcurrentMap<Integer, Integer> expectedRegionId2DataNodeIdMap;
    private final Set<Integer> receivedRegionIdSet;
    private final AtomicBoolean isComplete = new AtomicBoolean(false);

    public Combiner(Operator operator, ConcurrentMap<Integer, Integer> expectedRegionId2DataNodeIdMap) {
        this.creationTimeInMs = System.currentTimeMillis();
        this.operator = operator;
        this.expectedRegionId2DataNodeIdMap = expectedRegionId2DataNodeIdMap;
        this.receivedRegionIdSet = new HashSet<Integer>();
    }

    public TSStatus combine(int regionId, State state) {
        HashSet finalExpectedRegionIdSet = new HashSet(this.expectedRegionId2DataNodeIdMap.keySet());
        if (finalExpectedRegionIdSet.isEmpty()) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)"Expected region id set is empty. Sender should try again.");
        }
        this.receivedRegionIdSet.add(regionId);
        this.operator.combine(state);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Combiner combine: regionId: {}, state: {}, receivedRegionIdSet: {}, expectedRegionIdSet: {}", new Object[]{regionId, state, this.receivedRegionIdSet, finalExpectedRegionIdSet});
        }
        if (this.receivedRegionIdSet.containsAll(finalExpectedRegionIdSet)) {
            this.operator.onComplete();
            this.isComplete.set(true);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Combiner combine completed: regionId: {}, state: {}, receivedRegionIdSet: {}, expectedRegionIdSet: {}", new Object[]{regionId, state, this.receivedRegionIdSet, finalExpectedRegionIdSet});
            }
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public boolean isOutdated() {
        return System.currentTimeMillis() - this.creationTimeInMs > MAX_COMBINER_LIVE_TIME_IN_MS;
    }

    public boolean isComplete() {
        return this.isComplete.get();
    }
}

