/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.FileInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class CompactionTaskInfo {
    private final List<FileInfo> fileInfoList;
    private final List<TsFileResource> resources;
    private int maxConcurrentSeriesNum = 1;
    private long maxChunkMetadataSize = 0L;
    private int maxChunkMetadataNumInDevice = 0;
    private int maxChunkMetadataNumInSeries = 0;
    private long modificationFileSize = 0L;
    private long totalFileSize = 0L;
    private long totalChunkNum = 0L;
    private long totalChunkMetadataSize = 0L;

    protected CompactionTaskInfo(List<TsFileResource> resources, List<FileInfo> fileInfoList) {
        this.fileInfoList = fileInfoList;
        this.resources = resources;
        for (TsFileResource resource : resources) {
            this.modificationFileSize += resource.getTotalModSizeInByte();
            this.totalFileSize += resource.getTsFileSize();
        }
        for (FileInfo fileInfo : fileInfoList) {
            this.maxConcurrentSeriesNum = Math.max(this.maxConcurrentSeriesNum, fileInfo.maxAlignedSeriesNumInDevice);
            this.maxChunkMetadataNumInSeries = Math.max(this.maxChunkMetadataNumInSeries, fileInfo.maxSeriesChunkNum);
            this.maxChunkMetadataNumInDevice = Math.max(this.maxChunkMetadataNumInDevice, fileInfo.maxDeviceChunkNum);
            this.maxChunkMetadataSize = Math.max(this.maxChunkMetadataSize, fileInfo.averageChunkMetadataSize);
            this.totalChunkNum += (long)fileInfo.totalChunkNum;
            this.totalChunkMetadataSize += (long)fileInfo.totalChunkNum * fileInfo.averageChunkMetadataSize;
        }
    }

    public int getMaxChunkMetadataNumInDevice() {
        return this.maxChunkMetadataNumInDevice;
    }

    public int getMaxChunkMetadataNumInSeries() {
        return this.maxChunkMetadataNumInSeries;
    }

    public long getMaxChunkMetadataSize() {
        return this.maxChunkMetadataSize;
    }

    public List<FileInfo> getFileInfoList() {
        return this.fileInfoList;
    }

    public int getMaxConcurrentSeriesNum() {
        return this.maxConcurrentSeriesNum;
    }

    public long getModificationFileSize() {
        return this.modificationFileSize;
    }

    public long getTotalFileSize() {
        return this.totalFileSize;
    }

    public long getTotalChunkNum() {
        return this.totalChunkNum;
    }

    public List<TsFileResource> getResources() {
        return this.resources;
    }

    public long getTotalChunkMetadataSize() {
        return this.totalChunkMetadataSize;
    }
}

