/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.ProjectOffPushDownRule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.InformationSchemaTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TreeDeviceViewScanNode;

public class PruneTableScanColumns
extends ProjectOffPushDownRule<TableScanNode> {
    private final Metadata metadata;

    public PruneTableScanColumns(Metadata metadata) {
        super(Patterns.tableScan());
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, TableScanNode node, Set<Symbol> referencedOutputs) {
        return PruneTableScanColumns.pruneColumns(node, referencedOutputs);
    }

    public static Optional<PlanNode> pruneColumns(TableScanNode node, Set<Symbol> referencedOutputs) {
        if (node instanceof AggregationTableScanNode) {
            return Optional.empty();
        }
        ArrayList<Symbol> newOutputs = new ArrayList<Symbol>();
        LinkedHashMap<Symbol, ColumnSchema> newAssignments = new LinkedHashMap<Symbol, ColumnSchema>();
        for (Symbol symbol2 : node.getOutputSymbols()) {
            if (!referencedOutputs.contains(symbol2)) continue;
            newOutputs.add(symbol2);
            newAssignments.put(symbol2, node.getAssignments().get(symbol2));
        }
        if (newOutputs.size() == node.getOutputSymbols().size()) {
            return Optional.empty();
        }
        if (node.getPushDownPredicate() != null) {
            SymbolsExtractor.extractUnique(node.getPushDownPredicate()).forEach(symbol -> newAssignments.put((Symbol)symbol, node.getAssignments().get(symbol)));
        }
        if (node instanceof DeviceTableScanNode) {
            DeviceTableScanNode deviceTableScanNode = (DeviceTableScanNode)node;
            deviceTableScanNode.getTimePredicate().ifPresent(timePredicate -> SymbolsExtractor.extractUnique(timePredicate).forEach(symbol -> newAssignments.put((Symbol)symbol, node.getAssignments().get(symbol))));
            if (node instanceof TreeDeviceViewScanNode) {
                TreeDeviceViewScanNode treeDeviceViewScanNode = (TreeDeviceViewScanNode)deviceTableScanNode;
                return Optional.of(new TreeDeviceViewScanNode(deviceTableScanNode.getPlanNodeId(), deviceTableScanNode.getQualifiedObjectName(), newOutputs, newAssignments, deviceTableScanNode.getDeviceEntries(), deviceTableScanNode.getIdAndAttributeIndexMap(), deviceTableScanNode.getScanOrder(), deviceTableScanNode.getTimePredicate().orElse(null), deviceTableScanNode.getPushDownPredicate(), deviceTableScanNode.getPushDownLimit(), deviceTableScanNode.getPushDownOffset(), deviceTableScanNode.isPushLimitToEachDevice(), deviceTableScanNode.containsNonAlignedDevice(), treeDeviceViewScanNode.getTreeDBName(), treeDeviceViewScanNode.getMeasurementColumnNameMap()));
            }
            return Optional.of(new DeviceTableScanNode(deviceTableScanNode.getPlanNodeId(), deviceTableScanNode.getQualifiedObjectName(), newOutputs, newAssignments, deviceTableScanNode.getDeviceEntries(), deviceTableScanNode.getIdAndAttributeIndexMap(), deviceTableScanNode.getScanOrder(), deviceTableScanNode.getTimePredicate().orElse(null), deviceTableScanNode.getPushDownPredicate(), deviceTableScanNode.getPushDownLimit(), deviceTableScanNode.getPushDownOffset(), deviceTableScanNode.isPushLimitToEachDevice(), deviceTableScanNode.containsNonAlignedDevice()));
        }
        if (node instanceof InformationSchemaTableScanNode) {
            return Optional.empty();
        }
        throw new UnsupportedOperationException("Unknown TableScanNode type: " + node.getClass().getSimpleName());
    }
}

