/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.TableDeviceSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceSchemaCache;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.DeviceAttributeCacheUpdater;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateClearContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateDetailContainer;
import org.apache.iotdb.mpp.rpc.thrift.TAttributeUpdateReq;
import org.apache.iotdb.mpp.rpc.thrift.TSchemaRegionAttributeInfo;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;

public class TableDeviceCacheAttributeGuard {
    private final LinkedBlockingDeque<Set<?>> applyQueue = new LinkedBlockingDeque();
    private final Map<Integer, Pair<Long, String>> fetchedSchemaRegionIds2LargestVersionAndDatabaseMap = new ConcurrentHashMap<Integer, Pair<Long, String>>();
    private final TableDeviceSchemaCache cache = TableDeviceSchemaCache.getInstance();

    public boolean isRegionFetched(Integer schemaRegionId) {
        return this.fetchedSchemaRegionIds2LargestVersionAndDatabaseMap.containsKey(schemaRegionId);
    }

    public void addFetchedRegion(Integer schemaRegionId) {
        this.fetchedSchemaRegionIds2LargestVersionAndDatabaseMap.put(schemaRegionId, (Pair<Long, String>)new Pair((Object)Long.MIN_VALUE, null));
    }

    @Nonnull
    public Set<Long> addFetchQueryId(long queryId) {
        Set<Object> longSet;
        Set<?> lastSet = this.applyQueue.peekLast();
        if (Objects.isNull(lastSet) || lastSet instanceof HashSet) {
            longSet = Collections.newSetFromMap(new ConcurrentHashMap());
            this.applyQueue.add(longSet);
        } else {
            longSet = lastSet;
        }
        longSet.add(queryId);
        return longSet;
    }

    public synchronized void handleAttributeUpdate(TAttributeUpdateReq updateReq) {
        updateReq.getAttributeUpdateMap().entrySet().removeIf(entry -> {
            if (!this.fetchedSchemaRegionIds2LargestVersionAndDatabaseMap.containsKey(entry.getKey()) || ((TSchemaRegionAttributeInfo)entry.getValue()).getVersion() <= (Long)this.fetchedSchemaRegionIds2LargestVersionAndDatabaseMap.get(entry.getKey()).getLeft()) {
                return true;
            }
            this.fetchedSchemaRegionIds2LargestVersionAndDatabaseMap.put((Integer)entry.getKey(), (Pair<Long, String>)new Pair((Object)((TSchemaRegionAttributeInfo)entry.getValue()).getVersion(), (Object)((TSchemaRegionAttributeInfo)entry.getValue()).getDatabase()));
            return false;
        });
        this.applyQueue.add(updateReq.getAttributeUpdateMap().entrySet().stream().map(entry -> new Pair((Object)((Integer)entry.getKey()), (Object)((TSchemaRegionAttributeInfo)entry.getValue()).getBody())).collect(Collectors.toSet()));
        this.tryUpdateCache();
    }

    public synchronized void tryUpdateCache() {
        while (!this.applyQueue.isEmpty()) {
            Set<?> firstElement = this.applyQueue.peek();
            if (firstElement instanceof HashSet) {
                for (Object element : firstElement) {
                    Pair schemaRegionIdContainerBytesPair = (Pair)element;
                    this.handleContainer((String)this.fetchedSchemaRegionIds2LargestVersionAndDatabaseMap.get(schemaRegionIdContainerBytesPair.getLeft()).getRight(), DeviceAttributeCacheUpdater.getContainer((byte[])schemaRegionIdContainerBytesPair.getRight()));
                }
                this.applyQueue.removeFirst();
                continue;
            }
            if (!firstElement.isEmpty()) break;
            this.applyQueue.removeFirst();
        }
    }

    public synchronized void setVersion(int schemaRegionId, long newVersion) {
        this.fetchedSchemaRegionIds2LargestVersionAndDatabaseMap.computeIfPresent(schemaRegionId, (id, pair) -> {
            if (newVersion > (Long)pair.getLeft()) {
                pair.setLeft((Object)newVersion);
            }
            return pair;
        });
    }

    public void handleContainer(String database, UpdateContainer container) {
        if (container instanceof UpdateDetailContainer) {
            ((UpdateDetailContainer)container).getUpdateMap().forEach((table, deviceNodesMap) -> deviceNodesMap.forEach((nodes, attributes) -> this.cache.updateAttributes(database, TableDeviceSchemaFetcher.convertIdValuesToDeviceID(table, nodes.toArray(new String[0])), (Map<String, Binary>)attributes)));
        } else {
            ((UpdateClearContainer)container).getTableNames().forEach(table -> this.cache.invalidateAttributes(database, (String)table));
        }
    }
}

