/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array;

import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.BigArrays;
import org.apache.tsfile.utils.RamUsageEstimator;

public final class ObjectBigArray<T> {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ObjectBigArray.class);
    private static final long SIZE_OF_SEGMENT = RamUsageEstimator.sizeOfObjectArray((int)1024);
    private final Object initialValue;
    private Object[][] array;
    private long capacity;
    private int segments;

    public ObjectBigArray() {
        this(null);
    }

    public ObjectBigArray(Object initialValue) {
        this.initialValue = initialValue;
        this.array = new Object[1024][];
        this.allocateNewSegment();
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long sizeOf() {
        return INSTANCE_SIZE + RamUsageEstimator.shallowSizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public T get(long index) {
        return (T)this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, T value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public boolean replace(long index, T value) {
        Object[] segment = this.array[BigArrays.segment(index)];
        boolean existed = segment[BigArrays.offset(index)] != null;
        segment[BigArrays.offset((long)index)] = value;
        return existed;
    }

    public void ensureCapacity(long length) {
        if (this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    public void fill(T value) {
        for (Object[] segment : this.array) {
            if (segment == null) {
                return;
            }
            Arrays.fill(segment, value);
        }
    }

    public void reset() {
        this.fill(this.initialValue);
    }

    public void forEach(Consumer<T> action) {
        for (Object[] segment : this.array) {
            if (segment == null) {
                return;
            }
            for (Object object : segment) {
                action.accept(object);
            }
        }
    }

    public void copyTo(long sourceIndex, ObjectBigArray<T> destination, long destinationIndex, long length) {
        while (length > 0L) {
            int startSegment = BigArrays.segment(sourceIndex);
            int startOffset = BigArrays.offset(sourceIndex);
            int destinationStartSegment = BigArrays.segment(destinationIndex);
            int destinationStartOffset = BigArrays.offset(destinationIndex);
            int copyLength = Math.min(1024 - startOffset, 1024 - destinationStartOffset);
            copyLength = Math.min(copyLength, length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length);
            System.arraycopy(this.array[startSegment], startOffset, destination.array[destinationStartSegment], destinationStartOffset, copyLength);
            sourceIndex += (long)copyLength;
            destinationIndex += (long)copyLength;
            length -= (long)copyLength;
        }
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (Object[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        Object[] newSegment = new Object[1024];
        if (this.initialValue != null) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024L;
        ++this.segments;
    }
}

