/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.function.partition;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.process.function.partition.Slice;
import org.apache.tsfile.block.column.Column;

public class SliceCache {
    private final List<Slice> slices = new ArrayList<Slice>();
    private final List<Long> startOffsets = new ArrayList<Long>();
    private long estimatedSize = 0L;

    public List<Column[]> getPassThroughResult(Column passThroughIndexes) {
        ArrayList<Column[]> result = new ArrayList<Column[]>();
        int sliceIndex = this.findSliceIndex(passThroughIndexes.getLong(0));
        int indexStart = 0;
        for (int i = 1; i < passThroughIndexes.getPositionCount(); ++i) {
            int tmp = this.findSliceIndex(passThroughIndexes.getLong(i));
            if (tmp == sliceIndex) continue;
            int[] indexArray = new int[i - indexStart];
            for (int j = indexStart; j < i; ++j) {
                indexArray[j - indexStart] = (int)(passThroughIndexes.getLong(j) - this.getSliceOffset(sliceIndex));
            }
            result.add(this.slices.get(sliceIndex).getPassThroughResult(indexArray));
            indexStart = i;
            sliceIndex = tmp;
        }
        int[] indexArray = new int[passThroughIndexes.getPositionCount() - indexStart];
        for (int j = indexStart; j < passThroughIndexes.getPositionCount(); ++j) {
            indexArray[j - indexStart] = (int)(passThroughIndexes.getLong(j) - this.getSliceOffset(sliceIndex));
        }
        result.add(this.slices.get(sliceIndex).getPassThroughResult(indexArray));
        return result;
    }

    public void addSlice(Slice slice) {
        this.slices.add(slice);
        if (this.startOffsets.isEmpty()) {
            this.startOffsets.add(0L);
        } else {
            this.startOffsets.add(this.startOffsets.get(this.startOffsets.size() - 1) + this.slices.get(this.startOffsets.size() - 1).getSize());
        }
        this.estimatedSize += slice.getEstimatedSize();
    }

    private long getSliceOffset(int slideIndex) {
        return this.startOffsets.get(slideIndex);
    }

    private int findSliceIndex(long passThroughIndex) {
        int left = 0;
        int right = this.startOffsets.size() - 1;
        int result = -1;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            if (this.startOffsets.get(mid) <= passThroughIndex) {
                result = mid;
                left = mid + 1;
                continue;
            }
            right = mid - 1;
        }
        return result;
    }

    public long getEstimatedSize() {
        return this.estimatedSize;
    }

    public void clear() {
        this.slices.clear();
    }

    public void close() {
    }
}

