/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.dataregion.realtime;

import java.util.Objects;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.event.common.deletion.PipeDeleteDataNodeEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.dataregion.IoTDBDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.epoch.TsFileEpoch;
import org.apache.iotdb.db.pipe.metric.source.PipeDataRegionExtractorMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeRealtimeDataRegionHybridExtractor
extends PipeRealtimeDataRegionExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeRealtimeDataRegionHybridExtractor.class);
    private final boolean isPipeEpochKeepTsFileAfterStuckRestartEnabled = PipeConfig.getInstance().isPipeEpochKeepTsFileAfterStuckRestartEnabled();

    @Override
    protected void doExtract(PipeRealtimeEvent event) {
        EnrichedEvent eventToExtract = event.getEvent();
        if (eventToExtract instanceof TabletInsertionEvent) {
            this.extractTabletInsertion(event);
        } else if (eventToExtract instanceof TsFileInsertionEvent) {
            this.extractTsFileInsertion(event);
        } else if (eventToExtract instanceof PipeHeartbeatEvent) {
            this.extractHeartbeat(event);
        } else if (eventToExtract instanceof PipeDeleteDataNodeEvent) {
            this.extractDirectly(event);
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported event type %s for hybrid realtime extractor %s", eventToExtract.getClass(), this));
        }
    }

    @Override
    public boolean isNeedListenToTsFile() {
        return this.shouldExtractInsertion;
    }

    @Override
    public boolean isNeedListenToInsertNode() {
        return this.shouldExtractInsertion;
    }

    private void extractTabletInsertion(PipeRealtimeEvent event) {
        TsFileEpoch.State state = event.getTsFileEpoch().getState(this);
        if (state != TsFileEpoch.State.USING_TSFILE && state != TsFileEpoch.State.USING_BOTH && this.canNotUseTabletAnyMore(event)) {
            event.getTsFileEpoch().migrateState(this, curState -> {
                switch (curState) {
                    case USING_TSFILE: 
                    case EMPTY: {
                        return TsFileEpoch.State.USING_TSFILE;
                    }
                }
                return TsFileEpoch.State.USING_BOTH;
            });
        }
        state = event.getTsFileEpoch().getState(this);
        switch (state) {
            case USING_TSFILE: {
                event.decreaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName(), false);
                break;
            }
            case EMPTY: 
            case USING_TABLET: 
            case USING_BOTH: {
                if (this.pendingQueue.waitedOffer((Event)event)) break;
                String errorMessage = String.format("extractTabletInsertion: pending queue of PipeRealtimeDataRegionHybridExtractor %s has reached capacity, discard tablet event %s, current state %s", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
                LOGGER.error(errorMessage);
                PipeDataNodeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
                event.decreaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName(), false);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported state %s for hybrid realtime extractor %s", new Object[]{state, PipeRealtimeDataRegionHybridExtractor.class.getName()}));
            }
        }
    }

    private void extractTsFileInsertion(PipeRealtimeEvent event) {
        event.getTsFileEpoch().migrateState(this, state -> {
            switch (state) {
                case USING_TSFILE: 
                case EMPTY: {
                    return TsFileEpoch.State.USING_TSFILE;
                }
                case USING_TABLET: {
                    if (((PipeTsFileInsertionEvent)event.getEvent()).getFileStartTime() < event.getTsFileEpoch().getInsertNodeMinTime()) {
                        return TsFileEpoch.State.USING_BOTH;
                    }
                    return TsFileEpoch.State.USING_TABLET;
                }
            }
            return TsFileEpoch.State.USING_BOTH;
        });
        TsFileEpoch.State state2 = event.getTsFileEpoch().getState(this);
        switch (state2) {
            case USING_TSFILE: 
            case EMPTY: 
            case USING_TABLET: 
            case USING_BOTH: {
                if (this.pendingQueue.waitedOffer((Event)event)) break;
                String errorMessage = String.format("extractTsFileInsertion: pending queue of PipeRealtimeDataRegionHybridExtractor %s has reached capacity, discard TsFile event %s, current state %s", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
                LOGGER.error(errorMessage);
                PipeDataNodeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
                event.decreaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName(), false);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported state %s for hybrid realtime extractor %s", new Object[]{state2, PipeRealtimeDataRegionHybridExtractor.class.getName()}));
            }
        }
    }

    private boolean canNotUseTabletAnyMore(PipeRealtimeEvent event) {
        return this.isPipeTaskCurrentlyRestarted(event) || this.mayWalSizeReachThrottleThreshold(event) || this.mayMemTablePinnedCountReachDangerousThreshold(event) || this.isHistoricalTsFileEventCountExceededLimit(event) || this.isRealtimeTsFileEventCountExceededLimit(event) || this.mayTsFileLinkedCountReachDangerousThreshold(event) || this.mayInsertNodeMemoryReachDangerousThreshold(event);
    }

    private boolean isPipeTaskCurrentlyRestarted(PipeRealtimeEvent event) {
        if (!this.isPipeEpochKeepTsFileAfterStuckRestartEnabled) {
            return false;
        }
        boolean isPipeTaskCurrentlyRestarted = PipeDataNodeAgent.task().isPipeTaskCurrentlyRestarted(this.pipeName);
        if (isPipeTaskCurrentlyRestarted && event.mayExtractorUseTablets(this)) {
            LOGGER.info("Pipe task {}@{} canNotUseTabletAnyMore1: Pipe task is currently restarted", (Object)this.pipeName, (Object)this.dataRegionId);
        }
        return isPipeTaskCurrentlyRestarted;
    }

    private boolean mayWalSizeReachThrottleThreshold(PipeRealtimeEvent event) {
        boolean mayWalSizeReachThrottleThreshold;
        boolean bl = mayWalSizeReachThrottleThreshold = 3L * WALManager.getInstance().getTotalDiskUsage() > IoTDBDescriptor.getInstance().getConfig().getThrottleThreshold();
        if (mayWalSizeReachThrottleThreshold && event.mayExtractorUseTablets(this)) {
            LOGGER.info("Pipe task {}@{} canNotUseTabletAnyMore2: Wal size {} has reached throttle threshold {}", new Object[]{this.pipeName, this.dataRegionId, WALManager.getInstance().getTotalDiskUsage(), (double)IoTDBDescriptor.getInstance().getConfig().getThrottleThreshold() / 3.0});
        }
        return mayWalSizeReachThrottleThreshold;
    }

    private boolean mayMemTablePinnedCountReachDangerousThreshold(PipeRealtimeEvent event) {
        boolean mayMemTablePinnedCountReachDangerousThreshold;
        boolean bl = mayMemTablePinnedCountReachDangerousThreshold = PipeDataNodeResourceManager.wal().getPinnedWalCount() >= PipeConfig.getInstance().getPipeMaxAllowedPinnedMemTableCount() * StorageEngine.getInstance().getDataRegionNumber();
        if (mayMemTablePinnedCountReachDangerousThreshold && event.mayExtractorUseTablets(this)) {
            LOGGER.info("Pipe task {}@{} canNotUseTabletAnyMore3: The number of pinned memtables {} has reached the dangerous threshold {}", new Object[]{this.pipeName, this.dataRegionId, PipeDataNodeResourceManager.wal().getPinnedWalCount(), PipeConfig.getInstance().getPipeMaxAllowedPinnedMemTableCount() * StorageEngine.getInstance().getDataRegionNumber()});
        }
        return mayMemTablePinnedCountReachDangerousThreshold;
    }

    private boolean isHistoricalTsFileEventCountExceededLimit(PipeRealtimeEvent event) {
        boolean isHistoricalTsFileEventCountExceededLimit;
        IoTDBDataRegionExtractor extractor = PipeDataRegionExtractorMetrics.getInstance().getExtractorMap().get(this.getTaskID());
        boolean bl = isHistoricalTsFileEventCountExceededLimit = Objects.nonNull((Object)extractor) && extractor.getHistoricalTsFileInsertionEventCount() >= PipeConfig.getInstance().getPipeMaxAllowedHistoricalTsFilePerDataRegion();
        if (isHistoricalTsFileEventCountExceededLimit && event.mayExtractorUseTablets(this)) {
            LOGGER.info("Pipe task {}@{} canNotUseTabletAnyMore4: The number of historical tsFile events {} has exceeded the limit {}", new Object[]{this.pipeName, this.dataRegionId, extractor.getHistoricalTsFileInsertionEventCount(), PipeConfig.getInstance().getPipeMaxAllowedHistoricalTsFilePerDataRegion()});
        }
        return isHistoricalTsFileEventCountExceededLimit;
    }

    private boolean isRealtimeTsFileEventCountExceededLimit(PipeRealtimeEvent event) {
        boolean isRealtimeTsFileEventCountExceededLimit;
        boolean bl = isRealtimeTsFileEventCountExceededLimit = this.pendingQueue.getTsFileInsertionEventCount() >= PipeConfig.getInstance().getPipeMaxAllowedPendingTsFileEpochPerDataRegion();
        if (isRealtimeTsFileEventCountExceededLimit && event.mayExtractorUseTablets(this)) {
            LOGGER.info("Pipe task {}@{} canNotUseTabletAnyMore5: The number of realtime tsFile events {} has exceeded the limit {}", new Object[]{this.pipeName, this.dataRegionId, this.pendingQueue.getTsFileInsertionEventCount(), PipeConfig.getInstance().getPipeMaxAllowedPendingTsFileEpochPerDataRegion()});
        }
        return isRealtimeTsFileEventCountExceededLimit;
    }

    private boolean mayTsFileLinkedCountReachDangerousThreshold(PipeRealtimeEvent event) {
        boolean mayTsFileLinkedCountReachDangerousThreshold;
        boolean bl = mayTsFileLinkedCountReachDangerousThreshold = (long)PipeDataNodeResourceManager.tsfile().getLinkedTsfileCount() >= PipeConfig.getInstance().getPipeMaxAllowedLinkedTsFileCount();
        if (mayTsFileLinkedCountReachDangerousThreshold && event.mayExtractorUseTablets(this)) {
            LOGGER.info("Pipe task {}@{} canNotUseTabletAnyMore6: The number of linked tsfiles {} has reached the dangerous threshold {}", new Object[]{this.pipeName, this.dataRegionId, PipeDataNodeResourceManager.tsfile().getLinkedTsfileCount(), PipeConfig.getInstance().getPipeMaxAllowedLinkedTsFileCount()});
        }
        return mayTsFileLinkedCountReachDangerousThreshold;
    }

    private boolean mayInsertNodeMemoryReachDangerousThreshold(PipeRealtimeEvent event) {
        long totalFloatingMemorySizeInBytes;
        long pipeCount;
        boolean mayInsertNodeMemoryReachDangerousThreshold;
        long floatingMemoryUsageInByte = PipeDataNodeAgent.task().getFloatingMemoryUsageInByte(this.pipeName);
        boolean bl = mayInsertNodeMemoryReachDangerousThreshold = 3L * floatingMemoryUsageInByte * (pipeCount = (long)PipeDataNodeAgent.task().getPipeCount()) >= 2L * (totalFloatingMemorySizeInBytes = PipeDataNodeResourceManager.memory().getTotalFloatingMemorySizeInBytes());
        if (mayInsertNodeMemoryReachDangerousThreshold && event.mayExtractorUseTablets(this)) {
            LOGGER.info("Pipe task {}@{} canNotUseTabletAnyMore7: The shallow memory usage of the insert node {} has reached the dangerous threshold {}", new Object[]{this.pipeName, this.dataRegionId, floatingMemoryUsageInByte * pipeCount, (double)(2L * totalFloatingMemorySizeInBytes) / 3.0});
        }
        return mayInsertNodeMemoryReachDangerousThreshold;
    }

    public Event supply() {
        PipeRealtimeEvent realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        while (realtimeEvent != null) {
            Event suppliedEvent;
            EnrichedEvent eventToSupply = realtimeEvent.getEvent();
            if (eventToSupply instanceof TabletInsertionEvent) {
                suppliedEvent = this.supplyTabletInsertion(realtimeEvent);
            } else if (eventToSupply instanceof TsFileInsertionEvent) {
                suppliedEvent = this.supplyTsFileInsertion(realtimeEvent);
            } else if (eventToSupply instanceof PipeHeartbeatEvent) {
                suppliedEvent = this.supplyHeartbeat(realtimeEvent);
            } else if (eventToSupply instanceof PipeDeleteDataNodeEvent || eventToSupply instanceof ProgressReportEvent) {
                suppliedEvent = this.supplyDirectly(realtimeEvent);
            } else {
                throw new UnsupportedOperationException(String.format("Unsupported event type %s for hybrid realtime extractor %s to supply.", eventToSupply.getClass(), this));
            }
            realtimeEvent.decreaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName(), false);
            if (suppliedEvent != null) {
                return suppliedEvent;
            }
            realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        }
        return null;
    }

    private Event supplyTabletInsertion(PipeRealtimeEvent event) {
        event.getTsFileEpoch().migrateState(this, state -> {
            if (!state.equals((Object)TsFileEpoch.State.EMPTY)) {
                return state;
            }
            return this.canNotUseTabletAnyMore(event) ? TsFileEpoch.State.USING_TSFILE : TsFileEpoch.State.USING_TABLET;
        });
        TsFileEpoch.State state2 = event.getTsFileEpoch().getState(this);
        switch (state2) {
            case USING_TSFILE: {
                return null;
            }
        }
        if (event.increaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName())) {
            return event.getEvent();
        }
        event.getTsFileEpoch().migrateState(this, s -> TsFileEpoch.State.USING_BOTH);
        LOGGER.warn("Discard tablet event {} because it is not reliable anymore. Change the state of TsFileEpoch to USING_TSFILE.", (Object)event);
        return null;
    }

    private Event supplyTsFileInsertion(PipeRealtimeEvent event) {
        event.getTsFileEpoch().migrateState(this, state -> {
            if (state.equals((Object)TsFileEpoch.State.EMPTY)) {
                LOGGER.error(String.format("EMPTY TsFileEpoch when supplying TsFile Event %s", new Object[]{event}));
                return TsFileEpoch.State.USING_TSFILE;
            }
            return state;
        });
        TsFileEpoch.State state2 = event.getTsFileEpoch().getState(this);
        switch (state2) {
            case USING_TABLET: {
                return null;
            }
        }
        if (event.increaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName())) {
            return event.getEvent();
        }
        String errorMessage = String.format("TsFile Event %s can not be supplied because the reference count can not be increased, the data represented by this event is lost", event.getEvent());
        LOGGER.error(errorMessage);
        PipeDataNodeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
        return null;
    }
}

