/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.sync;

import java.net.UnknownHostException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBSyncClientManager;
import org.apache.iotdb.commons.pipe.connector.protocol.IoTDBSslSyncConnector;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.connector.client.IoTDBDataNodeSyncClientManager;
import org.apache.iotdb.pipe.api.annotation.TableModel;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TreeModel
@TableModel
public abstract class IoTDBDataNodeSyncConnector
extends IoTDBSslSyncConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataNodeSyncConnector.class);
    protected IoTDBDataNodeSyncClientManager clientManager;

    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        IoTDBConfig iotdbConfig = IoTDBDescriptor.getInstance().getConfig();
        LinkedHashSet givenNodeUrls = this.parseNodeUrls(validator.getParameters());
        validator.validate(empty -> {
            try {
                return !NodeUrlUtils.containsLocalAddress(givenNodeUrls.stream().filter(tEndPoint -> tEndPoint.getPort() == iotdbConfig.getRpcPort()).map(TEndPoint::getIp).collect(Collectors.toList()));
            }
            catch (UnknownHostException e) {
                LOGGER.warn("Unknown host when checking pipe sink IP.", (Throwable)e);
                return false;
            }
        }, String.format("One of the endpoints %s of the receivers is pointing back to the thrift receiver %s on sender itself, or unknown host when checking pipe sink IP.", givenNodeUrls, new TEndPoint(iotdbConfig.getRpcAddress(), iotdbConfig.getRpcPort())), new Object[0]);
    }

    protected IoTDBSyncClientManager constructClient(List<TEndPoint> nodeUrls, boolean useSSL, String trustStorePath, String trustStorePwd, boolean useLeaderCache, String loadBalanceStrategy, String username, String password, boolean shouldReceiverConvertOnTypeMismatch, String loadTsFileStrategy, boolean validateTsFile, boolean shouldMarkAsPipeRequest) {
        this.clientManager = new IoTDBDataNodeSyncClientManager(nodeUrls, useSSL, Objects.nonNull(trustStorePath) ? IoTDBConfig.addDataHomeDir(trustStorePath) : null, trustStorePwd, useLeaderCache, loadBalanceStrategy, username, password, shouldReceiverConvertOnTypeMismatch, loadTsFileStrategy, validateTsFile, shouldMarkAsPipeRequest);
        return this.clientManager;
    }
}

