/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path.fa.nfa;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.iotdb.commons.path.ExtendedPartialPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.path.fa.IFAState;
import org.apache.iotdb.commons.path.fa.IFATransition;
import org.apache.iotdb.commons.path.fa.IPatternFA;

public class SimpleNFA
implements IPatternFA {
    private final boolean isPrefixMatch;
    private final PartialPath pathPattern;
    private int smallestNullableIndex;
    private final SinglePathPatternNode initialState = new InitialNode();
    private final SinglePathPatternNode[] patternNodes;

    public SimpleNFA(PartialPath pathPattern, boolean isPrefixMatch) {
        this.isPrefixMatch = isPrefixMatch;
        this.pathPattern = pathPattern;
        this.computeSmallestNullableIndex();
        this.patternNodes = new SinglePathPatternNode[pathPattern.getNodeLength() + 1];
    }

    private void computeSmallestNullableIndex() {
        String node;
        this.smallestNullableIndex = this.pathPattern.getNodeLength() - 1;
        if (!(this.pathPattern instanceof ExtendedPartialPath)) {
            return;
        }
        while (this.smallestNullableIndex >= 0 && (Objects.isNull(node = this.pathPattern.getNodes()[this.smallestNullableIndex]) || Objects.equals(node, "*") && ((ExtendedPartialPath)this.pathPattern).match(this.smallestNullableIndex, null))) {
            --this.smallestNullableIndex;
        }
    }

    @Override
    public Map<String, IFATransition> getPreciseMatchTransition(IFAState state) {
        return this.getNextNode((SinglePathPatternNode)state).getPreNodePreciseMatchTransition();
    }

    @Override
    public Iterator<IFATransition> getPreciseMatchTransitionIterator(IFAState state) {
        return this.getNextNode((SinglePathPatternNode)state).getPreNodePreciseMatchTransitionIterator();
    }

    @Override
    public Iterator<IFATransition> getFuzzyMatchTransitionIterator(IFAState state) {
        return this.getNextNode((SinglePathPatternNode)state).getPreNodeFuzzyMatchTransitionIterator();
    }

    @Override
    public int getFuzzyMatchTransitionSize(IFAState state) {
        return this.getNextNode((SinglePathPatternNode)state).getPreNodeFuzzyMatchTransitionSize();
    }

    @Override
    public IFAState getNextState(IFAState sourceState, IFATransition transition) {
        return (SinglePathPatternNode)transition;
    }

    @Override
    public IFAState getInitialState() {
        return this.initialState;
    }

    @Override
    public int getStateSize() {
        return this.patternNodes.length;
    }

    @Override
    public IFAState getState(int index) {
        return this.patternNodes[index];
    }

    @Override
    public boolean mayTransitionOverlap() {
        return true;
    }

    private SinglePathPatternNode getNextNode(SinglePathPatternNode currentNode) {
        if (currentNode.patternIndex == this.pathPattern.getNodeLength()) {
            return currentNode;
        }
        String[] rawNodes = this.pathPattern.getNodes();
        int nextIndex = currentNode.getIndex() + 1;
        if (this.patternNodes[nextIndex] == null) {
            this.patternNodes[nextIndex] = nextIndex == rawNodes.length ? new PrefixMatchNode(nextIndex, currentNode.getTracebackNode()) : (rawNodes[nextIndex] == null ? new NameMatchNode(nextIndex, currentNode.getTracebackNode()) : (rawNodes[nextIndex].equals("**") ? new MultiLevelWildcardMatchNode(nextIndex) : (rawNodes[nextIndex].equals("*") ? new OneLevelWildcardMatchNode(nextIndex, currentNode.getTracebackNode(), this.pathPattern instanceof ExtendedPartialPath ? event -> ((ExtendedPartialPath)this.pathPattern).match(nextIndex, (String)event) : event -> true) : (PathPatternUtil.hasWildcard(rawNodes[nextIndex]) ? new RegexMatchNode(nextIndex, currentNode.getTracebackNode()) : new NameMatchNode(nextIndex, currentNode.getTracebackNode())))));
        }
        return this.patternNodes[nextIndex];
    }

    private class InitialNode
    extends SinglePathPatternNode {
        private InitialNode() {
            super(-1, null);
        }

        @Override
        public boolean isInitial() {
            return true;
        }

        @Override
        protected Map<String, IFATransition> getPreNodePreciseMatchTransition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isMatch(String event) {
            return false;
        }

        @Override
        protected Iterator<IFATransition> getPreNodePreciseMatchTransitionIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Iterator<IFATransition> getPreNodeFuzzyMatchTransitionIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int getPreNodeFuzzyMatchTransitionSize() {
            throw new UnsupportedOperationException();
        }
    }

    private abstract class SinglePathPatternNode
    implements IFAState,
    IFATransition {
        protected final int patternIndex;
        protected final SinglePathPatternNode tracebackNode;

        private SinglePathPatternNode(int patternIndex, SinglePathPatternNode tracebackNode) {
            this.patternIndex = patternIndex;
            this.tracebackNode = tracebackNode;
        }

        @Override
        public boolean isInitial() {
            return this.patternIndex == -1;
        }

        @Override
        public boolean isFinal() {
            return this.patternIndex >= SimpleNFA.this.smallestNullableIndex;
        }

        @Override
        public int getIndex() {
            return this.patternIndex;
        }

        @Override
        public String getAcceptEvent() {
            return SimpleNFA.this.pathPattern.getNodes()[this.patternIndex];
        }

        public SinglePathPatternNode getTracebackNode() {
            return this.tracebackNode;
        }

        protected abstract Map<String, IFATransition> getPreNodePreciseMatchTransition();

        protected abstract Iterator<IFATransition> getPreNodePreciseMatchTransitionIterator();

        protected abstract Iterator<IFATransition> getPreNodeFuzzyMatchTransitionIterator();

        protected abstract int getPreNodeFuzzyMatchTransitionSize();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SinglePathPatternNode patternNode = (SinglePathPatternNode)o;
            return this.patternIndex == patternNode.patternIndex;
        }

        public int hashCode() {
            return this.patternIndex;
        }
    }

    private class PrefixMatchNode
    extends SinglePathPatternNode {
        private PrefixMatchNode(int patternIndex, SinglePathPatternNode tracebackNode) {
            super(patternIndex, tracebackNode);
        }

        @Override
        public boolean isMatch(String event) {
            return true;
        }

        @Override
        protected Map<String, IFATransition> getPreNodePreciseMatchTransition() {
            return Collections.emptyMap();
        }

        @Override
        protected Iterator<IFATransition> getPreNodePreciseMatchTransitionIterator() {
            return Collections.emptyIterator();
        }

        @Override
        protected Iterator<IFATransition> getPreNodeFuzzyMatchTransitionIterator() {
            if (SimpleNFA.this.isPrefixMatch) {
                return new SingletonIterator<IFATransition>(this);
            }
            if (this.tracebackNode == null) {
                return Collections.emptyIterator();
            }
            return new SingletonIterator<IFATransition>(this.tracebackNode);
        }

        @Override
        protected int getPreNodeFuzzyMatchTransitionSize() {
            return SimpleNFA.this.isPrefixMatch || this.tracebackNode != null ? 1 : 0;
        }
    }

    private class NameMatchNode
    extends SinglePathPatternNode {
        private Map<String, IFATransition> preNodePreciseMatchTransitionMap;

        private NameMatchNode(int patternIndex, SinglePathPatternNode tracebackNode) {
            super(patternIndex, tracebackNode);
        }

        @Override
        public boolean isMatch(String event) {
            return Objects.equals(SimpleNFA.this.pathPattern.getNodes()[this.patternIndex], event);
        }

        @Override
        protected Map<String, IFATransition> getPreNodePreciseMatchTransition() {
            if (this.preNodePreciseMatchTransitionMap == null) {
                this.preNodePreciseMatchTransitionMap = Collections.singletonMap(SimpleNFA.this.pathPattern.getNodes()[this.patternIndex], this);
            }
            return this.preNodePreciseMatchTransitionMap;
        }

        @Override
        protected Iterator<IFATransition> getPreNodePreciseMatchTransitionIterator() {
            return new SingletonIterator<IFATransition>(this);
        }

        @Override
        protected Iterator<IFATransition> getPreNodeFuzzyMatchTransitionIterator() {
            if (this.tracebackNode == null) {
                return Collections.emptyIterator();
            }
            return new SingletonIterator<IFATransition>(this.tracebackNode);
        }

        @Override
        protected int getPreNodeFuzzyMatchTransitionSize() {
            if (this.tracebackNode == null) {
                return 0;
            }
            return 1;
        }
    }

    private class MultiLevelWildcardMatchNode
    extends SinglePathPatternNode {
        private MultiLevelWildcardMatchNode(int patternIndex) {
            super(patternIndex, null);
        }

        @Override
        public SinglePathPatternNode getTracebackNode() {
            return this;
        }

        @Override
        public boolean isMatch(String event) {
            return true;
        }

        @Override
        protected Map<String, IFATransition> getPreNodePreciseMatchTransition() {
            return Collections.emptyMap();
        }

        @Override
        protected Iterator<IFATransition> getPreNodePreciseMatchTransitionIterator() {
            return Collections.emptyIterator();
        }

        @Override
        protected Iterator<IFATransition> getPreNodeFuzzyMatchTransitionIterator() {
            return new SingletonIterator<IFATransition>(this);
        }

        @Override
        protected int getPreNodeFuzzyMatchTransitionSize() {
            return 1;
        }
    }

    private class OneLevelWildcardMatchNode
    extends SinglePathPatternNode {
        private final Function<String, Boolean> matchFunction;

        private OneLevelWildcardMatchNode(int patternIndex, SinglePathPatternNode tracebackNode, Function<String, Boolean> matchFunction) {
            super(patternIndex, tracebackNode);
            this.matchFunction = matchFunction;
        }

        @Override
        public boolean isMatch(String event) {
            return this.matchFunction.apply(event);
        }

        @Override
        protected Map<String, IFATransition> getPreNodePreciseMatchTransition() {
            return Collections.emptyMap();
        }

        @Override
        protected Iterator<IFATransition> getPreNodePreciseMatchTransitionIterator() {
            return Collections.emptyIterator();
        }

        @Override
        protected Iterator<IFATransition> getPreNodeFuzzyMatchTransitionIterator() {
            if (this.tracebackNode == null) {
                return new SingletonIterator<IFATransition>(this);
            }
            return new DualIterator<IFATransition>(this, this.tracebackNode);
        }

        @Override
        protected int getPreNodeFuzzyMatchTransitionSize() {
            if (this.tracebackNode == null) {
                return 1;
            }
            return 2;
        }
    }

    private class RegexMatchNode
    extends SinglePathPatternNode {
        private Pattern regexPattern;

        private RegexMatchNode(int patternIndex, SinglePathPatternNode tracebackNode) {
            super(patternIndex, tracebackNode);
        }

        @Override
        public boolean isMatch(String event) {
            if (this.regexPattern == null) {
                this.regexPattern = Pattern.compile(SimpleNFA.this.pathPattern.getNodes()[this.patternIndex].replace("*", ".*"));
            }
            return this.regexPattern.matcher(event).matches();
        }

        @Override
        protected Map<String, IFATransition> getPreNodePreciseMatchTransition() {
            return Collections.emptyMap();
        }

        @Override
        protected Iterator<IFATransition> getPreNodePreciseMatchTransitionIterator() {
            return Collections.emptyIterator();
        }

        @Override
        protected Iterator<IFATransition> getPreNodeFuzzyMatchTransitionIterator() {
            if (this.tracebackNode == null) {
                return new SingletonIterator<IFATransition>(this);
            }
            return new DualIterator<IFATransition>(this, this.tracebackNode);
        }

        @Override
        protected int getPreNodeFuzzyMatchTransitionSize() {
            if (this.tracebackNode == null) {
                return 1;
            }
            return 2;
        }
    }

    private static class DualIterator<E>
    implements Iterator<E> {
        private E e1;
        private E e2;

        private DualIterator(E e1, E e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        @Override
        public boolean hasNext() {
            return this.e2 != null;
        }

        @Override
        public E next() {
            E result;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.e1 != null) {
                result = this.e1;
                this.e1 = null;
            } else {
                result = this.e2;
                this.e2 = null;
            }
            return result;
        }
    }

    private static class SingletonIterator<E>
    implements Iterator<E> {
        private E e;

        private SingletonIterator(E e) {
            this.e = e;
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            E result = this.e;
            this.e = null;
            return result;
        }
    }
}

