/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.Collections;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AbstractQueryDeviceWithCache;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Table;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;

public class CountDevice
extends AbstractQueryDeviceWithCache {
    public static final String COUNT_DEVICE_HEADER_STRING = "count(devices)";

    public CountDevice(NodeLocation location, Table table, Expression rawExpression) {
        super(location, table, rawExpression);
    }

    @Override
    public DatasetHeader getDataSetHeader() {
        return new DatasetHeader(Collections.singletonList(new ColumnHeader(COUNT_DEVICE_HEADER_STRING, TSDataType.INT64)), true);
    }

    @Override
    public TsBlock getTsBlock(Analysis analysis) {
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT64));
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeLong((long)this.results.size());
        tsBlockBuilder.declarePosition();
        return tsBlockBuilder.build();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCountDevice(this, context);
    }

    @Override
    public String toString() {
        return "CountDevice" + this.toStringContent();
    }
}

