/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ExpressionTreeUtils;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Field;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.FieldId;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ResolvedField;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Scope;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ScopeReferenceExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ScopeAware;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticUnaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CoalesceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentTime;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DereferenceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExistsPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FieldReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullIfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Parameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuantifiedComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Row;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubqueryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Trim;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WhenClause;

class AggregationAnalyzer {
    private final Set<FieldId> groupingFields;
    private final Set<ScopeAware<Expression>> expressions;
    private final Map<NodeRef<Expression>, ResolvedField> columnReferences;
    private final Analysis analysis;
    private final Scope sourceScope;
    private final Optional<Scope> orderByScope;

    public static void verifySourceAggregations(List<Expression> groupByExpressions, Scope sourceScope, List<Expression> expressions, Analysis analysis) {
        AggregationAnalyzer analyzer = new AggregationAnalyzer(groupByExpressions, sourceScope, Optional.empty(), analysis);
        for (Expression expression : expressions) {
            analyzer.analyze(expression);
        }
    }

    public static void verifyOrderByAggregations(List<Expression> groupByExpressions, Scope sourceScope, Scope orderByScope, List<Expression> expressions, Analysis analysis) {
        AggregationAnalyzer analyzer = new AggregationAnalyzer(groupByExpressions, sourceScope, Optional.of(orderByScope), analysis);
        for (Expression expression : expressions) {
            analyzer.analyze(expression);
        }
    }

    private AggregationAnalyzer(List<Expression> groupByExpressions, Scope sourceScope, Optional<Scope> orderByScope, Analysis analysis) {
        Objects.requireNonNull(groupByExpressions, "groupByExpressions is null");
        Objects.requireNonNull(sourceScope, "sourceScope is null");
        Objects.requireNonNull(orderByScope, "orderByScope is null");
        Objects.requireNonNull(analysis, "analysis is null");
        this.sourceScope = sourceScope;
        this.orderByScope = orderByScope;
        this.analysis = analysis;
        this.expressions = (Set)groupByExpressions.stream().map(expression -> ScopeAware.scopeAwareKey(expression, analysis, sourceScope)).collect(ImmutableSet.toImmutableSet());
        this.columnReferences = analysis.getColumnReferenceFields();
        this.groupingFields = (Set)groupByExpressions.stream().map(NodeRef::of).filter(this.columnReferences::containsKey).map(this.columnReferences::get).map(ResolvedField::getFieldId).collect(ImmutableSet.toImmutableSet());
        this.groupingFields.forEach(fieldId -> Preconditions.checkState((boolean)ScopeReferenceExtractor.isFieldFromScope(fieldId, sourceScope), (String)"Grouping field %s should originate from %s", (Object)fieldId, (Object)sourceScope.getRelationType()));
    }

    private void analyze(Expression expression) {
        Visitor visitor = new Visitor();
        if (!visitor.process((Node)expression, null).booleanValue()) {
            throw new SemanticException(String.format("'%s' must be an aggregate expression or appear in GROUP BY clause", expression));
        }
    }

    private class Visitor
    extends AstVisitor<Boolean, Void> {
        private Visitor() {
        }

        @Override
        protected Boolean visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("aggregation analysis not yet implemented for: " + node.getClass().getName());
        }

        @Override
        protected Boolean visitSubqueryExpression(SubqueryExpression node, Void context) {
            ScopeReferenceExtractor.getReferencesToScope(node, AggregationAnalyzer.this.analysis, AggregationAnalyzer.this.sourceScope).filter(expression -> !this.isGroupingKey((Expression)expression)).findFirst().ifPresent(expression -> {
                throw new SemanticException(String.format("Subquery uses '%s' which must appear in GROUP BY clause", expression));
            });
            return true;
        }

        @Override
        protected Boolean visitExists(ExistsPredicate node, Void context) {
            Preconditions.checkState((boolean)(node.getSubquery() instanceof SubqueryExpression));
            return this.process((Node)node.getSubquery(), context);
        }

        @Override
        protected Boolean visitCast(Cast node, Void context) {
            return this.process((Node)node.getExpression(), context);
        }

        @Override
        protected Boolean visitCoalesceExpression(CoalesceExpression node, Void context) {
            return node.getOperands().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        @Override
        protected Boolean visitNullIfExpression(NullIfExpression node, Void context) {
            return this.process((Node)node.getFirst(), context) != false && this.process((Node)node.getSecond(), context) != false;
        }

        @Override
        protected Boolean visitBetweenPredicate(BetweenPredicate node, Void context) {
            return this.process((Node)node.getMin(), context) != false && this.process((Node)node.getValue(), context) != false && this.process((Node)node.getMax(), context) != false;
        }

        @Override
        protected Boolean visitCurrentTime(CurrentTime node, Void context) {
            return true;
        }

        @Override
        protected Boolean visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            return this.process((Node)node.getLeft(), context) != false && this.process((Node)node.getRight(), context) != false;
        }

        @Override
        protected Boolean visitComparisonExpression(ComparisonExpression node, Void context) {
            return this.process((Node)node.getLeft(), context) != false && this.process((Node)node.getRight(), context) != false;
        }

        @Override
        protected Boolean visitLiteral(Literal node, Void context) {
            return true;
        }

        @Override
        protected Boolean visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        @Override
        protected Boolean visitIsNullPredicate(IsNullPredicate node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        @Override
        protected Boolean visitLikePredicate(LikePredicate node, Void context) {
            return this.process((Node)node.getValue(), context) != false && this.process((Node)node.getPattern(), context) != false;
        }

        @Override
        protected Boolean visitInListExpression(InListExpression node, Void context) {
            return node.getValues().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        @Override
        protected Boolean visitInPredicate(InPredicate node, Void context) {
            return this.process((Node)node.getValue(), context) != false && this.process((Node)node.getValueList(), context) != false;
        }

        @Override
        protected Boolean visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Void context) {
            return this.process((Node)node.getValue(), context) != false && this.process((Node)node.getSubquery(), context) != false;
        }

        @Override
        protected Boolean visitTrim(Trim node, Void context) {
            return this.process((Node)node.getTrimSource(), context) != false && (!node.getTrimCharacter().isPresent() || this.process((Node)node.getTrimCharacter().get(), context) != false);
        }

        @Override
        protected Boolean visitFunctionCall(FunctionCall node, Void context) {
            if (ExpressionTreeUtils.isAggregationFunction(node.getName().toString())) {
                List<FunctionCall> aggregateFunctions = ExpressionTreeUtils.extractAggregateFunctions(node.getArguments());
                if (!aggregateFunctions.isEmpty()) {
                    throw new SemanticException(String.format("Cannot nest aggregations inside aggregation '%s': %s", node.getName(), aggregateFunctions));
                }
                return true;
            }
            return node.getArguments().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        @Override
        protected Boolean visitIdentifier(Identifier node, Void context) {
            if (!ScopeReferenceExtractor.hasReferencesToScope(node, AggregationAnalyzer.this.analysis, AggregationAnalyzer.this.sourceScope)) {
                return true;
            }
            return this.isGroupingKey(node);
        }

        @Override
        protected Boolean visitDereferenceExpression(DereferenceExpression node, Void context) {
            if (!ScopeReferenceExtractor.hasReferencesToScope(node, AggregationAnalyzer.this.analysis, AggregationAnalyzer.this.sourceScope)) {
                return true;
            }
            if (AggregationAnalyzer.this.columnReferences.containsKey(NodeRef.of(node))) {
                return this.isGroupingKey(node);
            }
            return this.process((Node)node.getBase(), context);
        }

        private boolean isGroupingKey(Expression node) {
            FieldId fieldId = Objects.requireNonNull((ResolvedField)AggregationAnalyzer.this.columnReferences.get(NodeRef.of(node)), () -> "No field for " + node).getFieldId();
            if (AggregationAnalyzer.this.orderByScope.isPresent() && ScopeReferenceExtractor.isFieldFromScope(fieldId, (Scope)AggregationAnalyzer.this.orderByScope.get())) {
                return true;
            }
            return AggregationAnalyzer.this.groupingFields.contains(fieldId);
        }

        @Override
        protected Boolean visitFieldReference(FieldReference node, Void context) {
            if (AggregationAnalyzer.this.orderByScope.isPresent()) {
                return true;
            }
            FieldId fieldId = Objects.requireNonNull((ResolvedField)AggregationAnalyzer.this.columnReferences.get(NodeRef.of(node)), () -> "No field for " + node).getFieldId();
            boolean inGroup = AggregationAnalyzer.this.groupingFields.contains(fieldId);
            if (!inGroup) {
                Field field = AggregationAnalyzer.this.sourceScope.getRelationType().getFieldByIndex(node.getFieldIndex());
                String column = !field.getName().isPresent() ? Integer.toString(node.getFieldIndex() + 1) : (field.getRelationAlias().isPresent() ? String.format("'%s.%s'", field.getRelationAlias().get(), field.getName().get()) : "'" + field.getName().get() + "'");
                throw new SemanticException(String.format("Column %s not in GROUP BY clause", column));
            }
            return inGroup;
        }

        @Override
        protected Boolean visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        @Override
        protected Boolean visitNotExpression(NotExpression node, Void context) {
            return this.process((Node)node.getValue(), context);
        }

        @Override
        protected Boolean visitLogicalExpression(LogicalExpression node, Void context) {
            return node.getTerms().stream().allMatch(item -> this.process((Node)item, context));
        }

        @Override
        protected Boolean visitIfExpression(IfExpression node, Void context) {
            ImmutableList.Builder expressions = ImmutableList.builder().add((Object)node.getCondition()).add((Object)node.getTrueValue());
            if (node.getFalseValue().isPresent()) {
                expressions.add((Object)node.getFalseValue().get());
            }
            return expressions.build().stream().allMatch(expression -> this.process((Node)expression, context));
        }

        @Override
        protected Boolean visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            if (!this.process((Node)node.getOperand(), context).booleanValue()) {
                return false;
            }
            for (WhenClause whenClause : node.getWhenClauses()) {
                if (this.process((Node)whenClause.getOperand(), context).booleanValue() && this.process((Node)whenClause.getResult(), context).booleanValue()) continue;
                return false;
            }
            return !node.getDefaultValue().isPresent() || this.process((Node)node.getDefaultValue().get(), context) != false;
        }

        @Override
        protected Boolean visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                if (this.process((Node)whenClause.getOperand(), context).booleanValue() && this.process((Node)whenClause.getResult(), context).booleanValue()) continue;
                return false;
            }
            return !node.getDefaultValue().isPresent() || this.process((Node)node.getDefaultValue().get(), context) != false;
        }

        @Override
        protected Boolean visitRow(Row node, Void context) {
            return node.getItems().stream().allMatch(item -> this.process((Node)item, context));
        }

        @Override
        protected Boolean visitParameter(Parameter node, Void context) {
            Map<NodeRef<Parameter>, Expression> parameters = AggregationAnalyzer.this.analysis.getParameters();
            Preconditions.checkArgument((node.getId() < parameters.size() ? 1 : 0) != 0, (String)"Invalid parameter number %s, max values is %s", (int)node.getId(), (int)(parameters.size() - 1));
            return this.process((Node)parameters.get(NodeRef.of(node)), context);
        }

        @Override
        public Boolean process(Node node, @Nullable Void context) {
            if (node instanceof Expression && AggregationAnalyzer.this.expressions.contains(ScopeAware.scopeAwareKey(node, AggregationAnalyzer.this.analysis, AggregationAnalyzer.this.sourceScope)) && (!AggregationAnalyzer.this.orderByScope.isPresent() || !this.hasOrderByReferencesToOutputColumns(node))) {
                return true;
            }
            return (Boolean)super.process(node, context);
        }

        private boolean hasOrderByReferencesToOutputColumns(Node node) {
            return ScopeReferenceExtractor.hasReferencesToScope(node, AggregationAnalyzer.this.analysis, (Scope)AggregationAnalyzer.this.orderByScope.get());
        }

        private void verifyNoOrderByReferencesToOutputColumns(Node node, String errorString) {
            ScopeReferenceExtractor.getReferencesToScope(node, AggregationAnalyzer.this.analysis, (Scope)AggregationAnalyzer.this.orderByScope.get()).findFirst().ifPresent(expression -> {
                throw new SemanticException(errorString);
            });
        }
    }
}

