/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.receiver.visitor;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanVisitor;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorRelationalPlan;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorTreePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeCreateTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeactivateTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteDevicesPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteLogicalViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteTimeSeriesPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.AddTableColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.CommitDeleteColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.CommitDeleteTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.RenameTableColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTableColumnCommentPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTableCommentPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTablePropertiesPlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.DropSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.ExtendSchemaTemplatePlan;
import org.apache.iotdb.rpc.TSStatusCode;

public class PipeConfigPhysicalPlanTSStatusVisitor
extends ConfigPhysicalPlanVisitor<TSStatus, TSStatus> {
    @Override
    public TSStatus visitPlan(ConfigPhysicalPlan plan, TSStatus context) {
        return context;
    }

    @Override
    public TSStatus visitCreateDatabase(DatabaseSchemaPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.SCHEMA_QUOTA_EXCEEDED.getStatusCode() || context.getCode() == TSStatusCode.DATABASE_CONFLICT.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.METADATA_ERROR.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_TEMPORARY_UNAVAILABLE_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitCreateDatabase(plan, context);
    }

    @Override
    public TSStatus visitAlterDatabase(DatabaseSchemaPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitAlterDatabase(plan, context);
    }

    @Override
    public TSStatus visitDeleteDatabase(DeleteDatabasePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.PATH_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitDeleteDatabase(plan, context);
    }

    @Override
    public TSStatus visitCreateSchemaTemplate(CreateSchemaTemplatePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.METADATA_ERROR.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitCreateSchemaTemplate(plan, context);
    }

    @Override
    public TSStatus visitExtendSchemaTemplate(ExtendSchemaTemplatePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.MEASUREMENT_ALREADY_EXISTS_IN_TEMPLATE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.METADATA_ERROR.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitExtendSchemaTemplate(plan, context);
    }

    @Override
    public TSStatus visitCommitSetSchemaTemplate(CommitSetSchemaTemplatePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.METADATA_ERROR.getStatusCode()) {
            if (context.getMessage().contains("Template already exists")) {
                return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
            }
            if (context.getMessage().contains("Template t1 does not exist")) {
                return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
            }
        } else if (context.getCode() == TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitCommitSetSchemaTemplate(plan, context);
    }

    @Override
    public TSStatus visitPipeUnsetSchemaTemplate(PipeUnsetSchemaTemplatePlan pipeUnsetSchemaTemplatePlan, TSStatus context) {
        if (context.getCode() == TSStatusCode.TEMPLATE_NOT_SET.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.UNDEFINED_TEMPLATE.getStatusCode() || context.getCode() == TSStatusCode.TEMPLATE_IS_IN_USE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitPipeUnsetSchemaTemplate(pipeUnsetSchemaTemplatePlan, context);
    }

    @Override
    public TSStatus visitDropSchemaTemplate(DropSchemaTemplatePlan dropSchemaTemplatePlan, TSStatus context) {
        if (context.getCode() == TSStatusCode.UNDEFINED_TEMPLATE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitDropSchemaTemplate(dropSchemaTemplatePlan, context);
    }

    @Override
    public TSStatus visitPipeDeleteTimeSeries(PipeDeleteTimeSeriesPlan pipeDeleteTimeSeriesPlan, TSStatus context) {
        if (context.getCode() == TSStatusCode.PATH_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitPipeDeleteTimeSeries(pipeDeleteTimeSeriesPlan, context);
    }

    @Override
    public TSStatus visitPipeDeleteLogicalView(PipeDeleteLogicalViewPlan pipeDeleteLogicalViewPlan, TSStatus context) {
        if (context.getCode() == TSStatusCode.PATH_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitPipeDeleteLogicalView(pipeDeleteLogicalViewPlan, context);
    }

    @Override
    public TSStatus visitPipeDeactivateTemplate(PipeDeactivateTemplatePlan pipeDeactivateTemplatePlan, TSStatus context) {
        if (context.getCode() == TSStatusCode.TEMPLATE_NOT_ACTIVATED.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitPipeDeactivateTemplate(pipeDeactivateTemplatePlan, context);
    }

    @Override
    public TSStatus visitCreateUser(AuthorTreePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.USER_ALREADY_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitCreateUser(plan, context);
    }

    @Override
    public TSStatus visitCreateRawUser(AuthorTreePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.USER_ALREADY_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitCreateRawUser(plan, context);
    }

    @Override
    public TSStatus visitUpdateUser(AuthorTreePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.USER_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitUpdateUser(plan, context);
    }

    @Override
    public TSStatus visitDropUser(AuthorTreePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.USER_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitDropUser(plan, context);
    }

    @Override
    public TSStatus visitGrantUser(AuthorTreePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.NO_PERMISSION.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.USER_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitGrantUser(plan, context);
    }

    @Override
    public TSStatus visitRevokeUser(AuthorTreePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.NOT_HAS_PRIVILEGE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.USER_NOT_EXIST.getStatusCode() || context.getCode() == TSStatusCode.NO_PERMISSION.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitRevokeUser(plan, context);
    }

    @Override
    public TSStatus visitCreateRole(AuthorTreePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.ROLE_ALREADY_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitCreateRole(plan, context);
    }

    @Override
    public TSStatus visitDropRole(AuthorTreePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.ROLE_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitDropRole(plan, context);
    }

    @Override
    public TSStatus visitGrantRole(AuthorTreePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.ROLE_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitGrantRole(plan, context);
    }

    @Override
    public TSStatus visitRevokeRole(AuthorTreePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.NOT_HAS_PRIVILEGE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.ROLE_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitRevokeRole(plan, context);
    }

    @Override
    public TSStatus visitGrantRoleToUser(AuthorTreePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.USER_ALREADY_HAS_ROLE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitGrantRoleToUser(plan, context);
    }

    @Override
    public TSStatus visitRevokeRoleFromUser(AuthorTreePlan revokeRoleFromUserPlan, TSStatus context) {
        if (context.getCode() == TSStatusCode.USER_NOT_HAS_ROLE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.ROLE_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitRevokeRoleFromUser(revokeRoleFromUserPlan, context);
    }

    @Override
    public TSStatus visitRCreateUser(AuthorRelationalPlan rCreateUserPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rCreateUserPlan, context);
    }

    @Override
    public TSStatus visitRCreateRole(AuthorRelationalPlan rCreateRolePlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rCreateRolePlan, context);
    }

    @Override
    public TSStatus visitRUpdateUser(AuthorRelationalPlan rUpdateUserPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rUpdateUserPlan, context);
    }

    @Override
    public TSStatus visitRDropUserPlan(AuthorRelationalPlan rDropUserPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rDropUserPlan, context);
    }

    @Override
    public TSStatus visitRDropRolePlan(AuthorRelationalPlan rDropRolePlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rDropRolePlan, context);
    }

    @Override
    public TSStatus visitRGrantUserRole(AuthorRelationalPlan rGrantUserRolePlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rGrantUserRolePlan, context);
    }

    @Override
    public TSStatus visitRRevokeUserRole(AuthorRelationalPlan rRevokeUserRolePlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rRevokeUserRolePlan, context);
    }

    @Override
    public TSStatus visitRGrantUserAny(AuthorRelationalPlan rGrantUserAnyPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rGrantUserAnyPlan, context);
    }

    @Override
    public TSStatus visitRGrantRoleAny(AuthorRelationalPlan rGrantRoleAnyPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rGrantRoleAnyPlan, context);
    }

    @Override
    public TSStatus visitRGrantUserAll(AuthorRelationalPlan rGrantUserAllPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rGrantUserAllPlan, context);
    }

    @Override
    public TSStatus visitRGrantRoleAll(AuthorRelationalPlan rGrantRoleAllPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rGrantRoleAllPlan, context);
    }

    @Override
    public TSStatus visitRGrantUserDB(AuthorRelationalPlan rGrantUserDBPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rGrantUserDBPlan, context);
    }

    @Override
    public TSStatus visitRGrantUserTB(AuthorRelationalPlan rGrantUserTBPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rGrantUserTBPlan, context);
    }

    @Override
    public TSStatus visitRGrantRoleDB(AuthorRelationalPlan rGrantRoleDBPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rGrantRoleDBPlan, context);
    }

    @Override
    public TSStatus visitRGrantRoleTB(AuthorRelationalPlan rGrantRoleTBPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rGrantRoleTBPlan, context);
    }

    @Override
    public TSStatus visitRRevokeUserAny(AuthorRelationalPlan rRevokeUserAnyPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rRevokeUserAnyPlan, context);
    }

    @Override
    public TSStatus visitRRevokeRoleAny(AuthorRelationalPlan rRevokeRoleAnyPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rRevokeRoleAnyPlan, context);
    }

    @Override
    public TSStatus visitRRevokeUserAll(AuthorRelationalPlan rRevokeUserAllPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rRevokeUserAllPlan, context);
    }

    @Override
    public TSStatus visitRRevokeRoleAll(AuthorRelationalPlan rRevokeRoleAllPlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rRevokeRoleAllPlan, context);
    }

    @Override
    public TSStatus visitRRevokeUserDBPrivilege(AuthorRelationalPlan rRevokeUserDBPrivilegePlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rRevokeUserDBPrivilegePlan, context);
    }

    @Override
    public TSStatus visitRRevokeUserTBPrivilege(AuthorRelationalPlan rRevokeUserTBPrivilegePlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rRevokeUserTBPrivilegePlan, context);
    }

    @Override
    public TSStatus visitRRevokeRoleDBPrivilege(AuthorRelationalPlan rRevokeRoleTBPrivilegePlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rRevokeRoleTBPrivilegePlan, context);
    }

    @Override
    public TSStatus visitRRevokeRoleTBPrivilege(AuthorRelationalPlan rRevokeRoleTBPrivilegePlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rRevokeRoleTBPrivilegePlan, context);
    }

    @Override
    public TSStatus visitRGrantUserSysPrivilege(AuthorRelationalPlan rGrantUserSysPrivilegePlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rGrantUserSysPrivilegePlan, context);
    }

    @Override
    public TSStatus visitRGrantRoleSysPrivilege(AuthorRelationalPlan rGrantRoleSysPrivilegePlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rGrantRoleSysPrivilegePlan, context);
    }

    @Override
    public TSStatus visitRRevokeUserSysPrivilege(AuthorRelationalPlan rRevokeUserSysPrivilegePlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rRevokeUserSysPrivilegePlan, context);
    }

    @Override
    public TSStatus visitRRevokeRoleSysPrivilege(AuthorRelationalPlan rRevokeRoleSysPrivilegePlan, TSStatus context) {
        return this.visitAuthorRelationalPlan(rRevokeRoleSysPrivilegePlan, context);
    }

    private TSStatus visitAuthorRelationalPlan(AuthorRelationalPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.USER_NOT_EXIST.getStatusCode() || context.getCode() == TSStatusCode.USER_ALREADY_EXIST.getStatusCode() || context.getCode() == TSStatusCode.ROLE_NOT_EXIST.getStatusCode() || context.getCode() == TSStatusCode.ROLE_ALREADY_EXIST.getStatusCode() || context.getCode() == TSStatusCode.USER_ALREADY_HAS_ROLE.getStatusCode() || context.getCode() == TSStatusCode.USER_NOT_HAS_ROLE.getStatusCode() || context.getCode() == TSStatusCode.NO_PERMISSION.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return this.visitPlan((ConfigPhysicalPlan)plan, context);
    }

    @Override
    public TSStatus visitTTL(SetTTLPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitTTL(plan, context);
    }

    @Override
    public TSStatus visitPipeCreateTable(PipeCreateTablePlan pipeCreateTablePlan, TSStatus context) {
        if (context.getCode() == TSStatusCode.DATABASE_NOT_EXIST.getStatusCode() || context.getCode() == TSStatusCode.TABLE_ALREADY_EXISTS.getStatusCode() || context.getCode() == TSStatusCode.COLUMN_ALREADY_EXISTS.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitPipeCreateTable(pipeCreateTablePlan, context);
    }

    @Override
    public TSStatus visitAddTableColumn(AddTableColumnPlan addTableColumnPlan, TSStatus context) {
        if (context.getCode() == TSStatusCode.COLUMN_ALREADY_EXISTS.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return this.visitCommonTablePlan(addTableColumnPlan, context);
    }

    @Override
    public TSStatus visitSetTableProperties(SetTablePropertiesPlan setTablePropertiesPlan, TSStatus context) {
        return this.visitCommonTablePlan(setTablePropertiesPlan, context);
    }

    @Override
    public TSStatus visitCommitDeleteColumn(CommitDeleteColumnPlan commitDeleteColumnPlan, TSStatus context) {
        return this.visitCommonTablePlan(commitDeleteColumnPlan, context);
    }

    @Override
    public TSStatus visitRenameTableColumn(RenameTableColumnPlan renameTableColumnPlan, TSStatus context) {
        return this.visitCommonTablePlan(renameTableColumnPlan, context);
    }

    @Override
    public TSStatus visitCommitDeleteTable(CommitDeleteTablePlan commitDeleteTablePlan, TSStatus context) {
        return this.visitCommonTablePlan(commitDeleteTablePlan, context);
    }

    @Override
    public TSStatus visitPipeDeleteDevices(PipeDeleteDevicesPlan pipeDeleteDevicesPlan, TSStatus context) {
        return this.visitCommonTablePlan(pipeDeleteDevicesPlan, context);
    }

    @Override
    public TSStatus visitSetTableComment(SetTableCommentPlan setTableCommentPlan, TSStatus context) {
        return this.visitCommonTablePlan(setTableCommentPlan, context);
    }

    @Override
    public TSStatus visitSetTableColumnComment(SetTableColumnCommentPlan setTableColumnCommentPlan, TSStatus context) {
        return this.visitCommonTablePlan(setTableColumnCommentPlan, context);
    }

    private TSStatus visitCommonTablePlan(ConfigPhysicalPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.DATABASE_NOT_EXIST.getStatusCode() || context.getCode() == TSStatusCode.TABLE_NOT_EXISTS.getStatusCode() || context.getCode() == TSStatusCode.COLUMN_ALREADY_EXISTS.getStatusCode() || context.getCode() == TSStatusCode.COLUMN_NOT_EXISTS.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return this.visitPlan(plan, context);
    }
}

