/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class Trim
extends Expression {
    private final Specification specification;
    private final Expression trimSource;
    @Nullable
    private final Expression trimCharacter;

    public Trim(Specification specification, Expression trimSource) {
        super(null);
        this.specification = Objects.requireNonNull(specification, "specification is null");
        this.trimSource = Objects.requireNonNull(trimSource, "trimSource is null");
        this.trimCharacter = null;
    }

    public Trim(Specification specification, Expression trimSource, Expression trimCharacter) {
        super(null);
        this.specification = Objects.requireNonNull(specification, "specification is null");
        this.trimSource = Objects.requireNonNull(trimSource, "trimSource is null");
        this.trimCharacter = Objects.requireNonNull(trimCharacter, "trimCharacter is null");
    }

    public Trim(NodeLocation location, Specification specification, Expression trimSource) {
        super(Objects.requireNonNull(location, "location is null"));
        this.specification = Objects.requireNonNull(specification, "specification is null");
        this.trimSource = Objects.requireNonNull(trimSource, "trimSource is null");
        this.trimCharacter = null;
    }

    public Trim(NodeLocation location, Specification specification, Expression trimSource, Expression trimCharacter) {
        super(Objects.requireNonNull(location, "location is null"));
        this.specification = Objects.requireNonNull(specification, "specification is null");
        this.trimSource = Objects.requireNonNull(trimSource, "trimSource is null");
        this.trimCharacter = Objects.requireNonNull(trimCharacter, "trimCharacter is null");
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public Expression getTrimSource() {
        return this.trimSource;
    }

    public Optional<Expression> getTrimCharacter() {
        return Optional.ofNullable(this.trimCharacter);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTrim(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.trimSource);
        if (this.trimCharacter != null) {
            nodes.add((Object)this.trimCharacter);
        }
        return nodes.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trim that = (Trim)o;
        return this.specification == that.specification && Objects.equals(this.trimSource, that.trimSource) && Objects.equals(this.trimCharacter, that.trimCharacter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.specification, this.trimSource, this.trimCharacter});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Trim.sameClass(this, other)) {
            return false;
        }
        Trim otherTrim = (Trim)other;
        return this.specification == otherTrim.specification;
    }

    public static enum Specification {
        BOTH("trim"),
        LEADING("ltrim"),
        TRAILING("rtrim");

        private final String functionName;

        private Specification(String functionName) {
            this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        }

        public String getFunctionName() {
            return this.functionName;
        }
    }
}

