/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OrderBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Relation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.util.ExpressionFormatter;

public class TableFunctionTableArgument
extends Node {
    private final Relation table;
    private final Optional<List<Expression>> partitionBy;
    private final Optional<OrderBy> orderBy;

    public TableFunctionTableArgument(NodeLocation location, Relation table, Optional<List<Expression>> partitionBy, Optional<OrderBy> orderBy) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy is null");
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
    }

    public Relation getTable() {
        return this.table;
    }

    public Optional<List<Expression>> getPartitionBy() {
        return this.partitionBy;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTableArgument(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.table);
        this.partitionBy.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).addAll(arg_0));
        this.orderBy.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableFunctionTableArgument other = (TableFunctionTableArgument)o;
        return Objects.equals(this.table, other.table) && Objects.equals(this.partitionBy, other.partitionBy) && Objects.equals(this.orderBy, other.orderBy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.partitionBy, this.orderBy);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.table);
        this.partitionBy.ifPresent(partitioning -> builder.append(partitioning.stream().map(Expression::toString).collect(Collectors.joining(", ", " PARTITION BY (", ")"))));
        this.orderBy.ifPresent(ordering -> builder.append(" ORDER BY (").append(ExpressionFormatter.formatSortItems(ordering.getSortItems())).append(")"));
        return builder.toString();
    }

    @Override
    public boolean shallowEquals(Node o) {
        return TableFunctionTableArgument.sameClass(this, o);
    }
}

