/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.IdFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.PreciseFilter;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.schema.ConvertSchemaPredicateToFilterVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.AlignedDeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.DeviceInCacheFilterVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.SchemaPredicateUtil;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.TableDeviceCacheAttributeGuard;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceSchemaCache;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AbstractTraverseDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FetchDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.SqlParser;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;

public class TableDeviceSchemaFetcher {
    private final SqlParser relationSqlParser = new SqlParser();
    private final Coordinator coordinator = Coordinator.getInstance();
    private final TableDeviceSchemaCache cache = TableDeviceSchemaCache.getInstance();
    private final TableDeviceCacheAttributeGuard attributeGuard = new TableDeviceCacheAttributeGuard();

    private TableDeviceSchemaFetcher() {
    }

    public static TableDeviceSchemaFetcher getInstance() {
        return TableDeviceSchemaFetcherHolder.INSTANCE;
    }

    public TableDeviceCacheAttributeGuard getAttributeGuard() {
        return this.attributeGuard;
    }

    Map<IDeviceID, Map<String, Binary>> fetchMissingDeviceSchemaForDataInsertion(FetchDevice statement, MPPQueryContext context) {
        long queryId = SessionManager.getInstance().requestQueryId();
        Throwable t = null;
        String database = statement.getDatabase();
        String table = statement.getTableName();
        TsTable tableInstance = DataNodeTableCache.getInstance().getTable(database, table);
        Set<Long> queryIdSet = this.attributeGuard.addFetchQueryId(queryId);
        try {
            ExecutionResult executionResult = this.coordinator.executeForTableModel(statement, this.relationSqlParser, SessionManager.getInstance().getCurrSession(), queryId, SessionManager.getInstance().getSessionInfoOfTableModel(SessionManager.getInstance().getCurrSession()), "Fetch Device for insert", LocalExecutionPlanner.getInstance().metadata, Long.MAX_VALUE, false);
            if (executionResult.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new IoTDBRuntimeException(executionResult.status.getMessage(), executionResult.status.getCode());
            }
            List<ColumnHeader> columnHeaderList = this.coordinator.getQueryExecution(queryId).getDatasetHeader().getColumnHeaders();
            int idLength = DataNodeTableCache.getInstance().getTable(database, table).getIdNums();
            HashMap<IDeviceID, Map<String, Binary>> fetchedDeviceSchema = new HashMap<IDeviceID, Map<String, Binary>>();
            while (this.coordinator.getQueryExecution(queryId).hasNextResult()) {
                Optional<TsBlock> tsBlock;
                try {
                    tsBlock = this.coordinator.getQueryExecution(queryId).getBatchResult();
                }
                catch (IoTDBException e) {
                    t = e;
                    throw new RuntimeException("Fetch Table Device Schema failed. ", e);
                }
                if (!tsBlock.isPresent() || tsBlock.get().isEmpty()) break;
                Column[] columns = tsBlock.get().getValueColumns();
                for (int i = 0; i < tsBlock.get().getPositionCount(); ++i) {
                    String[] nodes = new String[idLength + 1];
                    HashMap<String, Binary> attributeMap = new HashMap<String, Binary>();
                    this.constructNodsArrayAndAttributeMap(attributeMap, nodes, table, columnHeaderList, columns, tableInstance, i);
                    fetchedDeviceSchema.put(IDeviceID.Factory.DEFAULT_FACTORY.create(nodes), attributeMap);
                }
            }
            fetchedDeviceSchema.forEach((key, value) -> this.cache.putAttributes(database, (IDeviceID)key, (Map<String, Binary>)value));
            HashMap<IDeviceID, Map<String, Binary>> hashMap = fetchedDeviceSchema;
            return hashMap;
        }
        catch (Throwable throwable) {
            t = throwable;
            throw throwable;
        }
        finally {
            queryIdSet.remove(queryId);
            this.attributeGuard.tryUpdateCache();
            this.coordinator.cleanupQueryExecution(queryId, null, t);
        }
    }

    public List<DeviceEntry> fetchDeviceSchemaForDataQuery(String database, String table, List<Expression> expressionList, List<String> attributeColumns, MPPQueryContext queryContext) {
        ArrayList deviceEntryList = new ArrayList();
        ShowDevice statement = new ShowDevice(database, table);
        TsTable tableInstance = DataNodeTableCache.getInstance().getTable(database, table);
        AtomicBoolean mayContainDuplicateDevice = new AtomicBoolean(false);
        if (tableInstance == null) {
            TableMetadataImpl.throwTableNotExistsException(database, table);
        }
        if (this.parseFilter4TraverseDevice(database, tableInstance, expressionList, statement, deviceEntryList, attributeColumns, queryContext, mayContainDuplicateDevice, false)) {
            this.fetchMissingDeviceSchemaForQuery(database, tableInstance, attributeColumns, statement, deviceEntryList, queryContext);
        }
        return mayContainDuplicateDevice.get() ? new ArrayList(new LinkedHashSet(deviceEntryList)) : deviceEntryList;
    }

    public boolean parseFilter4TraverseDevice(String database, TsTable tableInstance, List<Expression> expressionList, AbstractTraverseDevice statement, List<DeviceEntry> deviceEntryList, List<String> attributeColumns, MPPQueryContext queryContext, AtomicBoolean mayContainDuplicateDevice, boolean isDirectDeviceQuery) {
        ArrayList<IDeviceID> fetchPaths;
        Pair<List<Expression>, List<Expression>> separatedExpression = SchemaPredicateUtil.separateIdDeterminedPredicate(expressionList, tableInstance, queryContext, isDirectDeviceQuery);
        List idDeterminedPredicateList = (List)separatedExpression.left;
        List idFuzzyPredicateList = (List)separatedExpression.right;
        Expression compactedIdFuzzyPredicate = SchemaPredicateUtil.compactDeviceIdFuzzyPredicate(idFuzzyPredicateList);
        List<Map<Integer, List<SchemaFilter>>> index2FilterMapList = SchemaPredicateUtil.convertDeviceIdPredicateToOrConcatList(idDeterminedPredicateList, tableInstance, mayContainDuplicateDevice);
        List<Integer> idSingleMatchIndexList = SchemaPredicateUtil.extractIdSingleMatchExpressionCases(index2FilterMapList, tableInstance);
        ArrayList<Integer> idSingleMatchPredicateNotInCache = new ArrayList<Integer>();
        boolean isExactDeviceQuery = idSingleMatchIndexList.size() == index2FilterMapList.size();
        ArrayList<IDeviceID> arrayList = fetchPaths = isExactDeviceQuery ? new ArrayList<IDeviceID>() : null;
        if (!idSingleMatchIndexList.isEmpty()) {
            SchemaFilter fuzzyFilter;
            ConvertSchemaPredicateToFilterVisitor visitor = new ConvertSchemaPredicateToFilterVisitor();
            ConvertSchemaPredicateToFilterVisitor.Context context = new ConvertSchemaPredicateToFilterVisitor.Context(tableInstance);
            DeviceInCacheFilterVisitor filterVisitor = new DeviceInCacheFilterVisitor(attributeColumns);
            Predicate<DeviceEntry> check = Objects.isNull(compactedIdFuzzyPredicate) ? o -> true : (Objects.nonNull(fuzzyFilter = compactedIdFuzzyPredicate.accept(visitor, context)) ? o -> filterVisitor.process(fuzzyFilter, o) : null);
            for (int index : idSingleMatchIndexList) {
                if (this.tryGetDeviceInCache(deviceEntryList, database, tableInstance, index2FilterMapList.get(index), check, attributeColumns, fetchPaths, isDirectDeviceQuery, queryContext)) continue;
                idSingleMatchPredicateNotInCache.add(index);
            }
        }
        if (idSingleMatchIndexList.size() < index2FilterMapList.size() || !idSingleMatchPredicateNotInCache.isEmpty()) {
            ArrayList<List<SchemaFilter>> idPredicateForFetch = new ArrayList<List<SchemaFilter>>(index2FilterMapList.size() - idSingleMatchIndexList.size() + idSingleMatchPredicateNotInCache.size());
            int idx1 = 0;
            int idx2 = 0;
            for (int i = 0; i < index2FilterMapList.size(); ++i) {
                if (idx1 >= idSingleMatchIndexList.size() || i != idSingleMatchIndexList.get(idx1)) {
                    idPredicateForFetch.add(index2FilterMapList.get(i).values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
                    continue;
                }
                ++idx1;
                if (idx2 < idSingleMatchPredicateNotInCache.size() && i != (Integer)idSingleMatchPredicateNotInCache.get(idx2)) continue;
                idPredicateForFetch.add(index2FilterMapList.get(i).values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
                ++idx2;
            }
            statement.setIdDeterminedFilterList(idPredicateForFetch);
            statement.setIdFuzzyPredicate(compactedIdFuzzyPredicate);
            statement.setPartitionKeyList(fetchPaths);
            if (!isDirectDeviceQuery && Objects.isNull(fetchPaths)) {
                statement.setAttributeColumns(attributeColumns);
            }
            return true;
        }
        return false;
    }

    private boolean tryGetDeviceInCache(List<DeviceEntry> deviceEntryList, String database, TsTable tableInstance, Map<Integer, List<SchemaFilter>> idFilters, Predicate<DeviceEntry> check, List<String> attributeColumns, List<IDeviceID> fetchPaths, boolean isDirectDeviceQuery, MPPQueryContext queryContext) {
        String[] idValues = new String[tableInstance.getIdNums()];
        for (List<SchemaFilter> schemaFilters : idFilters.values()) {
            IdFilter idFilter = (IdFilter)schemaFilters.get(0);
            SchemaFilter childFilter = idFilter.getChild();
            idValues[idFilter.getIndex()] = ((PreciseFilter)childFilter).getValue();
        }
        IDeviceID deviceID = TableDeviceSchemaFetcher.convertIdValuesToDeviceID(tableInstance.getTableName(), idValues);
        Map<String, Binary> attributeMap = this.cache.getDeviceAttribute(database, deviceID);
        if (Objects.isNull(attributeMap) || Objects.isNull(deviceEntryList) || Objects.isNull(check)) {
            if (Objects.nonNull(fetchPaths)) {
                fetchPaths.add(deviceID);
            }
            return false;
        }
        AlignedDeviceEntry deviceEntry = new AlignedDeviceEntry(deviceID, (Binary[])attributeColumns.stream().map(attributeMap::get).toArray(Binary[]::new));
        if (check.test(deviceEntry)) {
            deviceEntryList.add(deviceEntry);
            if (isDirectDeviceQuery) {
                fetchPaths.add(deviceID);
            } else {
                queryContext.reserveMemoryForFrontEnd(deviceEntry.ramBytesUsed());
            }
        }
        return true;
    }

    public static IDeviceID convertIdValuesToDeviceID(String tableName, String[] idValues) {
        String[] deviceIdNodes = new String[idValues.length + 1];
        deviceIdNodes[0] = tableName;
        System.arraycopy(idValues, 0, deviceIdNodes, 1, idValues.length);
        return IDeviceID.Factory.DEFAULT_FACTORY.create(deviceIdNodes);
    }

    private void fetchMissingDeviceSchemaForQuery(String database, TsTable tableInstance, List<String> attributeColumns, ShowDevice statement, List<DeviceEntry> deviceEntryList, MPPQueryContext mppQueryContext) {
        String table = tableInstance.getTableName();
        Throwable t = null;
        long queryId = SessionManager.getInstance().requestQueryId();
        Set<Long> queryIdSet = null;
        if (Objects.nonNull(statement.getPartitionKeyList())) {
            queryIdSet = this.attributeGuard.addFetchQueryId(queryId);
        }
        try {
            ExecutionResult executionResult = this.coordinator.executeForTableModel(statement, this.relationSqlParser, SessionManager.getInstance().getCurrSession(), queryId, SessionManager.getInstance().getSessionInfo(SessionManager.getInstance().getCurrSession()), String.format("fetch device for query %s : %s", mppQueryContext.getQueryId(), mppQueryContext.getSql()), LocalExecutionPlanner.getInstance().metadata, mppQueryContext.getTimeOut() - (System.currentTimeMillis() - mppQueryContext.getStartTime()), false);
            if (executionResult.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException(new IoTDBException(executionResult.status.getMessage(), executionResult.status.getCode()));
            }
            List<ColumnHeader> columnHeaderList = this.coordinator.getQueryExecution(queryId).getDatasetHeader().getColumnHeaders();
            int idLength = DataNodeTableCache.getInstance().getTable(database, table).getIdNums();
            while (this.coordinator.getQueryExecution(queryId).hasNextResult()) {
                Optional<TsBlock> tsBlock;
                try {
                    tsBlock = this.coordinator.getQueryExecution(queryId).getBatchResult();
                }
                catch (IoTDBException e) {
                    t = e;
                    throw new RuntimeException("Fetch Table Device Schema failed. ", e);
                }
                if (!tsBlock.isPresent()) break;
                if (tsBlock.get().isEmpty()) {
                    break;
                }
                Column[] columns = tsBlock.get().getValueColumns();
                for (int i = 0; i < tsBlock.get().getPositionCount(); ++i) {
                    String[] nodes = new String[idLength + 1];
                    HashMap<String, Binary> attributeMap = new HashMap<String, Binary>();
                    this.constructNodsArrayAndAttributeMap(attributeMap, nodes, table, columnHeaderList, columns, tableInstance, i);
                    IDeviceID deviceID = IDeviceID.Factory.DEFAULT_FACTORY.create(nodes);
                    AlignedDeviceEntry deviceEntry = new AlignedDeviceEntry(deviceID, (Binary[])attributeColumns.stream().map(attributeMap::get).toArray(Binary[]::new));
                    mppQueryContext.reserveMemoryForFrontEnd(deviceEntry.ramBytesUsed());
                    deviceEntryList.add(deviceEntry);
                    if (!Objects.nonNull(statement.getPartitionKeyList())) continue;
                    this.cache.putAttributes(database, deviceID, attributeMap);
                }
            }
        }
        catch (Throwable throwable) {
            t = throwable;
            throw throwable;
        }
        finally {
            if (Objects.nonNull(queryIdSet)) {
                queryIdSet.remove(queryId);
                this.attributeGuard.tryUpdateCache();
            }
            this.coordinator.cleanupQueryExecution(queryId, null, t);
        }
    }

    private void constructNodsArrayAndAttributeMap(Map<String, Binary> attributeMap, String[] nodes, String tableName, List<ColumnHeader> columnHeaderList, Column[] columns, TsTable tableInstance, int rowIndex) {
        nodes[0] = tableName;
        int currentIndex = 1;
        for (int j = 0; j < columnHeaderList.size(); ++j) {
            TsTableColumnSchema columnSchema = tableInstance.getColumnSchema(columnHeaderList.get(j).getColumnName());
            if (columnSchema == null) continue;
            if (columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.TAG)) {
                nodes[currentIndex] = columns[j].isNull(rowIndex) ? null : columns[j].getBinary(rowIndex).getStringValue(TSFileConfig.STRING_CHARSET);
                ++currentIndex;
                continue;
            }
            if (columns[j].isNull(rowIndex)) continue;
            attributeMap.put(columnSchema.getColumnName(), columns[j].getBinary(rowIndex));
        }
    }

    private static class TableDeviceSchemaFetcherHolder {
        private static final TableDeviceSchemaFetcher INSTANCE = new TableDeviceSchemaFetcher();

        private TableDeviceSchemaFetcherHolder() {
        }
    }
}

