/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.Utils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class LastAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(LastAccumulator.class);
    protected final TSDataType seriesDataType;
    protected TsPrimitiveType lastValue;
    protected long maxTime = Long.MIN_VALUE;
    protected boolean initResult = false;
    protected boolean isTimeColumn = false;

    public LastAccumulator(TSDataType seriesDataType, boolean isTimeColumn) {
        this.seriesDataType = seriesDataType;
        this.isTimeColumn = isTimeColumn;
        this.lastValue = TsPrimitiveType.getByType((TSDataType)seriesDataType);
    }

    public boolean hasInitResult() {
        return this.initResult;
    }

    public boolean isTimeColumn() {
        return this.isTimeColumn;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public TsPrimitiveType getLastValue() {
        return this.lastValue;
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new LastAccumulator(this.seriesDataType, this.isTimeColumn);
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.addIntInput(arguments[0], arguments[1], mask);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.addLongInput(arguments[0], arguments[1], mask);
                return;
            }
            case FLOAT: {
                this.addFloatInput(arguments[0], arguments[1], mask);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(arguments[0], arguments[1], mask);
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.addBinaryInput(arguments[0], arguments[1], mask);
                return;
            }
            case BOOLEAN: {
                this.addBooleanInput(arguments[0], arguments[1], mask);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in Last: %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column argument) {
        Preconditions.checkArgument((argument instanceof BinaryColumn || argument instanceof RunLengthEncodedColumn && ((RunLengthEncodedColumn)argument).getValue() instanceof BinaryColumn ? 1 : 0) != 0, (Object)"intermediate input and output of Last should be BinaryColumn");
        block8: for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            byte[] bytes = argument.getBinary(i).getValues();
            long time = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)0);
            int offset = 8;
            switch (this.seriesDataType) {
                case INT32: 
                case DATE: {
                    int intVal = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    this.updateIntLastValue(intVal, time);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    long longVal = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)offset);
                    this.updateLongLastValue(longVal, time);
                    continue block8;
                }
                case FLOAT: {
                    float floatVal = BytesUtils.bytesToFloat((byte[])bytes, (int)offset);
                    this.updateFloatLastValue(floatVal, time);
                    continue block8;
                }
                case DOUBLE: {
                    double doubleVal = BytesUtils.bytesToDouble((byte[])bytes, (int)offset);
                    this.updateDoubleLastValue(doubleVal, time);
                    continue block8;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    int length = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    Binary binaryVal = new Binary(BytesUtils.subBytes((byte[])bytes, (int)(offset += 4), (int)length));
                    this.updateBinaryLastValue(binaryVal, time);
                    continue block8;
                }
                case BOOLEAN: {
                    boolean boolVal = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
                    this.updateBooleanLastValue(boolVal, time);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in Last Aggregation: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output of Last should be BinaryColumn");
        if (!this.initResult) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeBinary(new Binary(Utils.serializeTimeValue(this.seriesDataType, this.maxTime, this.lastValue)));
        }
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
        } else {
            switch (this.seriesDataType) {
                case INT32: 
                case DATE: {
                    columnBuilder.writeInt(this.lastValue.getInt());
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    columnBuilder.writeLong(this.lastValue.getLong());
                    break;
                }
                case FLOAT: {
                    columnBuilder.writeFloat(this.lastValue.getFloat());
                    break;
                }
                case DOUBLE: {
                    columnBuilder.writeDouble(this.lastValue.getDouble());
                    break;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    columnBuilder.writeBinary(this.lastValue.getBinary());
                    break;
                }
                case BOOLEAN: {
                    columnBuilder.writeBoolean(this.lastValue.getBoolean());
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in Last aggregation: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        if (statistics == null || statistics[0] == null) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.updateIntLastValue((Integer)statistics[0].getLastValue(), statistics[0].getEndTime());
                break;
            }
            case INT64: {
                this.updateLongLastValue((Long)statistics[0].getLastValue(), statistics[0].getEndTime());
                break;
            }
            case TIMESTAMP: {
                this.updateLongLastValue(statistics[0].getEndTime(), statistics[0].getEndTime());
                break;
            }
            case FLOAT: {
                this.updateFloatLastValue(((Float)statistics[0].getLastValue()).floatValue(), statistics[0].getEndTime());
                break;
            }
            case DOUBLE: {
                this.updateDoubleLastValue((Double)statistics[0].getLastValue(), statistics[0].getEndTime());
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.updateBinaryLastValue((Binary)statistics[0].getLastValue(), statistics[0].getEndTime());
                break;
            }
            case BOOLEAN: {
                this.updateBooleanLastValue((Boolean)statistics[0].getLastValue(), statistics[0].getEndTime());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Last Aggregation: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.maxTime = Long.MIN_VALUE;
        this.lastValue.reset();
    }

    protected void addIntInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateIntLastValue(valueColumn.getInt(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateIntLastValue(valueColumn.getInt(position), timeColumn.getLong(position));
            }
        }
    }

    protected void updateIntLastValue(int value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setInt(value);
        }
    }

    protected void addLongInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateLongLastValue(valueColumn.getLong(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateLongLastValue(valueColumn.getLong(position), timeColumn.getLong(position));
            }
        }
    }

    protected void updateLongLastValue(long value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setLong(value);
        }
    }

    protected void addFloatInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateFloatLastValue(valueColumn.getFloat(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateFloatLastValue(valueColumn.getFloat(position), timeColumn.getLong(position));
            }
        }
    }

    protected void updateFloatLastValue(float value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setFloat(value);
        }
    }

    protected void addDoubleInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateDoubleLastValue(valueColumn.getDouble(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateDoubleLastValue(valueColumn.getDouble(position), timeColumn.getLong(position));
            }
        }
    }

    protected void updateDoubleLastValue(double value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setDouble(value);
        }
    }

    protected void addBinaryInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateBinaryLastValue(valueColumn.getBinary(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateBinaryLastValue(valueColumn.getBinary(position), timeColumn.getLong(position));
            }
        }
    }

    protected void updateBinaryLastValue(Binary value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setBinary(value);
        }
    }

    protected void addBooleanInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateBooleanLastValue(valueColumn.getBoolean(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateBooleanLastValue(valueColumn.getBoolean(position), timeColumn.getLong(position));
            }
        }
    }

    protected void updateBooleanLastValue(boolean value, long curTime) {
        this.initResult = true;
        if (curTime > this.maxTime) {
            this.maxTime = curTime;
            this.lastValue.setBoolean(value);
        }
    }
}

