/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame;

import org.apache.iotdb.db.queryengine.plan.relational.planner.SortOrder;

public class FrameInfo {
    private final FrameType frameType;
    private final FrameBoundType startType;
    private final int startOffsetChannel;
    private final FrameBoundType endType;
    private final int endOffsetChannel;
    private final int sortChannel;
    private final SortOrder sortOrder;

    public FrameInfo(FrameType frameType, FrameBoundType startType, FrameBoundType endType) {
        this(frameType, startType, -1, endType, -1);
    }

    public FrameInfo(FrameType frameType, FrameBoundType startType, int startOffsetChannel, FrameBoundType endType) {
        this(frameType, startType, startOffsetChannel, endType, -1);
    }

    public FrameInfo(FrameType frameType, FrameBoundType startType, int startOffsetChannel, FrameBoundType endType, int sortChannel, SortOrder sortOrder) {
        this(frameType, startType, startOffsetChannel, endType, -1, sortChannel, sortOrder);
    }

    public FrameInfo(FrameType frameType, FrameBoundType startType, FrameBoundType endType, int endOffsetChannel) {
        this(frameType, startType, -1, endType, endOffsetChannel);
    }

    public FrameInfo(FrameType frameType, FrameBoundType startType, FrameBoundType endType, int endOffsetChannel, int sortChannel, SortOrder sortOrder) {
        this(frameType, startType, -1, endType, endOffsetChannel, sortChannel, sortOrder);
    }

    public FrameInfo(FrameType frameType, FrameBoundType startType, int startOffsetChannel, FrameBoundType endType, int endOffsetChannel) {
        this(frameType, startType, startOffsetChannel, endType, endOffsetChannel, -1, SortOrder.ASC_NULLS_FIRST);
    }

    public FrameInfo(FrameType frameType, FrameBoundType startType, int startOffsetChannel, FrameBoundType endType, int endOffsetChannel, int sortChannel, SortOrder sortOrder) {
        this.frameType = frameType;
        this.startType = startType;
        this.startOffsetChannel = startOffsetChannel;
        this.endType = endType;
        this.endOffsetChannel = endOffsetChannel;
        this.sortChannel = sortChannel;
        this.sortOrder = sortOrder;
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public FrameBoundType getStartType() {
        return this.startType;
    }

    public FrameBoundType getEndType() {
        return this.endType;
    }

    public int getStartOffsetChannel() {
        return this.startOffsetChannel;
    }

    public int getEndOffsetChannel() {
        return this.endOffsetChannel;
    }

    public int getSortChannel() {
        return this.sortChannel;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static enum FrameType {
        RANGE,
        ROWS,
        GROUPS;

    }

    public static enum FrameBoundType {
        UNBOUNDED_PRECEDING,
        PRECEDING,
        CURRENT_ROW,
        FOLLOWING,
        UNBOUNDED_FOLLOWING;

    }
}

